/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.impl;

import com.spacekiller.util.midi.MidiMessageFactory;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;

public class DefaultMidiMessageFactory
implements MidiMessageFactory {
    @Override
    public MidiMessage createNoteOffMessage(int channel, int key, int velocity) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(128, channel, key, velocity);
        return msg;
    }

    @Override
    public MidiMessage createNoteOnMessage(int channel, int key, int velocity) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(144, channel, key, velocity);
        return msg;
    }

    @Override
    public MidiMessage createPolyphonPressureMessage(int channel, int key, int velocity) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(160, channel, key, velocity);
        return msg;
    }

    @Override
    public MidiMessage createChannelPressureMessage(int channel, int velocity) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(208, channel, velocity, 0);
        return msg;
    }

    @Override
    public MidiMessage createProgramChangeMessage(int channel, int program) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(192, channel, program, 0);
        return msg;
    }

    @Override
    public MidiMessage createControlChangeMessage(int channel, int controller, int value) throws InvalidMidiDataException {
        ShortMessage msg = new ShortMessage();
        msg.setMessage(176, channel, controller, value);
        return msg;
    }
}

