/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.impl;

import com.spacekiller.util.midi.MidiMeta;
import javax.sound.midi.MetaMessage;

public class DefaultMidiMeta
implements MidiMeta {
    protected int type;
    protected int size;
    protected byte[] data;

    protected DefaultMidiMeta() {
    }

    public DefaultMidiMeta(int type, int size, byte[] data) {
        this();
        this.type = type;
        this.size = size;
        this.data = data;
    }

    public String toString() {
        return super.toString() + "[type=0x" + Integer.toHexString(this.type) + ", size=" + this.size + "]";
    }

    @Override
    public int getType() {
        return this.type;
    }

    protected void setType(int type) {
        this.type = type;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    protected void setSize(int size) {
        this.size = size;
    }

    protected byte[] getData() {
        return this.data;
    }

    protected void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public void read(int ofs, byte[] dst, int off, int len) throws ArrayIndexOutOfBoundsException {
        System.arraycopy(this.data, ofs, dst, off, len);
    }

    public static boolean isMetaMessage(int status) {
        return status == 255;
    }

    public static MidiMeta parseMidiMeta(MetaMessage msg) {
        int status = msg.getStatus();
        if (status != 255) {
            return null;
        }
        int type = msg.getType();
        byte[] data = msg.getData();
        int size = data.length;
        return DefaultMidiMeta.parseMidiMeta(type, data, size);
    }

    public static MidiMeta parseMidiMeta(byte[] msg, int off, int len) {
        int maxLen;
        int idx;
        if (len < 3) {
            return null;
        }
        int status = msg[off] & 0xFF;
        if (!DefaultMidiMeta.isMetaMessage(status)) {
            return null;
        }
        int type = msg[off + 1] & 0xFF;
        int end = off + len;
        long varInt = 0L;
        for (idx = off + 2; idx < end; ++idx) {
            int val = msg[idx] & 0xFF;
            varInt = varInt << 7 | (long)(val & 0x7F);
            if ((val & 0x80) != 0) continue;
            ++idx;
            break;
        }
        if (varInt > (long)(maxLen = end - idx) || varInt < 0L) {
            return null;
        }
        int dataLen = (int)varInt;
        byte[] data = new byte[dataLen];
        System.arraycopy(msg, idx, data, 0, dataLen);
        return DefaultMidiMeta.parseMidiMeta(type, data, dataLen);
    }

    public static MidiMeta parseMidiMeta(int type, byte[] data, int size) {
        switch (type) {
            case 0: {
                return new SequenceNumberImpl(type, size, data);
            }
            case 1: {
                return new TextEventImpl(type, size, data);
            }
            case 2: {
                return new CopyrightNoticeImpl(type, size, data);
            }
            case 3: {
                return new SequenceNameImpl(type, size, data);
            }
            case 4: {
                return new InstrumentNameImpl(type, size, data);
            }
            case 5: {
                return new LyricTextImpl(type, size, data);
            }
            case 6: {
                return new MarkerTextImpl(type, size, data);
            }
            case 7: {
                return new CuePointImpl(type, size, data);
            }
            case 8: {
                return new ProgramNameImpl(type, size, data);
            }
            case 9: {
                return new DeviceNameImpl(type, size, data);
            }
            case 32: {
                return new MidiChannelPrefixAssignmentImpl(type, size, data);
            }
            case 33: {
                return new MidiPortImpl(type, size, data);
            }
            case 47: {
                return new EndOfTrackImpl(type, size, data);
            }
            case 81: {
                return new TempoSettingImpl(type, size, data);
            }
            case 84: {
                return new SmpteOffsetImpl(type, size, data);
            }
            case 88: {
                return new TimeSignatureImpl(type, size, data);
            }
            case 89: {
                return new KeySignatureImpl(type, size, data);
            }
            case 127: {
                return new SequencerSpecificEventImpl(type, size, data);
            }
        }
        return new DefaultMidiMeta(type, size, data);
    }

    public static class SequencerSpecificEventImpl
    extends DefaultMidiMeta
    implements MidiMeta.SequencerSpecificEvent {
        public SequencerSpecificEventImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class KeySignatureImpl
    extends DefaultMidiMeta
    implements MidiMeta.KeySignature {
        public KeySignatureImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class TimeSignatureImpl
    extends DefaultMidiMeta
    implements MidiMeta.TimeSignature {
        public TimeSignatureImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class SmpteOffsetImpl
    extends DefaultMidiMeta
    implements MidiMeta.SmpteOffset {
        public SmpteOffsetImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class TempoSettingImpl
    extends DefaultMidiMeta
    implements MidiMeta.TempoSetting {
        protected int microsecondsPerQuarterNote;

        public TempoSettingImpl(int type, int size, byte[] data) {
            super(type, size, data);
            int num = -1;
            if (size == 3) {
                num = data[0] & 0x7F;
                num = num << 7 | data[1] & 0x7F;
                num = num << 7 | data[2] & 0x7F;
            }
            this.microsecondsPerQuarterNote = num;
        }

        @Override
        public int getMicrosecondsPerQuarterNote() {
            return this.microsecondsPerQuarterNote;
        }

        @Override
        public double getBeatsPerMinute() {
            int microsPerQuarter = this.microsecondsPerQuarterNote;
            double beatsPerMinute = 6.0E7 / (double)microsPerQuarter / 4.0;
            return beatsPerMinute;
        }
    }

    public static class EndOfTrackImpl
    extends DefaultMidiMeta
    implements MidiMeta.EndOfTrack {
        public EndOfTrackImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class MidiPortImpl
    extends DefaultMidiMeta
    implements MidiMeta.MidiPort {
        protected int midiPort;

        public MidiPortImpl(int type, int size, byte[] data) {
            super(type, size, data);
            int num = -1;
            if (size == 1) {
                num = data[0] & 0x7F;
            }
            this.midiPort = num;
        }

        @Override
        public int getMidiPort() {
            return this.midiPort;
        }
    }

    public static class MidiChannelPrefixAssignmentImpl
    extends DefaultMidiMeta
    implements MidiMeta.MidiChannelPrefixAssignment {
        protected int midiChannel;

        public MidiChannelPrefixAssignmentImpl(int type, int size, byte[] data) {
            super(type, size, data);
            int num = -1;
            if (size == 1) {
                num = data[0] & 0x7F;
            }
            this.midiChannel = num;
        }

        @Override
        public int getMidiChannel() {
            return this.midiChannel;
        }
    }

    public static class DeviceNameImpl
    extends TextImpl
    implements MidiMeta.DeviceName {
        public DeviceNameImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class ProgramNameImpl
    extends TextImpl
    implements MidiMeta.ProgramName {
        public ProgramNameImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class CuePointImpl
    extends TextImpl
    implements MidiMeta.CuePoint {
        public CuePointImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class MarkerTextImpl
    extends TextImpl
    implements MidiMeta.MarkerText {
        public MarkerTextImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class LyricTextImpl
    extends TextImpl
    implements MidiMeta.LyricText {
        public LyricTextImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class InstrumentNameImpl
    extends TextImpl
    implements MidiMeta.InstrumentName {
        public InstrumentNameImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class SequenceNameImpl
    extends TextImpl
    implements MidiMeta.SequenceName {
        public SequenceNameImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class CopyrightNoticeImpl
    extends TextImpl
    implements MidiMeta.CopyrightNotice {
        public CopyrightNoticeImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class TextEventImpl
    extends TextImpl
    implements MidiMeta.TextEvent {
        public TextEventImpl(int type, int size, byte[] data) {
            super(type, size, data);
        }
    }

    public static class SequenceNumberImpl
    extends DefaultMidiMeta
    implements MidiMeta.SequenceNumber {
        protected int sequenceNumber;

        public SequenceNumberImpl(int type, int size, byte[] data) {
            super(type, size, data);
            int num = -1;
            if (size == 2) {
                num = data[0] & 0x7F;
                num = num << 7 | data[1] & 0x7F;
            }
            this.sequenceNumber = num;
        }

        @Override
        public int getSequenceNumber() {
            return this.sequenceNumber;
        }
    }

    public static abstract class TextImpl
    extends DefaultMidiMeta
    implements MidiMeta.Text {
        protected String text;

        public TextImpl(int type, int size, byte[] data) {
            super(type, size, data);
            this.text = new String(data);
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

