/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.impl;

import com.spacekiller.util.midi.MidiListener;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;

public class MidiChannelHandler
implements MidiListener {
    private MidiChannel midiChannel;

    public MidiChannelHandler(MidiChannel midiChannel) {
        this.midiChannel = midiChannel;
    }

    @Override
    public void send(MidiEvent event) {
        this.send(event.getMessage(), event.getTick());
    }

    @Override
    public void send(MidiMessage message, long time) {
        byte[] data = message.getMessage();
        switch (data[0] & 0xF0) {
            case 176: {
                byte controller = data[1];
                byte value = data[2];
                switch (controller) {
                    case 120: {
                        this.midiChannel.allSoundOff();
                        return;
                    }
                    case 121: {
                        this.midiChannel.resetAllControllers();
                        return;
                    }
                    case 122: {
                        this.midiChannel.localControl(value != 0);
                        return;
                    }
                    case 123: {
                        this.midiChannel.allNotesOff();
                        return;
                    }
                    case 124: {
                        this.midiChannel.setOmni(false);
                        return;
                    }
                    case 125: {
                        this.midiChannel.setOmni(true);
                        return;
                    }
                    case 126: {
                        this.midiChannel.setMono(true);
                        return;
                    }
                    case 127: {
                        this.midiChannel.setMono(false);
                        return;
                    }
                }
                this.midiChannel.controlChange(controller, value);
                return;
            }
            case 128: {
                this.midiChannel.noteOff(data[1], data[2]);
                return;
            }
            case 144: {
                this.midiChannel.noteOn(data[1], data[2]);
                return;
            }
            case 160: {
                this.midiChannel.setPolyPressure(data[1], data[2]);
                return;
            }
            case 192: {
                this.midiChannel.programChange(data[1]);
                return;
            }
            case 208: {
                this.midiChannel.setChannelPressure(data[1]);
                return;
            }
            case 224: {
                int lsb = data[1] & 0x7F;
                int msb = data[2] & 0x7F;
                int bend = msb << 7 | lsb;
                this.midiChannel.setPitchBend(bend);
                return;
            }
        }
    }
}

