/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.impl;

import com.spacekiller.util.midi.MidiListener;
import com.spacekiller.util.midi.impl.MultiMidiHandler;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;

public class MidiDeviceHandler
implements MidiListener {
    private final MidiDevice device;
    private MidiListener omni;
    private MidiListener[] channels;

    public MidiDeviceHandler(MidiDevice device) {
        this.device = device;
        this.channels = new MidiListener[16];
    }

    @Override
    public void send(MidiEvent event) {
        int status;
        MidiListener listener = this.omni;
        if (listener != null) {
            listener.send(event);
        }
        if ((status = event.getMessage().getStatus()) < 240 && status >= 128 && (listener = this.channels[status & 0xF]) != null) {
            listener.send(event);
        }
    }

    @Override
    public void send(MidiMessage message, long time) {
        int status;
        MidiListener listener = this.omni;
        if (listener != null) {
            listener.send(message, time);
        }
        if ((status = message.getStatus()) < 240 && status >= 128 && (listener = this.channels[status & 0xF]) != null) {
            listener.send(message, time);
        }
    }

    public void addMidiListener(MidiListener listener) {
        this.addMidiListener(listener, -1);
    }

    public void addMidiListener(MidiListener listener, int channel) {
        if (listener == null) {
            return;
        }
        if (channel < 0) {
            MidiListener x = this.omni;
            if (x == null) {
                this.omni = listener;
            } else if (x instanceof MultiMidiHandler) {
                MultiMidiHandler m = (MultiMidiHandler)x;
                m.addMidiListener(listener);
            } else {
                this.omni = new MultiMidiHandler(new MidiListener[]{x, listener});
            }
            return;
        }
        MidiListener x = this.channels[channel];
        if (x == null) {
            this.channels[channel] = listener;
        } else if (x instanceof MultiMidiHandler) {
            MultiMidiHandler m = (MultiMidiHandler)x;
            m.addMidiListener(listener);
        } else {
            this.channels[channel] = new MultiMidiHandler(new MidiListener[]{x, listener});
        }
    }

    public void removeMidiListener(MidiListener listener) {
        this.removeMidiListener(listener, -1);
    }

    public void removeMidiListener(MidiListener listener, int channel) {
        if (listener == null) {
            return;
        }
        if (channel < 0) {
            MidiListener x = this.omni;
            if (x != null) {
                if (x == listener) {
                    this.omni = null;
                } else if (x instanceof MultiMidiHandler) {
                    MultiMidiHandler m = (MultiMidiHandler)x;
                    m.removeMidiListener(listener);
                }
            }
            return;
        }
        MidiListener x = this.channels[channel];
        if (x != null) {
            if (x == listener) {
                this.channels[channel] = null;
            } else if (x instanceof MultiMidiHandler) {
                MultiMidiHandler m = (MultiMidiHandler)x;
                m.removeMidiListener(listener);
            }
        }
    }

    public MidiDevice getDevice() {
        return this.device;
    }
}

