/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.impl;

import com.spacekiller.util.midi.MidiFilter;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.MidiListener;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;

public class MidiLogger
implements MidiListener {
    private Logger logger;
    private Level level;
    private MidiFormatter formatter;
    private MidiFilter filter;

    public MidiLogger() {
        this.setLogger(Logger.getLogger(this.getClass().getName()));
        this.setLevel(Level.INFO);
        this.setFormatter(DefaultMidiFormatter.getSharedInstance());
        this.setFilter(MidiFilter.SPAM_FILTER);
    }

    public MidiLogger(Logger logger, Level level, MidiFormatter formatter, MidiFilter filter) {
        this.setLogger(logger);
        this.setLevel(level);
        this.setFormatter(formatter);
        this.setFilter(filter);
    }

    @Override
    public void send(MidiEvent event) {
        if (this.logger.isLoggable(this.level) && this.filter.accept(event.getMessage())) {
            this.logger.log(this.level, this.formatter.formatMidiEvent(event));
        }
    }

    @Override
    public void send(MidiMessage message, long time) {
        if (this.logger.isLoggable(this.level) && this.filter.accept(message)) {
            this.logger.log(this.level, this.formatter.formatMidiEvent(message, time));
        }
    }

    public MidiFilter getFilter() {
        return this.filter;
    }

    public void setFilter(MidiFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter must not be null");
        }
        this.filter = filter;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger must not be null");
        }
        this.logger = logger;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("level must not be null");
        }
        this.level = level;
    }

    public MidiFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(MidiFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("formatter must not be null");
        }
        this.formatter = formatter;
    }
}

