/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.impl;

import com.spacekiller.util.midi.MidiListener;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;

public class MultiMidiHandler
implements MidiListener {
    private MidiListener[] listeners;

    public MultiMidiHandler(MidiListener[] listeners) {
        this.listeners = listeners;
    }

    @Override
    public void send(MidiEvent event) {
        MidiListener[] listeners = this.listeners;
        int count = listeners.length;
        for (int i = 0; i < count; ++i) {
            listeners[i].send(event);
        }
    }

    @Override
    public void send(MidiMessage message, long time) {
        MidiListener[] listeners = this.listeners;
        int count = listeners.length;
        for (int i = 0; i < count; ++i) {
            listeners[i].send(message, time);
        }
    }

    public int getListenerCount() {
        return this.listeners.length;
    }

    public void addMidiListener(MidiListener l) {
        if (l == null) {
            return;
        }
        MidiListener[] old = this.listeners;
        MidiListener[] arr = new MidiListener[old.length + 1];
        System.arraycopy(old, 0, arr, 0, old.length);
        arr[old.length] = l;
        this.listeners = arr;
    }

    public void removeMidiListener(MidiListener l) {
        if (l == null) {
            return;
        }
        MidiListener[] old = this.listeners;
        int index = -1;
        for (int i = 0; i < old.length; ++i) {
            if (old[i] != l) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        MidiListener[] arr = new MidiListener[old.length - 1];
        System.arraycopy(old, 0, arr, 0, index);
        System.arraycopy(old, index + 1, arr, index, old.length - index - 1);
        this.listeners = arr;
    }
}

