/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.ArtifactDependency;
import com.spacekiller.infection.ArtifactLibPathEntry;
import com.spacekiller.infection.InfectionSite;
import java.util.ArrayList;
import java.util.List;

public class Artifact
implements Cloneable {
    public static final int UNKNOWN_LENGTH = -1;
    public static final int UNKNOWN_CHECKSUM = -1;
    public static final String DEPLOY_JAR = "jar";
    public static final String DEPLOY_UNZIP = "unzip";
    public static final int INSTALL_MODE_AUTO = 0;
    public static final int INSTALL_MODE_MANUAL = 1;
    private InfectionSite site;
    private String name;
    private String title;
    private String version;
    private String vendor;
    private String path;
    private int length = -1;
    private int checksum = -1;
    private long time;
    private String deploy = "jar";
    private String osPrefix;
    private String osArch;
    private List classPath;
    private List libPath;
    private List dependencies;
    private long installTime;
    private int installMode;

    public Artifact() {
        this.init();
    }

    public Artifact(Artifact fact) {
        this();
        this.setChecksum(fact.getChecksum());
        this.setDeploy(fact.getDeploy());
        this.setLength(fact.getLength());
        this.setName(fact.getName());
        this.setPath(fact.getPath());
        this.setTime(fact.getTime());
        this.setTitle(fact.getTitle());
        this.setVendor(fact.getVendor());
        this.setVersion(fact.getVersion());
        this.dependencies.addAll(fact.dependencies);
        this.classPath.addAll(fact.classPath);
        this.libPath.addAll(fact.libPath);
    }

    protected void init() {
        this.dependencies = this.createList();
        this.classPath = this.createList();
        this.libPath = this.createList();
    }

    protected List createList() {
        return new ArrayList();
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setChecksum(int checksum) {
        this.checksum = checksum;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public int getDependencyCount() {
        return this.dependencies == null ? 0 : this.dependencies.size();
    }

    public ArtifactDependency getDependencyAt(int i) {
        return (ArtifactDependency)this.dependencies.get(i);
    }

    public void addDependency(ArtifactDependency dep) {
        if (dep == null) {
            throw new NullPointerException("dependency is null");
        }
        this.dependencies.add(dep);
    }

    public void removeDependency(ArtifactDependency dep) {
        this.dependencies.remove(dep);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getClassPathEntryCount() {
        return this.classPath == null ? 0 : this.classPath.size();
    }

    public String getClassPathEntryAt(int i) {
        return (String)this.classPath.get(i);
    }

    public void addClassPathEntry(String path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        this.classPath.add(path);
    }

    public void removeClassPathEntry(String path) {
        this.classPath.remove(path);
    }

    public int getLibPathEntryCount() {
        return this.libPath == null ? 0 : this.libPath.size();
    }

    public ArtifactLibPathEntry getLibPathEntryAt(int i) {
        return (ArtifactLibPathEntry)this.libPath.get(i);
    }

    public void addLibPathEntry(ArtifactLibPathEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is null");
        }
        this.libPath.add(entry);
    }

    public void removeLibPathEntry(ArtifactLibPathEntry entry) {
        this.libPath.remove(entry);
    }

    public String getDeploy() {
        return this.deploy;
    }

    public void setDeploy(String deploy) {
        this.deploy = deploy;
    }

    public InfectionSite getSite() {
        return this.site;
    }

    public void setSite(InfectionSite site) {
        this.site = site;
    }

    public String toString() {
        return "Artifact[name=" + this.name + ", version=" + this.version + "]";
    }

    public String getOsArch() {
        return this.osArch;
    }

    public void setOsArch(String arch) {
        this.osArch = arch;
    }

    public String getOsPrefix() {
        return this.osPrefix;
    }

    public void setOsPrefix(String os) {
        this.osPrefix = os;
    }

    public long getInstallTime() {
        return this.installTime;
    }

    public void setInstallTime(long installTime) {
        this.installTime = installTime;
    }

    public int getInstallMode() {
        return this.installMode;
    }

    public void setInstallMode(int installMode) {
        this.installMode = installMode;
    }

    public Artifact cloneArtifact() throws Exception {
        Artifact clone = (Artifact)super.clone();
        List list = this.createList();
        list.addAll(this.classPath);
        clone.classPath = list;
        list = this.createList();
        list.addAll(this.libPath);
        clone.libPath = list;
        list = this.createList();
        list.addAll(this.dependencies);
        clone.dependencies = list;
        return clone;
    }
}

