/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.Artifact;

public class ArtifactDependency {
    private String artifact;
    private String version;
    private String minVersion;
    private String maxVersion;
    private boolean optional;
    private double weight;

    public ArtifactDependency(String artifact, String version) {
        this.artifact = artifact;
        this.version = version;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String toString() {
        return "ArtifactDependency[artifact=" + this.artifact + ", version=" + this.version + ", min=" + this.minVersion + ", max=" + this.maxVersion + "]";
    }

    public boolean acceptArtifactName(String artifactName) {
        String depName = this.getArtifact();
        if (depName == null) {
            return depName == artifactName;
        }
        return depName.equals(artifactName);
    }

    public boolean acceptArtifactVersion(String artifactVerion) {
        String maxVersion;
        String version = this.getVersion();
        String minVersion = this.getMinVersion();
        if (version != null) {
            if (artifactVerion == null) {
                return false;
            }
            int comp = artifactVerion.compareTo(version);
            if (comp == 0) {
                return true;
            }
            if (comp < 0 && minVersion == null) {
                return false;
            }
        }
        if (minVersion != null) {
            if (artifactVerion == null) {
                return false;
            }
            if (artifactVerion.compareTo(minVersion) < 0) {
                return false;
            }
        }
        if ((maxVersion = this.getMaxVersion()) != null) {
            if (artifactVerion == null) {
                return false;
            }
            if (artifactVerion.compareTo(maxVersion) > 0) {
                return false;
            }
        }
        return true;
    }

    public boolean acceptArtifact(Artifact artifact) {
        if (artifact == null) {
            return false;
        }
        String artName = artifact.getName();
        if (!this.acceptArtifactName(artName)) {
            return false;
        }
        String artVersion = artifact.getVersion();
        return this.acceptArtifactVersion(artVersion);
    }
}

