/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.Debug;
import com.spacekiller.infection.InfectionUtil;
import java.io.File;

public class InfectionSelfTest {
    protected InfectionSelfTest() {
    }

    public static void main(String[] args) {
        try {
            double javaVersion = Debug.getJavaVersion();
            System.out.println("Detected Java Version: " + javaVersion);
            InfectionSelfTest.performSelfTest();
            System.out.println("Success.");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void performSelfTest() throws Exception {
        InfectionSelfTest self = new InfectionSelfTest();
        self.testJava();
        self.testInfectionMethods();
    }

    protected void testJava() throws Exception {
        double javaVersion = Debug.getJavaVersion();
        if (javaVersion < 1.1) {
            throw new Exception("Unsupported java version: " + javaVersion);
        }
        if (javaVersion >= 1.1) {
            this.testJava11();
        }
        if (javaVersion >= 1.2) {
            this.testJava12();
        }
        if (javaVersion >= 1.3) {
            this.testJava13();
            this.testJava13x();
        }
        if (javaVersion >= 1.4) {
            this.testJava14();
        }
        if (javaVersion >= 1.5) {
            this.testJava15();
        }
        if (javaVersion >= 1.6) {
            this.testJava16();
        }
    }

    protected void testJava11() throws Exception {
        Class.forName("java.lang.System");
        Class.forName("java.lang.Runtime");
        Class.forName("java.lang.Math");
        Class.forName("java.util.Vector").newInstance();
        Class.forName("java.util.Hashtable").newInstance();
        Class.forName("java.util.Properties");
        Class.forName("java.util.Dictionary");
        Class.forName("java.util.Date");
        Class.forName("java.util.Calendar");
        Class.forName("java.util.Locale");
        Class.forName("java.util.TimeZone");
        Class.forName("java.io.File");
        Class.forName("java.net.URL");
        long ms1 = System.currentTimeMillis();
        Thread.sleep(100L);
        long ms2 = System.currentTimeMillis();
        if (ms1 >= ms2) {
            throw new Exception("System.currentTimeMillis failed: " + ms1 + " >= " + ms2);
        }
        this.testArrayCopy();
        Class.forName("java.awt.Graphics");
        Class.forName("java.awt.Toolkit");
        Class.forName("java.awt.Rectangle");
        Class.forName("java.awt.Point");
        Class.forName("java.awt.Polygon");
        Class.forName("java.awt.Font");
        Class.forName("java.awt.FontMetrics");
        Class.forName("java.awt.Image");
        Class.forName("java.awt.Button");
        Class.forName("java.awt.Label");
        Class.forName("java.awt.Panel");
        Class.forName("java.awt.Window");
        Class.forName("java.awt.Frame");
    }

    protected void testJava12() throws Exception {
        Class.forName("java.util.Collection");
        Class.forName("java.util.List");
        Class.forName("java.util.Set");
        Class.forName("java.util.Map");
        Class.forName("java.util.ArrayList").newInstance();
        Class.forName("java.util.LinkedList").newInstance();
        Class.forName("java.util.HashSet").newInstance();
        Class.forName("java.util.HashMap").newInstance();
        Class.forName("java.util.TreeMap").newInstance();
        Class.forName("java.awt.Graphics2D");
        Class.forName("java.awt.geom.Rectangle2D");
        Class.forName("javax.swing.Icon");
        Class.forName("javax.swing.JComponent");
        Class.forName("javax.swing.JButton");
        Class.forName("javax.swing.JLabel");
        Class.forName("javax.swing.JFrame");
    }

    protected void testJava13() throws Exception {
        Class.forName("java.lang.StrictMath");
    }

    protected void testJava13x() throws Exception {
        Class.forName("javax.sound.sampled.AudioSystem");
    }

    protected void testJava14() throws Exception {
        Class.forName("java.util.logging.Logger");
        Class.forName("java.util.regex.Pattern");
        Class.forName("java.awt.image.BufferStrategy");
    }

    protected void testJava15() throws Exception {
        System.class.getMethod("nanoTime", new Class[0]);
    }

    protected void testJava16() throws Exception {
    }

    private void testArrayCopy() throws Exception {
        this.testIntArrayCopy();
        this.testLongArrayCopy();
        this.testFloatArrayCopy();
        this.testDoubleArrayCopy();
    }

    private void testIntArrayCopy() throws Exception {
        int i;
        int len = 10;
        int[] src = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            src[i2] = i2;
        }
        int[] dst = new int[len];
        System.arraycopy(src, 0, dst, 0, len);
        for (i = 0; i < len; ++i) {
            if (dst[i] == src[i]) continue;
            throw new IllegalStateException("Invalid array-copy value #" + i + ": " + dst[i] + " != " + src[i]);
        }
        System.arraycopy(dst, 0, dst, 1, len - 1);
        for (i = 1; i < len; ++i) {
            if (dst[i] == src[i - 1]) continue;
            throw new IllegalStateException("Invalid array-move(fwd) value #" + i + ": " + dst[i] + " != " + src[i - 1]);
        }
    }

    private void testLongArrayCopy() throws Exception {
        int i;
        int len = 10;
        long[] src = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            src[i2] = i2;
        }
        long[] dst = new long[len];
        System.arraycopy(src, 0, dst, 0, len);
        for (i = 0; i < len; ++i) {
            if (dst[i] == src[i]) continue;
            throw new IllegalStateException("Invalid array-copy value #" + i + ": " + dst[i] + " != " + src[i]);
        }
        System.arraycopy(dst, 0, dst, 1, len - 1);
        for (i = 1; i < len; ++i) {
            if (dst[i] == src[i - 1]) continue;
            throw new IllegalStateException("Invalid array-move(fwd) value #" + i + ": " + dst[i] + " != " + src[i - 1]);
        }
    }

    private void testFloatArrayCopy() throws Exception {
        int i;
        int len = 10;
        float[] src = new float[len];
        for (int i2 = 0; i2 < len; ++i2) {
            src[i2] = i2;
        }
        float[] dst = new float[len];
        System.arraycopy(src, 0, dst, 0, len);
        for (i = 0; i < len; ++i) {
            if (dst[i] == src[i]) continue;
            throw new IllegalStateException("Invalid array-copy value #" + i + ": " + dst[i] + " != " + src[i]);
        }
        System.arraycopy(dst, 0, dst, 1, len - 1);
        for (i = 1; i < len; ++i) {
            if (dst[i] == src[i - 1]) continue;
            throw new IllegalStateException("Invalid array-move(fwd) value #" + i + ": " + dst[i] + " != " + src[i - 1]);
        }
    }

    private void testDoubleArrayCopy() throws Exception {
        int i;
        int len = 10;
        double[] src = new double[len];
        for (int i2 = 0; i2 < len; ++i2) {
            src[i2] = i2;
        }
        double[] dst = new double[len];
        System.arraycopy(src, 0, dst, 0, len);
        for (i = 0; i < len; ++i) {
            if (dst[i] == src[i]) continue;
            throw new IllegalStateException("Invalid array-copy value #" + i + ": " + dst[i] + " != " + src[i]);
        }
        System.arraycopy(dst, 0, dst, 1, len - 1);
        for (i = 1; i < len; ++i) {
            if (dst[i] == src[i - 1]) continue;
            throw new IllegalStateException("Invalid array-move(fwd) value #" + i + ": " + dst[i] + " != " + src[i - 1]);
        }
    }

    protected void testInfectionMethods() throws Exception {
        this.testInfectionGetAbsoluteFile();
        this.testInfectionGetRelativeFile();
    }

    protected void testInfectionGetAbsoluteFile() throws Exception {
        File root = new File("/").getAbsoluteFile();
        String rootPath = root.getPath();
        if (!(rootPath = rootPath.replace('\\', '/')).endsWith("/")) {
            rootPath = rootPath + "/";
        }
        this.testInfectionGetAbsoluteFile("test.txt", rootPath + "base-dir", rootPath + "base-dir/test.txt");
        this.testInfectionGetAbsoluteFile(rootPath + "test.txt", rootPath + "base-dir", rootPath + "test.txt");
        this.testInfectionGetAbsoluteFile("abc/xyz/test.txt", rootPath + "base-dir", rootPath + "base-dir/abc/xyz/test.txt");
        this.testInfectionGetAbsoluteFile("../abc/test.txt", rootPath + "xyz/base-dir", rootPath + "xyz/abc/test.txt");
        this.testInfectionGetAbsoluteFile("../../abc/test.txt", rootPath + "xyz/1/2", rootPath + "xyz/abc/test.txt");
        this.testInfectionGetAbsoluteFile("../../../abc/test.txt", rootPath + "xyz/1/2/3", rootPath + "xyz/abc/test.txt");
        this.testInfectionGetAbsoluteFile("C:/test.txt", "D:/base-dir", "C:/test.txt");
        this.testInfectionGetAbsoluteFile("D:/test.txt", "C:/base-dir", "D:/test.txt");
        this.testInfectionGetAbsoluteFile("../../a/b/text.txt", rootPath + "x/b", rootPath + "a/b/text.txt");
        this.testInfectionGetAbsoluteFile("../../a/b/a/b/text.txt", rootPath + "x/b", rootPath + "a/b/a/b/text.txt");
    }

    protected void testInfectionGetAbsoluteFile(String file, String base, String expectedResult) throws Exception {
        File result = InfectionUtil.getAbsoluteFile(new File(file), new File(base));
        String resultPath = result.getPath();
        if (expectedResult.equals(resultPath = resultPath.replace('\\', '/'))) {
            return;
        }
        throw new IllegalStateException("Unexpected absolute file: file=" + file + ", base=" + base + ", result=" + resultPath + " != expected=" + expectedResult);
    }

    protected void testInfectionGetRelativeFile() throws Exception {
        File root = new File("/").getAbsoluteFile();
        String rootPath = root.getPath();
        if (!(rootPath = rootPath.replace('\\', '/')).endsWith("/")) {
            rootPath = rootPath + "/";
        }
        this.testInfectionGetRelativeFile(rootPath + "base-dir/test.txt", rootPath + "base-dir", "test.txt");
        this.testInfectionGetRelativeFile(rootPath + "test.txt", rootPath + "base-dir", "../test.txt");
        this.testInfectionGetRelativeFile(rootPath + "base-dir/abc/xyz/test.txt", rootPath + "base-dir", "abc/xyz/test.txt");
        this.testInfectionGetRelativeFile(rootPath + "xyz/abc/test.txt", rootPath + "xyz/base-dir", "../abc/test.txt");
        this.testInfectionGetRelativeFile(rootPath + "xyz/abc/test.txt", rootPath + "xyz/1/2", "../../abc/test.txt");
        this.testInfectionGetRelativeFile(rootPath + "xyz/abc/test.txt", rootPath + "xyz/1/2/3", "../../../abc/test.txt");
        this.testInfectionGetRelativeFile("C:/test.txt", "D:/base-dir", "C:/test.txt");
        this.testInfectionGetRelativeFile("D:/test.txt", "C:/base-dir", "D:/test.txt");
        this.testInfectionGetRelativeFile(rootPath + "a/b/text.txt", rootPath + "x/b", "../../a/b/text.txt");
        this.testInfectionGetRelativeFile(rootPath + "a/b/a/b/text.txt", rootPath + "x/b", "../../a/b/a/b/text.txt");
    }

    protected void testInfectionGetRelativeFile(String file, String base, String expectedResult) throws Exception {
        File result = InfectionUtil.getRelativeFile(new File(file), new File(base));
        String resultPath = result.getPath();
        if (expectedResult.equals(resultPath = resultPath.replace('\\', '/'))) {
            return;
        }
        throw new IllegalStateException("Unexpected relative file: file=" + file + ", base=" + base + ", result=" + resultPath + " != expected=" + expectedResult);
    }
}

