/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.Debug;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionUtilWin32;
import com.spacekiller.infection.JavaVM;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InfectionUtil {
    private static final Logger logger = Logger.getLogger(InfectionUtil.class.getName());
    private static final String[] MANDATORY_CONFIG_VARIABLES = new String[]{"JAVA_EXEC", "JAVAW_EXEC", "MAIN_JAR_FILE", "DIST_JAR_FILE"};
    private static final String[] OPTIONAL_CONFIG_VARIABLES = new String[]{"JAVA_OPTS"};
    private static final String SEPARATOR_LINE = "========================================================";
    private static final String NOTE_DO_NOT_EDIT = "NOTE: THIS FILE WILL BE RE-GENERATED WHEN CONFIG CHANGED";
    private static final int DEFAULT_COPY_BUF_SIZE = 65536;
    private static InfectionUtil instance;

    private InfectionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InfectionUtil getInstance() {
        if (instance != null) return instance;
        Class<InfectionUtil> clazz = InfectionUtil.class;
        synchronized (InfectionUtil.class) {
            if (instance != null) return instance;
            instance = new InfectionUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInstance(InstanceUpdate update) throws Exception {
        block67: {
            String iconPath;
            String cmdArgs;
            String lnkPath;
            File desktopDir;
            InfectionUtil util;
            String infectFileName;
            String startupFileName;
            boolean windows;
            String iniFile;
            boolean doNotEditNote;
            String mainArgsCmd;
            String mainArgs;
            String appTitle;
            File instanceDir;
            boolean allScripts;
            block62: {
                String mainJarFile;
                File javaExecFile;
                String javaExecName;
                String jvmArgs;
                String appDescr;
                allScripts = true;
                instanceDir = update.getInstanceDir();
                if (instanceDir == null) {
                    throw new Exception("Instance directory not specified!");
                }
                appTitle = update.getApplTitle();
                if (!(appTitle != null && appTitle.length() >= 1 || (appTitle = update.getApplName()) != null && appTitle.length() >= 1 || (appTitle = update.getDistJarFile()) != null && appTitle.length() >= 1)) {
                    appTitle = "unknown";
                }
                if ((appDescr = update.getApplDescr()) == null) {
                    appDescr = "";
                }
                if ((jvmArgs = update.getJvmArgs()) == null) {
                    jvmArgs = "";
                }
                if ((mainArgs = update.getMainArgs()) == null) {
                    mainArgs = "";
                }
                if ((mainArgsCmd = mainArgs).length() > 0) {
                    mainArgsCmd = mainArgsCmd + " ";
                }
                mainArgsCmd = mainArgsCmd + "-shell -command";
                String javaExec = null;
                JavaVM jvm = update.getJavaVM();
                if (jvm != null) {
                    javaExec = jvm.getExecutable();
                }
                String javaExecCmd = null;
                if (jvm != null && ((javaExecName = (javaExecFile = new File(javaExecCmd = jvm.getExecutable())).getName()).startsWith("javaw.") || javaExecName.equals("javaw"))) {
                    javaExecName = "java" + javaExecName.substring(5);
                    if ((javaExecFile = new File(javaExecFile.getParent(), javaExecName)).exists() && javaExecFile.isFile()) {
                        javaExecCmd = javaExecFile.getPath();
                        javaExecCmd = Infection.getSlashPath(javaExecCmd);
                    } else {
                        javaExecCmd = null;
                    }
                }
                if (javaExec == null) {
                    javaExec = "javaw";
                }
                if (javaExecCmd == null) {
                    javaExecCmd = "java";
                }
                if ((mainJarFile = update.getMainJarFile()) == null) {
                    throw new IllegalArgumentException("Main jar-file not specified: [mainJarFile]");
                }
                String distJarFile = update.getDistJarFile();
                if (distJarFile == null) {
                    throw new IllegalArgumentException("Distribution jar-file not specified: [distJarFile]");
                }
                doNotEditNote = true;
                iniFile = update.getConfigFilePath();
                if (iniFile == null) {
                    iniFile = "instance.ini";
                }
                String javaOpts = jvmArgs;
                String configString = this.generateConfigIni(javaExecCmd, javaExec, javaOpts, mainJarFile, distJarFile, appTitle, doNotEditNote);
                File destIniFile = new File(instanceDir, iniFile);
                File tmpIniFile = new File(destIniFile.getPath() + ".tmp");
                this.writeTextFile(configString, tmpIniFile);
                try {
                    this.backupAndReplaceFile(tmpIniFile, destIniFile);
                }
                finally {
                    boolean failOnError = false;
                    this.deleteFile(tmpIniFile, failOnError);
                }
                String osName = "";
                boolean unix = true;
                windows = false;
                try {
                    osName = System.getProperty("os.name");
                    boolean bl = windows = osName != null && osName.toLowerCase().startsWith("windows");
                    if (windows) {
                        unix = false;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                if (unix || allScripts) {
                    try {
                        boolean failOnError;
                        File destStartupShell = null;
                        boolean startNewProcess = true;
                        boolean commandLineSupport = false;
                        String strStartupShell = this.generateStartupShellScript(iniFile, mainArgs, startNewProcess, commandLineSupport, appTitle, doNotEditNote);
                        startupFileName = update.getStartupShellFileName();
                        destStartupShell = new File(instanceDir, startupFileName);
                        File tempStartupShell = new File(destStartupShell.getPath() + ".tmp");
                        this.writeTextFile(strStartupShell, tempStartupShell);
                        try {
                            this.backupAndReplaceFile(tempStartupShell, destStartupShell);
                        }
                        finally {
                            boolean failOnError2 = false;
                            this.deleteFile(tempStartupShell, failOnError2);
                        }
                        File destInfectShell = null;
                        boolean startNewProcess2 = false;
                        boolean commandLineSupport2 = true;
                        String strInfectShell = this.generateStartupShellScript(iniFile, mainArgsCmd, startNewProcess2, commandLineSupport2, appTitle, doNotEditNote);
                        infectFileName = update.getInfectShellFileName();
                        destInfectShell = new File(instanceDir, infectFileName);
                        File tempInfectShell = new File(destInfectShell.getPath() + ".tmp");
                        this.writeTextFile(strInfectShell, tempInfectShell);
                        try {
                            this.backupAndReplaceFile(tempInfectShell, destInfectShell);
                        }
                        finally {
                            failOnError = false;
                            this.deleteFile(tempInfectShell, failOnError);
                        }
                        if (!unix) break block62;
                        try {
                            boolean executable = true;
                            boolean ownerOnly = false;
                            if (destStartupShell != null) {
                                this.setFileExecutable(destStartupShell, executable, ownerOnly);
                            }
                            if (destInfectShell != null) {
                                this.setFileExecutable(destInfectShell, executable, ownerOnly);
                            }
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                        byte[] iconData = update.getIconData();
                        String iconFileName = update.getApplName() + ".gif";
                        File iconFile = new File(instanceDir, iconFileName);
                        if (iconData != null) {
                            File tempIconFile = new File(iconFile.getPath() + ".tmp");
                            FileOutputStream fout = new FileOutputStream(tempIconFile);
                            try {
                                fout.write(iconData);
                            }
                            finally {
                                fout.close();
                            }
                            try {
                                this.backupAndReplaceFile(tempIconFile, iconFile);
                            }
                            finally {
                                failOnError = false;
                                this.deleteFile(tempIconFile, failOnError);
                            }
                        }
                        util = InfectionUtil.getInstance();
                        String desktopPath = instanceDir.getAbsolutePath();
                        String propUserHome = System.getProperty("user.home");
                        if (propUserHome != null && (desktopDir = new File(propUserHome, "Desktop")).exists()) {
                            desktopPath = desktopDir.getAbsolutePath();
                        }
                        lnkPath = "" + new File(desktopPath, appTitle + ".desktop").getAbsolutePath();
                        String shellPath = destStartupShell.getAbsolutePath();
                        cmdArgs = "";
                        iconPath = iconFile == null ? "" : iconFile.getAbsolutePath();
                        util.createLinuxShortcut(lnkPath, shellPath, appTitle, appDescr, cmdArgs, iconPath);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            if (windows || allScripts) {
                try {
                    boolean failOnError;
                    File destStartupBatch = null;
                    boolean startNewProcess = true;
                    boolean commandLineSupport = false;
                    String strStartupBatch = this.generateStartupBatchScript(iniFile, mainArgs, startNewProcess, commandLineSupport, appTitle, doNotEditNote);
                    startupFileName = update.getStartupBatchFileName();
                    destStartupBatch = new File(instanceDir, startupFileName);
                    File tempStartupBatch = new File(destStartupBatch.getPath() + ".tmp");
                    this.writeTextFile(strStartupBatch, tempStartupBatch);
                    try {
                        this.backupAndReplaceFile(tempStartupBatch, destStartupBatch);
                    }
                    finally {
                        boolean failOnError3 = false;
                        this.deleteFile(tempStartupBatch, failOnError3);
                    }
                    File destInfectBatch = null;
                    boolean startNewProcess3 = false;
                    boolean commandLineSupport3 = true;
                    String strInfectBatch = this.generateStartupBatchScript(iniFile, mainArgsCmd, startNewProcess3, commandLineSupport3, appTitle, doNotEditNote);
                    infectFileName = update.getInfectBatchFileName();
                    destInfectBatch = new File(instanceDir, infectFileName);
                    File tempInfectBatch = new File(destInfectBatch.getPath() + ".tmp");
                    this.writeTextFile(strInfectBatch, tempInfectBatch);
                    try {
                        this.backupAndReplaceFile(tempInfectBatch, destInfectBatch);
                    }
                    finally {
                        failOnError = false;
                        this.deleteFile(tempInfectBatch, failOnError);
                    }
                    if (!windows) break block67;
                    byte[] icoData = update.getIcoData();
                    String iconFileName = update.getApplName() + ".ico";
                    File icoFile = new File(instanceDir, iconFileName);
                    if (icoData != null) {
                        File tempIcoFile = new File(icoFile.getPath() + ".tmp");
                        FileOutputStream fout = new FileOutputStream(tempIcoFile);
                        try {
                            fout.write(icoData);
                        }
                        finally {
                            fout.close();
                        }
                        try {
                            this.backupAndReplaceFile(tempIcoFile, icoFile);
                        }
                        finally {
                            failOnError = false;
                            this.deleteFile(tempIcoFile, failOnError);
                        }
                    }
                    util = InfectionUtil.getInstance();
                    String desktopPath = instanceDir.getAbsolutePath();
                    String propUserHome = System.getProperty("user.home");
                    if (propUserHome != null && (desktopDir = new File(propUserHome, "Desktop")).exists()) {
                        desktopPath = desktopDir.getAbsolutePath();
                    }
                    lnkPath = "" + new File(desktopPath, appTitle + ".lnk").getAbsolutePath();
                    String batchPath = destStartupBatch.getAbsolutePath();
                    cmdArgs = "";
                    iconPath = icoFile == null ? "" : icoFile.getAbsolutePath();
                    String workingDir = instanceDir.getAbsolutePath();
                    int hotKey = 0;
                    util.createWindowsShortcut(lnkPath, batchPath, workingDir, appTitle, cmdArgs, hotKey, iconPath);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTextFile(String string, File destFile) throws IOException {
        FileOutputStream fout = new FileOutputStream(destFile);
        try {
            PrintStream ps = new PrintStream(fout);
            try {
                ps.print(string);
            }
            finally {
                ps.close();
            }
        }
        finally {
            fout.close();
        }
    }

    protected File resolveJavaExecutable(String javaHome) {
        File javaHomeDir = new File(javaHome);
        if (!javaHomeDir.exists()) {
            return null;
        }
        File binDir = new File(javaHomeDir, "bin");
        if (!binDir.exists()) {
            return null;
        }
        return this.resolveJavaExecutable(binDir);
    }

    protected File resolveJavaExecutable(File binDir) {
        File f = new File(binDir, "javaw.exe");
        if (f.exists() && f.isFile()) {
            return f;
        }
        f = new File(binDir, "javaw");
        if (f.exists() && f.isFile()) {
            return f;
        }
        f = new File(binDir, "java.exe");
        if (f.exists() && f.isFile()) {
            return f;
        }
        f = new File(binDir, "java");
        if (f.exists() && f.isFile()) {
            return f;
        }
        return null;
    }

    protected String timestampString(Date date) {
        return Debug.getTimeString(date.getTime());
    }

    protected String generateConfigIni(String javaExec, String javawExec, String javaOpts, String mainJarFile, String distJarFile, String title, boolean doNotEditNote) throws IOException {
        String newline = "\n";
        StringBuffer buf = new StringBuffer();
        String timestampString = this.timestampString(new Date());
        String separatorString = "# ========================================================";
        String noteDoNotEdit = "# NOTE: THIS FILE WILL BE RE-GENERATED WHEN CONFIG CHANGED";
        buf.append(separatorString);
        buf.append(newline);
        buf.append("# Configuration file for '" + title + "'");
        buf.append(newline);
        buf.append("# Generated " + timestampString);
        buf.append(newline);
        if (doNotEditNote) {
            buf.append(separatorString);
            buf.append(newline);
            buf.append(noteDoNotEdit);
            buf.append(newline);
        }
        buf.append(separatorString);
        buf.append(newline);
        buf.append("JAVA_EXEC");
        buf.append("=");
        buf.append(this.formatPropertyValue(javaExec));
        buf.append(newline);
        buf.append("JAVAW_EXEC");
        buf.append("=");
        buf.append(this.formatPropertyValue(javawExec));
        buf.append(newline);
        buf.append("JAVA_OPTS");
        buf.append("=");
        buf.append(this.formatPropertyValue(javaOpts));
        buf.append(newline);
        buf.append("MAIN_JAR_FILE");
        buf.append("=");
        mainJarFile = mainJarFile.replace('\\', '/');
        buf.append(this.formatPropertyValue(mainJarFile));
        buf.append(newline);
        buf.append("DIST_JAR_FILE");
        buf.append("=");
        distJarFile = distJarFile.replace('\\', '/');
        buf.append(this.formatPropertyValue(distJarFile));
        buf.append(newline);
        if (doNotEditNote) {
            buf.append(separatorString);
            buf.append(newline);
            buf.append(noteDoNotEdit);
            buf.append(newline);
        }
        buf.append(separatorString);
        buf.append(newline);
        return buf.toString();
    }

    protected String formatPropertyValue(String value) throws IOException {
        return value;
    }

    protected String generateStartupShellScript(String configFile, String mainArgs, boolean startNewProcess, boolean commandLineSupport, String title, boolean doNotEditNote) throws Exception {
        String varName;
        int i;
        String varJavaExec = "JAVA_EXEC";
        String varJavawExec = "JAVAW_EXEC";
        String varJavaOpts = "JAVA_OPTS";
        String varMainFile = "MAIN_JAR_FILE";
        String varDistFile = "DIST_JAR_FILE";
        ArrayList<String> script = new ArrayList<String>();
        script.add("#!/bin/sh");
        String timestampString = this.timestampString(new Date());
        String separatorString = "# ========================================================";
        String noteDoNotEdit = "# NOTE: THIS FILE WILL BE RE-GENERATED WHEN CONFIG CHANGED";
        script.add(separatorString);
        script.add("# Startup Batch Script for '" + title + "'");
        script.add("# Generated " + timestampString);
        if (doNotEditNote) {
            script.add(separatorString);
            script.add(noteDoNotEdit);
        }
        script.add(separatorString);
        script.add("");
        script.add("# change directory to script-file location...");
        script.add("cd $(dirname \"${0}\")");
        script.add("");
        script.add("# main arguments...");
        script.add("MAIN_ARGS=\"" + mainArgs + "\"");
        script.add("");
        script.add("# config-file...");
        script.add("CONFIG_FILE=\"" + configFile + "\"");
        script.add("");
        script.add("# fail-function...");
        script.add("fail() {");
        script.add("  echo \"Failed with error code: ${RC}\";");
        script.add("  exit ${RC}");
        script.add("}");
        script.add("");
        script.add("# check config-file exists...");
        script.add("if [ ! -f ${CONFIG_FILE} ]; then");
        script.add("  echo \"Config file not found: ${CONFIG_FILE}\";");
        script.add("  RC=57;");
        script.add("  fail;");
        script.add("fi");
        script.add("");
        script.add("# reset variables...");
        script.add("" + varJavaExec + "=\"\";");
        script.add("" + varJavawExec + "=\"\";");
        script.add("" + varJavaOpts + "=\"\";");
        script.add("" + varMainFile + "=\"\";");
        script.add("" + varDistFile + "=\"\";");
        script.add("");
        script.add("# read variables from config-file...");
        script.add("while IFS== read -r key val ; do");
        script.add("  val=${val%\\\"}; val=${val#\\\"}; key=${key#export };");
        script.add("  if [ \"${key}\" = \"\" ]; then");
        script.add("    continue;");
        script.add("  elif [ \"${key}\" = \"" + varJavaExec + "\" ]; then");
        script.add("    " + varJavaExec + "=${val};");
        script.add("    continue;");
        script.add("  elif [ \"${key}\" = \"" + varJavawExec + "\" ]; then");
        script.add("    " + varJavawExec + "=${val};");
        script.add("    continue;");
        script.add("  elif [ \"${key}\" = \"" + varJavaOpts + "\" ]; then");
        script.add("    " + varJavaOpts + "=${val};");
        script.add("    continue;");
        script.add("  elif [ \"${key}\" = \"" + varMainFile + "\" ]; then");
        script.add("    " + varMainFile + "=${val};");
        script.add("    continue;");
        script.add("  elif [ \"${key}\" = \"" + varDistFile + "\" ]; then");
        script.add("    " + varDistFile + "=${val};");
        script.add("    continue;");
        script.add("  fi");
        script.add("done < ${CONFIG_FILE}");
        script.add("");
        script.add("# verify variables from config-file...");
        script.add("");
        String[] variableNames = MANDATORY_CONFIG_VARIABLES;
        for (i = 0; i < variableNames.length; ++i) {
            varName = variableNames[i];
            script.add("# verify mandatory variable: " + varName);
            script.add("if [ -z \"${" + varName + "}\" ]; then");
            script.add("  echo \"Missing property: '" + varName + "' in file '${CONFIG_FILE}'\";");
            script.add("  RC=57;");
            script.add("  fail;");
            script.add("fi");
            script.add("");
        }
        variableNames = OPTIONAL_CONFIG_VARIABLES;
        for (i = 0; i < variableNames.length; ++i) {
            varName = variableNames[i];
            script.add("# verify optional variable: " + varName);
            script.add("if [ -z \"${" + varName + "}\" ]; then");
            script.add("  " + varName + "=\"\";");
            script.add("fi");
            script.add("");
        }
        script.add("# start application...");
        String varJava = "JAVAW_EXEC";
        if (commandLineSupport) {
            varJava = "JAVA_EXEC";
        }
        String keyDistFile = "infection.dist";
        String command = "\"${" + varJava + "}\" ${" + varJavaOpts + "} \"-D" + keyDistFile + "=${" + varDistFile + "}\" -jar \"${" + varMainFile + "}\" ${MAIN_ARGS} $*";
        if (startNewProcess) {
            command = command + " &";
        }
        script.add(command);
        script.add("");
        script.add("# handle return-code...");
        script.add("RC=$?");
        script.add("if [ $RC -ne 0 ]; then");
        script.add("  echo \"Command failed: " + command + "\";");
        script.add("  echo \"Error-Code: $RC\";");
        script.add("  exit $RC;");
        script.add("fi");
        script.add("");
        if (doNotEditNote) {
            script.add(separatorString);
            script.add(noteDoNotEdit);
        }
        script.add(separatorString);
        String newline = "\n";
        StringBuffer buf = new StringBuffer();
        Iterator i2 = script.iterator();
        while (i2.hasNext()) {
            buf.append((String)i2.next());
            buf.append(newline);
        }
        return buf.toString();
    }

    protected String generateStartupBatchScript(String configFile, String mainArgs, boolean startNewProcess, boolean commandLineSupport, String title, boolean doNotEditNote) throws Exception {
        String varName;
        int i;
        String varJavaExec = "JAVA_EXEC";
        String varJavawExec = "JAVAW_EXEC";
        String varJavaOpts = "JAVA_OPTS";
        String varMainFile = "MAIN_JAR_FILE";
        String varDistFile = "DIST_JAR_FILE";
        ArrayList<String> script = new ArrayList<String>();
        script.add("@echo off");
        String timestampString = this.timestampString(new Date());
        String separatorString = "REM ========================================================";
        String noteDoNotEdit = "REM NOTE: THIS FILE WILL BE RE-GENERATED WHEN CONFIG CHANGED";
        script.add(separatorString);
        script.add("REM Startup Batch Script for '" + title + "'");
        script.add("REM Generated " + timestampString);
        if (doNotEditNote) {
            script.add(separatorString);
            script.add(noteDoNotEdit);
        }
        script.add(separatorString);
        script.add("");
        script.add("REM change directory to batch-file location...");
        script.add("pushd \"%~dp0\"");
        script.add("");
        script.add("REM main arguments...");
        script.add("set MAIN_ARGS=" + mainArgs);
        script.add("");
        script.add("REM config-file...");
        script.add("set CONFIG_FILE=" + configFile);
        script.add("");
        script.add("REM check config-file exists...");
        script.add("if not exist \"%CONFIG_FILE%\" (");
        script.add("  echo Config file not found: '%CONFIG_FILE%'");
        script.add("  set RC=57");
        script.add("  goto FAIL");
        script.add(")");
        script.add("");
        script.add("REM reset variables...");
        script.add("set " + varJavaExec + "=\"\";");
        script.add("set " + varJavawExec + "=\"\";");
        script.add("set " + varJavaOpts + "=\"\";");
        script.add("set " + varMainFile + "=\"\";");
        script.add("set " + varDistFile + "=\"\";");
        script.add("");
        script.add("REM read variables from config-file...");
        script.add("for /f \"delims== tokens=1,*\" %%G in (%CONFIG_FILE%) do set %%G=%%H");
        script.add("");
        script.add("REM verify variables from config-file...");
        script.add("");
        String[] variableNames = MANDATORY_CONFIG_VARIABLES;
        for (i = 0; i < variableNames.length; ++i) {
            varName = variableNames[i];
            script.add("REM verify mandatory variable: " + varName);
            script.add("if 'Missing\"%" + varName + "%\"' == 'Missing' (");
            script.add("  echo Missing property: '" + varName + "' in file '%CONFIG_FILE%'");
            script.add("  set RC=57");
            script.add("  goto FAIL");
            script.add(")");
            script.add("");
        }
        variableNames = OPTIONAL_CONFIG_VARIABLES;
        for (i = 0; i < variableNames.length; ++i) {
            varName = variableNames[i];
            script.add("REM verify optional variable: " + varName);
            script.add("if 'Missing\"%" + varName + "%\"' == 'Missing' (");
            script.add("  set " + varName + "=");
            script.add(")");
            script.add("");
        }
        script.add("REM start application...");
        String varJava = "JAVAW_EXEC";
        if (commandLineSupport) {
            varJava = "JAVA_EXEC";
        }
        String keyDistFile = "infection.dist";
        String command = "\"%" + varJava + "%\" %" + varJavaOpts + "% \"-D" + keyDistFile + "=%" + varDistFile + "%\" -jar \"%" + varMainFile + "%\" %MAIN_ARGS% %*";
        if (startNewProcess) {
            command = "start \"" + title + "\" " + command;
        }
        script.add(command);
        script.add("");
        script.add("REM handle return-code...");
        script.add("set RC=%ERRORLEVEL%");
        script.add("IF %RC% NEQ 0 (");
        script.add("  echo Command failed: " + command);
        script.add("  echo Error-Code: %RC%");
        script.add("  exit /b %RC%");
        script.add(")");
        script.add("");
        script.add(":DONE");
        script.add("set RC=0");
        script.add("exit /b %RC%");
        script.add("");
        script.add(":FAIL");
        script.add("echo Failed with error code: %RC%");
        script.add("exit /b %RC%");
        script.add("");
        if (doNotEditNote) {
            script.add(separatorString);
            script.add(noteDoNotEdit);
        }
        script.add(separatorString);
        String newline = "\r\n";
        StringBuffer buf = new StringBuffer();
        Iterator i2 = script.iterator();
        while (i2.hasNext()) {
            buf.append((String)i2.next());
            buf.append(newline);
        }
        return buf.toString();
    }

    protected void createLinuxShortcut(String lnkPath, String shellPath, String appName, String appDescr, String cmdArgs, String iconPath) throws Exception {
        File file = new File(shellPath);
        String basePath = file.getPath();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating link: " + lnkPath);
            logger.finer("Command: " + basePath);
            logger.finer("Name: " + appName);
            logger.finer("Descr: " + appDescr);
            logger.finer("Param len: " + cmdArgs.length());
            logger.finer("Param: " + cmdArgs);
            logger.finer("Icon: " + iconPath);
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(lnkPath));
        bw.write("[Desktop Entry]\n");
        bw.write("Name=" + appName + "\n");
        bw.write("Comment=" + appDescr + "\n");
        bw.write("Icon=" + iconPath + "\n");
        bw.write("Exec=" + basePath + "\n");
        bw.write("Type=Application\n");
        bw.close();
        try {
            boolean executable = true;
            boolean ownerOnly = false;
            this.setFileExecutable(new File(lnkPath), executable, ownerOnly);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void createWindowsShortcut(String lnkPath, String execPath, String workingDir, String appTitle, String cmdArgs, int hotKey, String iconPath) throws Exception {
        File file = new File(execPath);
        String basePath = file.getPath();
        String path = "";
        int sw = 7;
        int fileLen = (int)file.length();
        String descr = "" + appTitle;
        String relativePath = basePath;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating shortcut: " + lnkPath);
            logger.finer("Command: " + basePath);
            logger.finer("Directory: " + workingDir);
            logger.finer("Descr: " + descr);
            logger.finer("Param len: " + cmdArgs.length());
            logger.finer("Param: " + cmdArgs);
            logger.finer("Icon: " + iconPath);
        }
        FileOutputStream out = new FileOutputStream(lnkPath);
        new InfectionUtilWin32().lnkFormat(out, basePath, path, sw, fileLen, hotKey, descr, relativePath, workingDir, cmdArgs, iconPath);
        out.close();
    }

    protected boolean deleteFile(File file, boolean failOnError) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("deleteFile: file=" + file + ", failOnError=" + failOnError);
        }
        if (failOnError) {
            return this.deleteFile(file);
        }
        try {
            return this.deleteFile(file);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    protected boolean deleteFile(File file) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("deleteFile: file=" + file);
        }
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                return true;
            }
            file.deleteOnExit();
            return false;
        }
        return false;
    }

    protected byte[] createDefaultCopyBuffer() {
        return new byte[65536];
    }

    public long copyFile(File srcFile, File dstFile) throws IOException {
        byte[] buf = this.createDefaultCopyBuffer();
        return this.copyFile(srcFile, dstFile, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long copyFile(File srcFile, File dstFile, byte[] buf) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("copyFile: srcFile=" + srcFile + ", dstFile=" + dstFile);
        }
        FileInputStream in = new FileInputStream(srcFile);
        try {
            long l;
            boolean success = false;
            FileOutputStream out = new FileOutputStream(dstFile);
            try {
                long total = this.copyStream(in, out, buf);
                success = true;
                l = total;
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                if (success) throw throwable;
                try {
                    boolean failOnError;
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Deleting incomplete destination file: " + dstFile);
                    }
                    if (this.deleteFile(dstFile, failOnError = true)) {
                        if (!logger.isLoggable(Level.FINE)) throw throwable;
                        logger.fine("Deleted incomplete destination file: " + dstFile);
                        throw throwable;
                    } else {
                        if (!logger.isLoggable(Level.WARNING)) throw throwable;
                        logger.warning("Failed to delete incomplete file: " + dstFile);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Failed to delete incomplete file '" + dstFile + "', Cause: " + e.getMessage(), e);
                }
                throw throwable;
            }
            try {
                out.close();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (success) return l;
            try {
                boolean failOnError;
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Deleting incomplete destination file: " + dstFile);
                }
                if (this.deleteFile(dstFile, failOnError = true)) {
                    if (!logger.isLoggable(Level.FINE)) return l;
                    logger.fine("Deleted incomplete destination file: " + dstFile);
                    return l;
                }
                if (!logger.isLoggable(Level.WARNING)) return l;
                logger.warning("Failed to delete incomplete file: " + dstFile);
                return l;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to delete incomplete file '" + dstFile + "', Cause: " + e.getMessage(), e);
            }
            return l;
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public long copyStream(InputStream in, OutputStream out, byte[] buf) throws IOException {
        int n;
        int total = 0;
        while ((n = in.read(buf)) >= 0) {
            out.write(buf, 0, n);
            total += n;
        }
        return total;
    }

    public void backupAndReplaceFile(File srcFile, File dstFile) throws IOException {
        int keepBackupCount = 0;
        this.backupAndReplaceFile(srcFile, dstFile, keepBackupCount);
    }

    public void backupAndReplaceFile(File srcFile, File dstFile, int keepBackupCount) throws IOException {
        String dstFilePath = dstFile.getPath();
        File bkpFile = new File(dstFilePath + ".bak");
        this.backupAndReplaceFile(srcFile, dstFile, keepBackupCount, bkpFile);
    }

    public void backupAndReplaceFile(File srcFile, File dstFile, int keepBackupCount, File bkpFile) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("backupAndReplaceFile: srcFile=" + srcFile + ", dstFile=" + dstFile + ", keepBackupCount=" + keepBackupCount);
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            throw new FileNotFoundException(srcFile.getPath());
        }
        boolean dstFileExists = false;
        if (dstFile.exists()) {
            if (dstFile.isFile()) {
                dstFileExists = true;
            } else {
                throw new IOException("Destination is not a file: " + dstFile);
            }
        }
        byte[] buf = null;
        boolean bkpFileCreated = false;
        if (dstFileExists) {
            if (bkpFile.exists() && bkpFile.isFile()) {
                boolean failOnError;
                if (keepBackupCount > 1) {
                    logger.info("TODO rotate backup-files: " + keepBackupCount);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Deleting old backup file '" + bkpFile + "'");
                }
                if (!this.deleteFile(bkpFile, failOnError = true)) {
                    throw new IOException("Failed to delete old backup file: " + bkpFile);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Backup file '" + dstFile + "' to '" + bkpFile + "'");
            }
            if (buf == null) {
                buf = this.createDefaultCopyBuffer();
            }
            this.copyFile(dstFile, bkpFile, buf);
            bkpFileCreated = true;
        }
        boolean success = false;
        try {
            if (buf == null) {
                buf = this.createDefaultCopyBuffer();
            }
            this.copyFile(srcFile, dstFile, buf);
            success = true;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to copy file '" + srcFile + "' to '" + dstFile + "', Error: " + e.getMessage(), e);
            throw e;
        }
        finally {
            if (!success) {
                try {
                    if (bkpFileCreated) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Restoring file '" + dstFile + "' from backup file '" + bkpFile + "'");
                        }
                        if (buf == null) {
                            buf = this.createDefaultCopyBuffer();
                        }
                        this.copyFile(bkpFile, dstFile, buf);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Restored file: " + dstFile);
                        }
                        if (!this.deleteFile(bkpFile) && logger.isLoggable(Level.WARNING)) {
                            logger.warning("Failed to delete backup file: " + bkpFile);
                        }
                    } else if (!this.deleteFile(dstFile) && logger.isLoggable(Level.WARNING)) {
                        logger.warning("Failed to delete incomplete file: " + dstFile);
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Failed to restore file '" + dstFile + "', Error: " + e.getMessage(), e);
                }
            }
        }
        if (bkpFileCreated && keepBackupCount < 1) {
            try {
                boolean failOnError;
                if (bkpFile.exists() && bkpFile.isFile() && !this.deleteFile(bkpFile, failOnError = true)) {
                    throw new IOException("Could not delete backup file: " + bkpFile);
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to delete backup file '" + bkpFile + "', Error: " + e.getMessage(), e);
            }
        }
    }

    public boolean setFileExecutable(File file, boolean executable, boolean ownerOnly) throws Exception {
        try {
            Boolean resultBoolean;
            Class<File> fileClass = File.class;
            Method setExecutableMethod = fileClass.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            Boolean executableBoolean = executable ? Boolean.TRUE : Boolean.FALSE;
            Boolean ownerOnlyBoolean = ownerOnly ? Boolean.TRUE : Boolean.FALSE;
            Object result = setExecutableMethod.invoke((Object)file, executableBoolean, ownerOnlyBoolean);
            if (result != null && result instanceof Boolean && (resultBoolean = (Boolean)result).booleanValue()) {
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        String unixFileModifiers = ownerOnly ? (executable ? "u+x" : "u-x") : (executable ? "a+x" : "a-x");
        this.unixChmod(file, unixFileModifiers);
        return true;
    }

    private void unixChmod(File file, String unixFileModifiers) throws Exception {
        String filePath = file.getAbsolutePath();
        logger.info("Execute>> chmod " + unixFileModifiers + " " + filePath);
        String[] command = new String[]{"chmod", unixFileModifiers, filePath};
        Process process = Runtime.getRuntime().exec(command);
        int rc = process.waitFor();
        logger.info("Execute Return-Code: " + rc);
        if (rc != 0) {
            throw new Exception("Unable to change file modifiers: error-code " + rc + " was returned by the chmod-command!");
        }
    }

    public static File getRelativeFile(File file, File baseDirX) {
        String fileSep;
        File baseAbs = baseDirX.getAbsoluteFile();
        String baseDir = baseAbs.getPath();
        File fileAbs = file.getAbsoluteFile();
        String fileDir = fileAbs.getParent();
        String fileName = file.getName();
        String rootPath = fileSep = File.separator;
        int pos = baseDir.indexOf(fileSep);
        if (pos >= 0) {
            rootPath = baseDir.substring(0, pos + fileSep.length());
            baseDir = baseDir.substring(pos + fileSep.length());
        }
        if (!fileDir.startsWith(rootPath)) {
            return file;
        }
        if ((fileDir = fileDir.substring(rootPath.length())).equals(baseDir)) {
            String relPath = fileName;
            return new File(relPath);
        }
        if (fileDir.startsWith(baseDir + fileSep)) {
            String relPath = fileDir.substring(baseDir.length() + fileSep.length()) + fileSep + fileName;
            return new File(relPath);
        }
        StringTokenizer baseTok = new StringTokenizer(baseDir, fileSep, false);
        StringTokenizer fileTok = new StringTokenizer(fileDir, fileSep, false);
        StringBuffer prefix = new StringBuffer();
        StringBuffer suffix = new StringBuffer();
        boolean stillSame = true;
        while (baseTok.hasMoreTokens()) {
            String baseSub = baseTok.nextToken();
            if (stillSame && fileTok.hasMoreTokens()) {
                String fileSub = fileTok.nextToken();
                if (fileSub.equals(baseSub)) continue;
                stillSame = false;
                if (suffix.length() > 0) {
                    suffix.append(fileSep);
                }
                suffix.append(fileSub);
            }
            if (prefix.length() > 0) {
                prefix.append(fileSep);
            }
            prefix.append("..");
        }
        while (fileTok.hasMoreTokens()) {
            String fileSub = fileTok.nextToken();
            if (suffix.length() > 0) {
                suffix.append(fileSep);
            }
            suffix.append(fileSub);
        }
        String relPath = prefix.toString();
        if (relPath.length() > 0) {
            relPath = relPath + fileSep;
        }
        if (suffix.length() > 0) {
            relPath = relPath + suffix.toString();
            relPath = relPath + fileSep;
        }
        relPath = relPath + fileName;
        return new File(relPath);
    }

    public static File getAbsoluteFile(File file, File baseDir) {
        File absFile;
        String absPath;
        if (!file.isAbsolute() && baseDir != null) {
            file = new File(baseDir, file.getPath());
        }
        if ((absPath = (absFile = file.getAbsoluteFile()).getPath()).indexOf("..") >= 0) {
            String fileSep = File.separator;
            StringTokenizer tok = new StringTokenizer(absPath, fileSep, true);
            ArrayList<String> toks = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                int siz;
                String s = tok.nextToken();
                if (s.equals("..")) {
                    siz = toks.size();
                    if (siz <= 0) continue;
                    if (fileSep.equals(toks.get(siz - 1))) {
                        toks.remove(siz - 1);
                        --siz;
                    }
                    if (siz <= 0) continue;
                    toks.remove(siz - 1);
                    continue;
                }
                if (s.equals(fileSep) && (siz = toks.size()) > 0 && fileSep.equals(toks.get(siz - 1))) continue;
                toks.add(s);
            }
            StringBuffer sbuf = new StringBuffer();
            for (String s : toks) {
                if (sbuf.length() > 0) {
                    sbuf.append(fileSep);
                }
                sbuf.append(s);
            }
            absFile = new File(sbuf.toString());
        }
        return absFile;
    }

    public static File getURLFile(URL fileURL) throws Exception {
        if (fileURL == null) {
            return null;
        }
        if ("file".equals(fileURL.getProtocol())) {
            String path = fileURL.getPath();
            path = URLDecoder.decode(path, "UTF-8");
            File file = new File(path);
            return file;
        }
        return null;
    }

    public static URL getFileURL(File file) throws MalformedURLException {
        if (file == null) {
            return null;
        }
        return file.toURI().toURL();
    }

    public static URL getCodeLocation(Class clazz) {
        ProtectionDomain domain = clazz.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource source = domain.getCodeSource();
        if (source == null) {
            return null;
        }
        return source.getLocation();
    }

    public static File getJarFile(Class clazz) throws Exception {
        URL location = InfectionUtil.getCodeLocation(clazz);
        if (location == null) {
            return null;
        }
        File file = InfectionUtil.getURLFile(location);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return file;
    }

    protected static File getCodeDirectory(Class clazz) throws Exception {
        URL location = InfectionUtil.getCodeLocation(clazz);
        if (location == null) {
            return null;
        }
        File file = InfectionUtil.getURLFile(location);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (file.isFile()) {
            return null;
        }
        return file;
    }

    public static class InstanceUpdate {
        private File instanceDir;
        private JavaVM javaVM;
        private String jvmArgs;
        private String mainArgs;
        private String applName;
        private String applTitle;
        private String applDescr;
        private byte[] icoData;
        private byte[] iconData;
        private String mainJarFile;
        private String distJarFile;
        private String configFilePath;
        private String startupBatchFileName;
        private String startupShellFileName;
        private String infectBatchFileName;
        private String infectShellFileName;

        public File getInstanceDir() {
            return this.instanceDir;
        }

        public void setInstanceDir(File instanceDir) {
            this.instanceDir = instanceDir;
        }

        public JavaVM getJavaVM() {
            return this.javaVM;
        }

        public void setJavaVM(JavaVM javaVM) {
            this.javaVM = javaVM;
        }

        public String getJvmArgs() {
            return this.jvmArgs;
        }

        public void setJvmArgs(String jvmArgs) {
            this.jvmArgs = jvmArgs;
        }

        public String getApplDescr() {
            return this.applDescr;
        }

        public void setApplDescr(String applDescr) {
            this.applDescr = applDescr;
        }

        public String getApplName() {
            return this.applName;
        }

        public void setApplName(String applName) {
            this.applName = applName;
        }

        public String getApplTitle() {
            return this.applTitle;
        }

        public void setApplTitle(String applTitle) {
            this.applTitle = applTitle;
        }

        public byte[] getIcoData() {
            return this.icoData;
        }

        public void setIcoData(byte[] icoData) {
            this.icoData = icoData;
        }

        public byte[] getIconData() {
            return this.iconData;
        }

        public void setIconData(byte[] iconData) {
            this.iconData = iconData;
        }

        public String getStartupBatchFileName() {
            return this.startupBatchFileName;
        }

        public void setStartupBatchFileName(String startupBatchFileName) {
            this.startupBatchFileName = startupBatchFileName;
        }

        public String getStartupShellFileName() {
            return this.startupShellFileName;
        }

        public void setStartupShellFileName(String startupShellFileName) {
            this.startupShellFileName = startupShellFileName;
        }

        public String getInfectBatchFileName() {
            return this.infectBatchFileName;
        }

        public void setInfectBatchFileName(String infectBatchFileName) {
            this.infectBatchFileName = infectBatchFileName;
        }

        public String getInfectShellFileName() {
            return this.infectShellFileName;
        }

        public void setInfectShellFileName(String infectShellFileName) {
            this.infectShellFileName = infectShellFileName;
        }

        public String getMainArgs() {
            return this.mainArgs;
        }

        public void setMainArgs(String mainArgs) {
            this.mainArgs = mainArgs;
        }

        public String getConfigFilePath() {
            return this.configFilePath;
        }

        public void setConfigFilePath(String configFilePath) {
            this.configFilePath = configFilePath;
        }

        public String getMainJarFile() {
            return this.mainJarFile;
        }

        public void setMainJarFile(String mainJarFile) {
            this.mainJarFile = mainJarFile;
        }

        public String getDistJarFile() {
            return this.distJarFile;
        }

        public void setDistJarFile(String distJarFile) {
            this.distJarFile = distJarFile;
        }
    }
}

