/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.JavaVM;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JavaProcess {
    private static final Logger logger = Logger.getLogger(JavaProcess.class.getName());
    private JavaVM javaVM;
    private File directory;
    private String[] env;
    private String[] jvmArgs;
    private File jarFile;
    private String classPath;
    private String mainClass;
    private String[] mainArgs;
    private OutputHandler outputHandler;
    private OutputHandler errorHandler;
    private Process process;
    private boolean completed;
    private int exitValue;

    public JavaProcess() {
    }

    public JavaProcess(JavaVM jvm) {
        this();
        this.setJavaVM(jvm);
    }

    public JavaVM getJavaVM() {
        return this.javaVM;
    }

    public void setJavaVM(JavaVM javaVM) {
        this.javaVM = javaVM;
    }

    public synchronized void start() throws Exception {
        Process process;
        int i;
        if (this.process != null) {
            throw new Exception("JavaProcess already started: " + this);
        }
        if (this.completed) {
            throw new Exception("JavaProcess already completed: " + this);
        }
        boolean fine = logger.isLoggable(Level.FINE);
        if (this.javaVM == null) {
            throw new Exception("JavaVM not specified.");
        }
        ArrayList<String> list = new ArrayList<String>();
        String exec = this.javaVM.getExecutable();
        list.add(exec);
        if (this.jvmArgs != null) {
            for (i = 0; i < this.jvmArgs.length; ++i) {
                list.add(this.jvmArgs[i]);
            }
        }
        if (this.jarFile != null) {
            list.add("-jar");
            list.add(this.jarFile.getPath());
        } else {
            if (this.classPath == null) {
                throw new Exception("Classpath not specified.");
            }
            if (this.mainClass == null) {
                throw new Exception("Main class not specified.");
            }
            list.add("-cp");
            list.add(this.classPath);
            list.add(this.mainClass);
        }
        if (this.mainArgs != null) {
            for (i = 0; i < this.mainArgs.length; ++i) {
                list.add(this.mainArgs[i]);
            }
        }
        if (fine) {
            StringBuffer sbuf = new StringBuffer();
            Iterator i2 = list.iterator();
            while (i2.hasNext()) {
                sbuf.append((String)i2.next());
                sbuf.append(' ');
            }
            logger.fine("Execute: " + sbuf.toString());
        }
        String[] command = list.toArray(new String[list.size()]);
        Runtime runtime = Runtime.getRuntime();
        this.process = process = runtime.exec(command, this.env, this.directory);
        this.completed = false;
        if (fine) {
            logger.fine("Process: " + process);
        }
        InputStream processInput = process.getInputStream();
        InputStream processError = process.getErrorStream();
        ProcessReader inputReader = new ProcessReader(processInput, this.outputHandler);
        ProcessReader errorReader = new ProcessReader(processError, this.errorHandler);
        new Thread(inputReader).start();
        new Thread(errorReader).start();
    }

    public synchronized void destroy() throws Exception {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String[] getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(String[] jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public String[] getMainArgs() {
        return this.mainArgs;
    }

    public void setMainArgs(String[] mainArgs) {
        this.mainArgs = mainArgs;
    }

    public Process getProcess() {
        return this.process;
    }

    protected void setProcess(Process process) {
        this.process = process;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String[] getEnv() {
        return this.env;
    }

    public void setEnv(String[] env) {
        this.env = env;
    }

    private synchronized void handleProcessCompleted() {
        if (this.process == null) {
            return;
        }
        if (this.completed) {
            return;
        }
        boolean fine = logger.isLoggable(Level.FINE);
        try {
            this.exitValue = this.process.exitValue();
            this.completed = true;
            if (fine) {
                logger.fine("Process completed with return code: " + this.exitValue);
            }
        }
        catch (IllegalThreadStateException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
    }

    public OutputHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(OutputHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public OutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    public void setOutputHandler(OutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    protected class ProcessReader
    implements Runnable {
        private BufferedReader reader;
        private OutputHandler handler;

        public ProcessReader(InputStream stream, OutputHandler handler) {
            this.reader = new BufferedReader(new InputStreamReader(stream));
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String s;
                while ((s = this.reader.readLine()) != null) {
                    if (this.handler == null) continue;
                    this.handler.handle(s);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                JavaProcess.this.handleProcessCompleted();
            }
        }
    }

    public static interface OutputHandler {
        public void handle(String var1);
    }
}

