/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.InfectionUtil;
import com.spacekiller.infection.JavaVM;
import com.spacekiller.infection.JavaVMTest;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaVMTester {
    private static final Logger logger = Logger.getLogger(JavaVMTester.class.getName());
    protected static final String HELP_ARGUMENT = "-help";
    protected static final String VERSION_ARGUMENT = "-version";
    protected static final String X_ARGUMENT = "-X";
    protected static final String XX_PRINT_FLAGS_FINAL_ARGUMENT = "-XX:+PrintFlagsFinal";
    protected static final String XX_UNLOCK_DIAGNOSTIC_VM_OPTIONS = "-XX:+UnlockDiagnosticVMOptions";
    protected static final String XX_UNLOCK_EXPERIMENTAL_VM_OPTIONS = "-XX:+UnlockExperimentalVMOptions";
    protected static final String XX_UNLOCK_INTERNAL_VM_OPTIONS = "-XX:+UnlockInternalVMOptions";
    public static final String X_SHOW_SETTINGS_ARGUMENT = "-XshowSettings";
    public static final String X_OPTION_PREFIX = "-X";
    public static final String OPTION_PREFIX = "-";
    private int timeout = 10000;
    private Throwable error;

    public JavaVM testJavaVM(String executable, String[] arguments) throws Exception {
        logger.info("Testing java executable: " + executable);
        TestInfo info = new TestInfo(executable, arguments);
        this.test(info);
        JavaVM jvm = info.getJvm();
        if (jvm == null) {
            if (this.error != null) {
                throw new Exception(this.error.getMessage());
            }
            throw new Exception("Failed to test java runtime: " + info.getExecutable());
        }
        return jvm;
    }

    protected void test(final TestInfo info) throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JavaVMTester.this.runTest(info);
            }
        };
        String threadName = "JavaVMTester";
        Thread thread = new Thread(runnable, threadName);
        thread.start();
        thread.join(this.timeout);
        Process process = info.getProcess();
        if (process != null) {
            if (this.error == null) {
                this.error = new Exception("Timeout!");
            }
            process.destroy();
        }
    }

    protected void runTest(TestInfo info) {
        block17: {
            try {
                String executable = info.getExecutable();
                String[] arguments = info.getArguments();
                Class<JavaVMTest> testClass = JavaVMTest.class;
                String testClassName = testClass.getName();
                CodeSource source = testClass.getProtectionDomain().getCodeSource();
                URL location = source.getLocation();
                File jarFile = InfectionUtil.getURLFile(location);
                String classPath = null;
                if (jarFile != null) {
                    classPath = jarFile.getPath();
                }
                LinkedList<String> commandList = new LinkedList<String>();
                commandList.add(executable);
                if (arguments != null) {
                    for (int i = 0; i < arguments.length; ++i) {
                        commandList.add(arguments[i]);
                    }
                }
                if (classPath != null) {
                    commandList.add("-cp");
                    commandList.add(classPath);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Test-Class: " + testClassName + " -> included classpath: " + classPath);
                    }
                }
                commandList.add(testClassName);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Command: " + commandList);
                }
                String[] command = commandList.toArray(new String[commandList.size()]);
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(command);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Process: " + process);
                }
                info.setProcess(process);
                InputStream stdInput = process.getInputStream();
                InputStream stdError = process.getErrorStream();
                StreamHandler stdInputHandler = new StreamHandler("StdOut", stdInput);
                StreamHandler stdErrorHandler = new StreamHandler("StdErr", stdError);
                Thread stdInputThread = new Thread((Runnable)stdInputHandler, "StreamHandler-StdOut");
                stdInputThread.start();
                Thread stdErrorThread = new Thread((Runnable)stdErrorHandler, "StreamHandler-StdErr");
                stdErrorThread.start();
                int rc = process.waitFor();
                int expectedReturnCode = info.getExpectedReturnCode();
                if (rc == expectedReturnCode) {
                    logger.info("Test return code: " + rc + " (success)");
                } else {
                    logger.info("Test return code: " + rc + " != expected " + expectedReturnCode);
                }
                stdInputThread.join();
                stdErrorThread.join();
                String[] stdInputContent = stdInputHandler.getContent();
                String[] stdErrorContent = stdErrorHandler.getContent();
                stdInputHandler.close();
                stdErrorHandler.close();
                stdInput.close();
                stdError.close();
                info.setOutputContent(stdInputContent);
                info.setErrorContent(stdErrorContent);
                Properties props = new Properties();
                if (stdInputContent != null) {
                    for (String s : stdInputContent) {
                        String key;
                        int x;
                        if (s == null || (x = s.indexOf("=")) < 0 || (key = s.substring(0, x).trim()).length() < 1) continue;
                        String value = s.substring(x + 1).trim();
                        props.setProperty(key, value);
                    }
                }
                if (rc == expectedReturnCode) {
                    String javaVersion = props.getProperty("java.version");
                    if (javaVersion != null) {
                        String jvmTitle = "";
                        String jvmName = props.getProperty("java.vm.name");
                        if (jvmName != null) {
                            jvmTitle = jvmTitle + jvmName;
                        }
                        if (jvmTitle.length() > 0) {
                            jvmTitle = jvmTitle + ", ";
                        }
                        jvmTitle = jvmTitle + javaVersion;
                        JavaVM jvm = new JavaVM();
                        jvm.setExecutable(executable);
                        jvm.setTitle(jvmTitle);
                        jvm.setVersion(javaVersion);
                        info.setJvm(jvm);
                        return;
                    }
                    break block17;
                }
                throw new Exception("Java runtime test failed with return code: " + rc);
            }
            catch (Throwable e) {
                this.error = e;
                logger.log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            String exec = "javaw";
            if (args.length > 0) {
                exec = args[0];
            }
            CodeSource source = JavaVMTester.class.getProtectionDomain().getCodeSource();
            URL location = source.getLocation();
            File jarFile = InfectionUtil.getURLFile(location);
            String classPath = jarFile.getPath();
            String[] arguments = new String[]{"-cp", classPath};
            PrintStream out = System.out;
            out.println("Testing java executable: " + exec);
            Logger.getLogger("").setLevel(Level.ALL);
            logger.setLevel(Level.ALL);
            JavaVM jvm = new JavaVMTester().testJavaVM(exec, arguments);
            out.println("JavaVM: " + jvm);
            out.println("Executable: " + jvm.getExecutable());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        System.exit(0);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String[] queryJavaStandardOptions(String javaExecutable) throws Exception {
        try {
            String[] errorContent;
            String[] arguments = new String[]{HELP_ARGUMENT};
            TestInfo testInfo = new TestInfo(javaExecutable, arguments);
            testInfo.setExpectedReturnCode(0);
            this.test(testInfo);
            LinkedList<String> standardOptions = new LinkedList<String>();
            String[] outputContent = testInfo.getOutputContent();
            if (outputContent != null) {
                int num = outputContent.length;
                for (int i = 0; i < num; ++i) {
                    String optionPrefix = this.parseJavaStandardOptionName(outputContent[i]);
                    if (optionPrefix == null) continue;
                    standardOptions.add(optionPrefix);
                }
            }
            if ((errorContent = testInfo.getErrorContent()) != null) {
                int num = errorContent.length;
                for (int i = 0; i < num; ++i) {
                    String optionPrefix = this.parseJavaStandardOptionName(errorContent[i]);
                    if (optionPrefix == null) continue;
                    standardOptions.add(optionPrefix);
                }
            }
            return standardOptions.toArray(new String[standardOptions.size()]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected String parseJavaStandardOptionName(String str) {
        String option;
        String delim;
        StringTokenizer tok;
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).startsWith(OPTION_PREFIX) && (tok = new StringTokenizer(str = str.substring(OPTION_PREFIX.length()), delim = " \r\n\t;:=/\\<>(){}[]#$", false)).hasMoreTokens() && (option = tok.nextToken()) != null && (option = option.trim()).length() > 0) {
            return option;
        }
        return null;
    }

    public String[] queryJavaNonstandardXOptions(String javaExecutable) throws Exception {
        try {
            String[] errorContent;
            String[] arguments = new String[]{"-X"};
            TestInfo testInfo = new TestInfo(javaExecutable, arguments);
            testInfo.setExpectedReturnCode(0);
            this.test(testInfo);
            LinkedList<String> nonstandardOptions = new LinkedList<String>();
            String[] outputContent = testInfo.getOutputContent();
            if (outputContent != null) {
                int num = outputContent.length;
                for (int i = 0; i < num; ++i) {
                    String optionName = this.parseJavaNonstandardXOptionName(outputContent[i]);
                    if (optionName == null) continue;
                    nonstandardOptions.add(optionName);
                }
            }
            if ((errorContent = testInfo.getErrorContent()) != null) {
                int num = errorContent.length;
                for (int i = 0; i < num; ++i) {
                    String optionName = this.parseJavaNonstandardXOptionName(errorContent[i]);
                    if (optionName == null) continue;
                    nonstandardOptions.add(optionName);
                }
            }
            return nonstandardOptions.toArray(new String[nonstandardOptions.size()]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected String parseJavaNonstandardXOptionName(String str) {
        String option;
        String delim;
        StringTokenizer tok;
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).startsWith("-X") && (tok = new StringTokenizer(str = str.substring("-X".length()), delim = " \r\n\t;:=/\\<>(){}[]#$", false)).hasMoreTokens() && (option = tok.nextToken()) != null && (option = option.trim()).length() > 0) {
            return option;
        }
        return null;
    }

    public String[] queryJavaNonstandardXXFlags(String javaExecutable, boolean unlockDiagnosticVMOptions, boolean unlockExperimentalVMOptions) throws Exception {
        LinkedList<String> argumentList = new LinkedList<String>();
        if (unlockDiagnosticVMOptions) {
            argumentList.add(XX_UNLOCK_DIAGNOSTIC_VM_OPTIONS);
        }
        if (unlockExperimentalVMOptions) {
            argumentList.add(XX_UNLOCK_EXPERIMENTAL_VM_OPTIONS);
        }
        argumentList.add(XX_PRINT_FLAGS_FINAL_ARGUMENT);
        argumentList.add("-X");
        argumentList.add(VERSION_ARGUMENT);
        try {
            String[] errorContent;
            String[] arguments = argumentList.toArray(new String[argumentList.size()]);
            TestInfo testInfo = new TestInfo(javaExecutable, arguments);
            testInfo.setExpectedReturnCode(0);
            this.test(testInfo);
            LinkedList<String> nonstandardXXFlagNames = new LinkedList<String>();
            String[] outputContent = testInfo.getOutputContent();
            if (outputContent != null) {
                int num = outputContent.length;
                for (int i = 0; i < num; ++i) {
                    String flagName = this.parseJavaNonstandardXXFlagName(outputContent[i]);
                    if (flagName == null) continue;
                    nonstandardXXFlagNames.add(flagName);
                }
            }
            if ((errorContent = testInfo.getErrorContent()) != null) {
                int num = errorContent.length;
                for (int i = 0; i < num; ++i) {
                    String flagName = this.parseJavaNonstandardXXFlagName(errorContent[i]);
                    if (flagName == null) continue;
                    nonstandardXXFlagNames.add(flagName);
                }
            }
            return nonstandardXXFlagNames.toArray(new String[nonstandardXXFlagNames.size()]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected String parseJavaNonstandardXXFlagName(String str) {
        if (str == null) {
            return null;
        }
        int x = str.indexOf(61);
        if (x < 0) {
            return null;
        }
        String typeAndName = str.substring(0, x).trim();
        if (typeAndName.length() < 1) {
            return null;
        }
        x = typeAndName.indexOf(32);
        if (x < 0) {
            return null;
        }
        String name = typeAndName.substring(x + 1).trim();
        if (name.length() < 1) {
            return null;
        }
        return name;
    }

    protected String[] queryJavaSettings(String javaExecutable) throws Exception {
        String[] arguments = new String[]{X_SHOW_SETTINGS_ARGUMENT, "-X", VERSION_ARGUMENT};
        throw new UnsupportedOperationException("TODO");
    }

    private static class StreamHandler
    implements Runnable {
        private String prefix;
        private InputStream stream;
        private BufferedReader reader;
        private List list;

        public StreamHandler(String prefix, InputStream stream) {
            this.prefix = prefix;
            this.stream = stream;
            this.list = new ArrayList();
            this.reader = new BufferedReader(new InputStreamReader(stream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    String s;
                    if ((s = this.reader.readLine()) == null) {
                        return;
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("" + this.prefix + " >> " + s);
                    }
                    List list = this.list;
                    synchronized (list) {
                        this.list.add(s);
                    }
                }
            }
            catch (EOFException e) {
                return;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        public String[] getContent() {
            return this.list.toArray(new String[this.list.size()]);
        }

        public void close() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    protected static class TestInfo {
        private String executable;
        private String[] arguments;
        private int expectedReturnCode = 18;
        private Process process;
        private JavaVM jvm;
        private String[] outputContent;
        private String[] errorContent;

        public TestInfo(String executable, String[] arguments) {
            this.setExecutable(executable);
            this.setArguments(arguments);
        }

        public String getExecutable() {
            return this.executable;
        }

        private void setExecutable(String executable) {
            this.executable = executable;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        private void setArguments(String[] arguments) {
            this.arguments = arguments;
        }

        public JavaVM getJvm() {
            return this.jvm;
        }

        public void setJvm(JavaVM jvm) {
            this.jvm = jvm;
        }

        public Process getProcess() {
            return this.process;
        }

        public void setProcess(Process process) {
            this.process = process;
        }

        public String[] getOutputContent() {
            return this.outputContent;
        }

        public void setOutputContent(String[] outputContent) {
            this.outputContent = outputContent;
        }

        public String[] getErrorContent() {
            return this.errorContent;
        }

        public void setErrorContent(String[] errorContent) {
            this.errorContent = errorContent;
        }

        public int getExpectedReturnCode() {
            return this.expectedReturnCode;
        }

        public void setExpectedReturnCode(int expectedReturnCode) {
            this.expectedReturnCode = expectedReturnCode;
        }
    }
}

