/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.install;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.ArtifactDependency;
import com.spacekiller.infection.install.ArtifactKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArtifactModel {
    protected static final ArtifactComparator ARTIFACT_COMPARATOR_ASCENDING_VERSION = new ArtifactComparator(true);
    protected static final ArtifactComparator ARTIFACT_COMPARATOR_DESCENDING_VERSION = new ArtifactComparator(false);
    protected List artifactList = this.createArtifactList();
    protected Map artifactKeyMap = this.createArtifactKeyMap();

    protected static int compareArtifacts(Artifact a1, Artifact a2, boolean ascendingVersion) {
        if (a1 == a2) {
            return 0;
        }
        if (a1 == null) {
            return -1;
        }
        if (a2 == null) {
            return 1;
        }
        int comp = ArtifactModel.compareStrings(a1.getName(), a2.getName());
        if (comp != 0) {
            return comp;
        }
        comp = ArtifactModel.compareStrings(a1.getVersion(), a2.getVersion());
        if (comp != 0) {
            return ascendingVersion ? comp : -comp;
        }
        comp = ArtifactModel.compareStrings(a1.getOsPrefix(), a2.getOsPrefix());
        if (comp != 0) {
            return comp;
        }
        comp = ArtifactModel.compareStrings(a1.getOsArch(), a2.getOsArch());
        if (comp != 0) {
            return comp;
        }
        return 0;
    }

    protected static int compareStrings(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public String toString() {
        return super.toString() + "[artifacts=" + this.artifactList.size() + "]";
    }

    protected List createArtifactList() {
        return new LinkedList();
    }

    protected Map createArtifactKeyMap() {
        return new HashMap();
    }

    protected List createArtifactKeyMapList() {
        return new LinkedList();
    }

    public ArtifactKey artifactKey(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        String artifactName = artifact.getName();
        return this.artifactKey(artifactName);
    }

    public ArtifactKey artifactKey(ArtifactDependency dependency) {
        if (dependency == null) {
            return null;
        }
        String artifactName = dependency.getArtifact();
        return this.artifactKey(artifactName);
    }

    protected ArtifactKey artifactKey(String artifactName) {
        return new ArtifactKeyImpl(artifactName);
    }

    public ArtifactKey[] enumerateArtifactKeys() {
        Collection dstKeys = null;
        if ((dstKeys = this.enumerateArtifactKeys(dstKeys)) == null) {
            return null;
        }
        int num = dstKeys.size();
        if (num < 1) {
            return null;
        }
        return dstKeys.toArray(new ArtifactKey[num]);
    }

    protected Collection enumerateArtifactKeys(Collection dstKeys) {
        Set keySet = this.artifactKeyMap.keySet();
        if (keySet.isEmpty()) {
            return dstKeys;
        }
        if (dstKeys == null) {
            dstKeys = new ArrayList(keySet.size());
        }
        dstKeys.addAll(keySet);
        return dstKeys;
    }

    public int getArtifactCount() {
        return this.artifactList.size();
    }

    public Artifact[] getArtifacts() {
        return this.artifactList.toArray(new Artifact[this.artifactList.size()]);
    }

    public boolean containsArtifact(Artifact artifact) {
        if (artifact == null) {
            return false;
        }
        ArtifactKey artifactKey = this.artifactKey(artifact);
        List keyMapList = (List)this.artifactKeyMap.get(artifactKey);
        if (keyMapList == null) {
            return false;
        }
        return keyMapList.contains(artifact);
    }

    public boolean addArtifact(Artifact artifact) {
        if (artifact == null) {
            return false;
        }
        ArtifactKey artifactKey = this.artifactKey(artifact);
        List keyMapList = (List)this.artifactKeyMap.get(artifactKey);
        if (keyMapList == null) {
            keyMapList = this.createArtifactKeyMapList();
            this.artifactKeyMap.put(artifactKey, keyMapList);
        }
        keyMapList.add(artifact);
        this.artifactList.add(artifact);
        return true;
    }

    public int addAllArtifacts(Artifact[] artifacts) {
        int result = 0;
        if (artifacts != null) {
            for (Artifact fact : artifacts) {
                if (fact == null || !this.addArtifact(fact)) continue;
                ++result;
            }
        }
        return result;
    }

    public int addAllArtifacts(ArtifactModel model) {
        int result = 0;
        if (model != null && model.getArtifactCount() > 0) {
            Artifact[] artifacts = model.getArtifacts();
            this.addAllArtifacts(artifacts);
        }
        return result;
    }

    public boolean removeArtifact(Artifact artifact) {
        if (artifact == null) {
            return false;
        }
        ArtifactKey artifactKey = this.artifactKey(artifact);
        List keyMapList = (List)this.artifactKeyMap.get(artifactKey);
        if (keyMapList == null) {
            return false;
        }
        keyMapList.remove(artifact);
        return this.artifactList.remove(artifact);
    }

    public void removeAllArtifacts() {
        this.artifactList.clear();
        this.artifactKeyMap.clear();
    }

    public Artifact[] findArtifactsForKey(ArtifactKey artifactKey) {
        Collection dstEntries = null;
        if ((dstEntries = this.findArtifactsForKey(artifactKey, dstEntries)) == null) {
            return null;
        }
        int num = dstEntries.size();
        if (num < 1) {
            return null;
        }
        return dstEntries.toArray(new Artifact[num]);
    }

    public Artifact[] findArtifactsForVersion(ArtifactKey artifactKey, String version) {
        Collection dstEntries = null;
        if ((dstEntries = this.findArtifactsForVersion(artifactKey, version, dstEntries)) == null) {
            return null;
        }
        int num = dstEntries.size();
        if (num < 1) {
            return null;
        }
        return dstEntries.toArray(new Artifact[num]);
    }

    public Artifact[] findArtifactsForDependency(ArtifactKey artifactKey, ArtifactDependency dependency) {
        Collection dstEntries = null;
        if ((dstEntries = this.findArtifactsForDependency(artifactKey, dependency, dstEntries)) == null) {
            return null;
        }
        int num = dstEntries.size();
        if (num < 1) {
            return null;
        }
        return dstEntries.toArray(new Artifact[num]);
    }

    public Artifact[] findArtifactsForDependencyArray(ArtifactKey artifactKey, ArtifactDependency[] dependencyArray) {
        Collection dstEntries = null;
        if ((dstEntries = this.findArtifactsForDependencyArray(artifactKey, dependencyArray, dstEntries)) == null) {
            return null;
        }
        int num = dstEntries.size();
        if (num < 1) {
            return null;
        }
        return dstEntries.toArray(new Artifact[num]);
    }

    protected Collection findArtifactsForKey(ArtifactKey artifactKey, Collection dstEntries) {
        List keyMapList = (List)this.artifactKeyMap.get(artifactKey);
        if (keyMapList == null) {
            return dstEntries;
        }
        for (Artifact fact : keyMapList) {
            if (dstEntries == null) {
                dstEntries = new LinkedList<Artifact>();
            }
            dstEntries.add(fact);
        }
        return dstEntries;
    }

    protected Collection findArtifactsForVersion(ArtifactKey artifactKey, String version, Collection dstEntries) {
        List keyMapList = (List)this.artifactKeyMap.get(artifactKey);
        if (keyMapList == null) {
            return dstEntries;
        }
        for (Artifact fact : keyMapList) {
            String factVer = fact.getVersion();
            if (version != null && !version.equals(factVer)) continue;
            if (dstEntries == null) {
                dstEntries = new LinkedList<Artifact>();
            }
            dstEntries.add(fact);
        }
        return dstEntries;
    }

    protected Collection findArtifactsForDependency(ArtifactKey artifactKey, ArtifactDependency dependency, Collection dstEntries) {
        List keyMapList = (List)this.artifactKeyMap.get(artifactKey);
        if (keyMapList == null) {
            return dstEntries;
        }
        for (Artifact fact : keyMapList) {
            if (dependency != null && !dependency.acceptArtifact(fact)) continue;
            if (dstEntries == null) {
                dstEntries = new LinkedList<Artifact>();
            }
            dstEntries.add(fact);
        }
        return dstEntries;
    }

    public Collection findArtifactsForDependencyArray(ArtifactKey artifactKey, ArtifactDependency[] dependencyArray, Collection dstEntries) {
        List keyMapList = (List)this.artifactKeyMap.get(artifactKey);
        if (keyMapList == null) {
            return dstEntries;
        }
        for (Artifact fact : keyMapList) {
            if (!this.validateArtifact(fact, dependencyArray)) continue;
            if (dstEntries == null) {
                dstEntries = new LinkedList<Artifact>();
            }
            dstEntries.add(fact);
        }
        return dstEntries;
    }

    protected boolean validateArtifact(Artifact artifact, ArtifactDependency[] dependencyArray) {
        int num = dependencyArray.length;
        for (int i = 0; i < num; ++i) {
            if (dependencyArray[i].acceptArtifact(artifact)) continue;
            return false;
        }
        return true;
    }

    public void sortArtifactsByVersion(boolean ascendingVersion) {
        ArtifactComparator comparator = ascendingVersion ? ARTIFACT_COMPARATOR_ASCENDING_VERSION : ARTIFACT_COMPARATOR_DESCENDING_VERSION;
        this.sortArtifacts(comparator);
    }

    protected void sortArtifacts(Comparator comparator) {
        Artifact[] artifacts = this.getArtifacts();
        Artifact[] sortedArtifacts = this.sortArtifacts(artifacts, comparator);
        this.removeAllArtifacts();
        this.addAllArtifacts(sortedArtifacts);
    }

    protected Artifact[] sortArtifacts(Artifact[] artifacts, Comparator comparator) {
        int num = artifacts.length;
        Artifact[] sortArray = new Artifact[num];
        System.arraycopy(artifacts, 0, sortArray, 0, num);
        Arrays.sort(sortArray, comparator);
        return sortArray;
    }

    public void dumpArtifacts(StringBuffer sb) {
        boolean sort = false;
        this.dumpArtifacts(sort, sb);
    }

    public void dumpArtifacts(boolean sort, StringBuffer sb) {
        this.dumpArtifacts(sort, false, sb);
    }

    public void dumpArtifacts(boolean sort, boolean dependencies, StringBuffer sb) {
        Artifact[] artifacts = this.getArtifacts();
        if (sort) {
            ArtifactComparator comparator = ARTIFACT_COMPARATOR_ASCENDING_VERSION;
            artifacts = this.sortArtifacts(artifacts, comparator);
        }
        int num = artifacts.length;
        for (int i = 0; i < num; ++i) {
            this.dumpArtifact(artifacts[i], dependencies, sb);
        }
    }

    public void dumpArtifact(Artifact artifact, StringBuffer sb) {
        this.dumpArtifact(artifact, false, sb);
    }

    public void dumpArtifact(Artifact artifact, boolean dependencies, StringBuffer sb) {
        if (artifact == null) {
            return;
        }
        sb.append("" + artifact);
        sb.append("\n");
        if (!dependencies) {
            return;
        }
        int num = artifact.getDependencyCount();
        for (int i = 0; i < num; ++i) {
            ArtifactDependency dependency = artifact.getDependencyAt(i);
            if (dependency == null) continue;
            sb.append("    -> " + dependency);
            sb.append("\n");
        }
    }

    protected static class ArtifactComparator
    implements Comparator {
        private final boolean ascendingVersion;

        public ArtifactComparator(boolean ascendingVersion) {
            this.ascendingVersion = ascendingVersion;
        }

        public int compare(Object o1, Object o2) {
            Artifact e1 = (Artifact)o1;
            Artifact e2 = (Artifact)o2;
            return ArtifactModel.compareArtifacts(e1, e2, this.ascendingVersion);
        }
    }

    protected static class ArtifactKeyImpl
    implements ArtifactKey {
        private static final long serialVersionUID = -8435706269875528772L;
        private final String artifactName;

        public ArtifactKeyImpl(String artifactName) {
            if (artifactName == null) {
                throw new NullPointerException("artifactName is null");
            }
            this.artifactName = artifactName;
        }

        protected final String getArtifactName() {
            return this.artifactName;
        }

        public String toString() {
            return this.artifactName;
        }

        public int hashCode() {
            return this.artifactName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ArtifactKeyImpl) {
                ArtifactKeyImpl key = (ArtifactKeyImpl)obj;
                if (this.artifactName.equals(key.artifactName)) {
                    return true;
                }
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o != null && o instanceof ArtifactKeyImpl) {
                ArtifactKeyImpl k = (ArtifactKeyImpl)o;
                String otherArtifactName = k.artifactName;
                String thisArtifactName = this.artifactName;
                if (thisArtifactName == null) {
                    return otherArtifactName == null ? 0 : -1;
                }
                return thisArtifactName.compareTo(otherArtifactName);
            }
            return 1;
        }
    }
}

