/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.install;

import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.install.DownloadSiteTask;
import com.spacekiller.infection.install.InstallerTask;
import com.spacekiller.infection.install.InstallerTaskListener;
import com.spacekiller.infection.install.InstallerTaskManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class DownloadSiteQueue
implements InstallerTaskListener {
    private InstallerTaskManager taskManager;
    private boolean recursiveSubSites;
    private DefaultTreeModel siteTreeModel;
    private DefaultMutableTreeNode siteRootNode;
    private Set siteDone = new HashSet();
    private Map site2Node = new HashMap();
    private Set loadingSites = new HashSet();
    private Set queuedSites = new HashSet();
    private Set loadedSites = new HashSet();

    public DownloadSiteQueue(InstallerTaskManager taskManager, boolean recursiveSubSites, DefaultTreeModel siteTreeModel, DefaultMutableTreeNode siteRootNode) {
        this.taskManager = taskManager;
        taskManager.setListener(this);
        this.recursiveSubSites = recursiveSubSites;
        this.siteTreeModel = siteTreeModel;
        this.siteRootNode = siteRootNode;
    }

    public void addSite(final InfectionSite site) {
        String siteURL = site.getURL();
        if (this.siteDone.contains(siteURL)) {
            return;
        }
        this.siteDone.add(siteURL);
        this.queuedSites.add(site);
        this.taskManager.addTask(new DownloadSiteTask(this, site, this.recursiveSubSites));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadSiteQueue.this.insertSiteNode(site);
            }
        });
    }

    private void insertSiteNode(InfectionSite site) {
        int cc;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        node.setUserObject(site);
        this.site2Node.put(site, node);
        InfectionSite parentSite = site.getParent();
        if (parentSite != null) {
            try {
                if (!site.isSiteFromSameHost(parentSite)) {
                    parentSite = null;
                }
            }
            catch (IOException e) {
                parentSite = null;
            }
        }
        DefaultMutableTreeNode nx = null;
        if (parentSite != null) {
            nx = (DefaultMutableTreeNode)this.site2Node.get(parentSite);
        }
        DefaultMutableTreeNode parentNode = nx == null ? this.siteRootNode : nx;
        String name = site.getName();
        if (name == null) {
            name = "unknown";
        }
        int insertIndex = cc = parentNode.getChildCount();
        for (int i = 0; i < cc; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            InfectionSite childSite = (InfectionSite)childNode.getUserObject();
            String childName = childSite.getName();
            if (name.compareToIgnoreCase(childName) >= 0) continue;
            insertIndex = i;
            break;
        }
        this.siteTreeModel.insertNodeInto(node, parentNode, insertIndex);
        if (cc == 0) {
            this.siteTreeModel.nodeStructureChanged(parentNode);
        }
    }

    public boolean isSiteLoading(InfectionSite site) {
        if (this.loadingSites.contains(site)) {
            return true;
        }
        InfectionIndex index = site.getIndex();
        if (index != null) {
            int count = index.getSiteCount();
            for (int c = 0; c < count; ++c) {
                InfectionSite sub = index.getSiteAt(c);
                if (!this.isSiteLoading(sub)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSiteQueued(InfectionSite site) {
        if (this.queuedSites.contains(site)) {
            return true;
        }
        InfectionIndex index = site.getIndex();
        if (index != null) {
            int count = index.getSiteCount();
            for (int c = 0; c < count; ++c) {
                InfectionSite sub = index.getSiteAt(c);
                if (!this.isSiteQueued(sub)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSiteLoaded(InfectionSite site) {
        return this.loadedSites.contains(site.getURL());
    }

    public boolean isSiteLoadedRecursive(InfectionSite site) {
        InfectionIndex index = site.getIndex();
        if (index == null) {
            return this.isSiteLoaded(site);
        }
        int count = index.getSiteCount();
        if (count > 0) {
            for (int c = 0; c < count; ++c) {
                InfectionSite sub = index.getSiteAt(c);
                try {
                    if (!site.isSiteFromSameHost(sub) || site.isSiteEqual(sub) || this.isSiteLoadedRecursive(sub)) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void taskStarted(InstallerTask task) {
        DownloadSiteTask t = (DownloadSiteTask)task;
        InfectionSite site = t.getSite();
        if (site != null) {
            this.loadingSites.add(site);
            this.queuedSites.remove(site);
            this.refreshSiteTreeNode(site);
        }
    }

    @Override
    public void taskCompleted(InstallerTask task) {
        DownloadSiteTask t = (DownloadSiteTask)task;
        InfectionSite site = t.getSite();
        if (site != null) {
            this.loadedSites.add(site.getURL());
            this.loadingSites.remove(site);
            this.refreshSiteTreeNode(site);
        }
    }

    protected void refreshSiteTreeNode(InfectionSite site) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DownloadSiteQueue.this.siteTreeModel.nodeStructureChanged(DownloadSiteQueue.this.siteRootNode);
            }
        };
        SwingUtilities.invokeLater(run);
    }
}

