/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.install;

import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.install.DownloadSiteQueue;
import com.spacekiller.infection.install.InstallerTask;
import com.spacekiller.infection.util.InfectionXmlUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DownloadSiteTask
implements InstallerTask {
    private static final Logger logger = Logger.getLogger(DownloadSiteTask.class.getName());
    private boolean running;
    private boolean cancel;
    private int status = 0;
    private DownloadSiteQueue queue;
    private InfectionSite site;
    private boolean recursiveSubSites;

    public DownloadSiteTask(DownloadSiteQueue queue, InfectionSite site, boolean recursiveSubSites) {
        this.setQueue(queue);
        this.setSite(site);
        this.setRecursiveSubSites(recursiveSubSites);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        this.cancel = false;
        this.setRunning(true);
        this.setStatus(1);
        boolean success = false;
        try {
            InfectionSite sub;
            int c;
            InfectionIndex index = null;
            try {
                index = this.loadInfectionIndex(this.site);
                this.site.setError(null);
                this.site.setIndex(index);
            }
            catch (Exception e) {
                this.site.setIndex(null);
                this.site.setError(e);
                logger.info("Error while loading site: " + this.site);
                this.handleException(e);
            }
            if (index != null) {
                int num = index.getSiteCount();
                for (c = 0; c < num; ++c) {
                    sub = index.getSiteAt(c);
                    sub.setParent(this.site);
                }
            }
            if (this.recursiveSubSites && index != null && this.site.isRecursive()) {
                int num = index.getSiteCount();
                for (c = 0; c < num; ++c) {
                    sub = index.getSiteAt(c);
                    if (sub == null || !sub.isActive()) continue;
                    this.queue.addSite(sub);
                }
            }
            success = true;
        }
        finally {
            this.setRunning(false);
            if (success) {
                this.setStatus(2);
            } else {
                this.setStatus(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InfectionIndex loadInfectionIndex(InfectionSite site) throws Exception {
        String siteURL = site.getURL();
        logger.fine("Reading site index: " + siteURL);
        URL url = new URL(siteURL);
        InputStream in = url.openStream();
        try {
            InputStream input = in;
            if (siteURL.endsWith(".zip")) {
                ZipInputStream zin = new ZipInputStream(in);
                ZipEntry ze = zin.getNextEntry();
                logger.fine("Reading zip-entry: " + ze.getName());
                input = zin;
            }
            InfectionIndex index = new InfectionIndex(site);
            InfectionXmlUtil xmlUtil = new InfectionXmlUtil(index);
            xmlUtil.loadIndex(input);
            InfectionIndex infectionIndex = index;
            return infectionIndex;
        }
        finally {
            in.close();
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    public InfectionSite getSite() {
        return this.site;
    }

    protected void setSite(InfectionSite site) {
        this.site = site;
    }

    public boolean isRecursiveSubSites() {
        return this.recursiveSubSites;
    }

    protected void setRecursiveSubSites(boolean recursiveSubSites) {
        this.recursiveSubSites = recursiveSubSites;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    protected DownloadSiteQueue getQueue() {
        return this.queue;
    }

    protected void setQueue(DownloadSiteQueue queue) {
        this.queue = queue;
    }
}

