/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.install;

import com.spacekiller.infection.Artifact;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;

public class InstallationArtifactTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -1485096007754844308L;
    private List artifacts;
    private ListSelectionModel checkModel;
    private ListSelectionModel enableModel;
    private ListSelectionModel missingModel;

    public InstallationArtifactTableModel() {
        this.initArtifactTableModel();
    }

    protected void initArtifactTableModel() {
        this.artifacts = new ArrayList();
        this.checkModel = new DefaultListSelectionModel();
        this.enableModel = new DefaultListSelectionModel();
        this.missingModel = new DefaultListSelectionModel();
        this.addColumn("selected");
        this.addColumn("artifact");
        this.addColumn("title");
        this.addColumn("version");
        this.addColumn("vendor");
        this.addColumn("size");
        this.addColumn("time");
        this.addColumn("installed");
    }

    public boolean isArtifactChecked(int row) {
        return this.checkModel.isSelectedIndex(row);
    }

    public void selectArtifact(int row, boolean selected, boolean manual) {
        Artifact art = this.getArtifactAt(row);
        if (art != null) {
            art.setInstallMode(selected && manual ? 1 : 0);
        }
        if (selected) {
            this.checkModel.addSelectionInterval(row, row);
        } else {
            this.checkModel.removeSelectionInterval(row, row);
        }
        this.setValueAt(new Boolean(selected), row, 0);
    }

    public boolean isArtifactEnabled(int row) {
        return this.enableModel.isSelectedIndex(row);
    }

    public void enableArtifact(int row, boolean enabled) {
        if (enabled) {
            this.enableModel.addSelectionInterval(row, row);
        } else {
            this.enableModel.removeSelectionInterval(row, row);
        }
    }

    public boolean isArtifactMissing(int row) {
        return this.missingModel.isSelectedIndex(row);
    }

    public void setArtifactMissing(int row, boolean missing) {
        if (missing) {
            this.missingModel.addSelectionInterval(row, row);
        } else {
            this.missingModel.removeSelectionInterval(row, row);
        }
    }

    public void addArtifact(Artifact fact) {
        if (fact == null) {
            return;
        }
        int size = fact.getLength();
        String sizeString = "N/A";
        if (size >= 0) {
            sizeString = "" + size;
        }
        long time = fact.getTime();
        String dateString = "N/A";
        if (time != 0L) {
            Date date = new Date(time);
            dateString = "" + date;
        }
        long install = fact.getInstallTime();
        String installString = "-";
        if (install != 0L) {
            Date date = new Date(install);
            installString = "" + date;
        }
        Object[] row = new Object[]{new Boolean(false), fact.getName(), fact.getTitle(), fact.getVersion(), fact.getVendor(), sizeString, dateString, installString};
        this.addRow(row);
        this.artifacts.add(fact);
    }

    public Artifact getArtifactAt(int row) {
        if (row < 0) {
            return null;
        }
        if (row >= this.artifacts.size()) {
            return null;
        }
        return (Artifact)this.artifacts.get(row);
    }

    public void removeAllArtifacts() {
        int num = this.artifacts.size();
        for (int c = num - 1; c >= 0; --c) {
            this.removeArtifactAt(c);
        }
    }

    public void removeArtifactAt(int row) {
        this.removeRow(row);
        this.artifacts.remove(row);
    }

    public ListSelectionModel getCheckModel() {
        return this.checkModel;
    }

    public void setCheckModel(ListSelectionModel checkModel) {
        this.checkModel = checkModel;
    }
}

