/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.install;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.ArtifactDependency;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstaller;
import com.spacekiller.infection.InfectionRuntime;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.InfectionUtil;
import com.spacekiller.infection.install.ArtifactKey;
import com.spacekiller.infection.install.ArtifactModel;
import com.spacekiller.infection.install.DownloadArtifactTask;
import com.spacekiller.infection.install.DownloadSiteQueue;
import com.spacekiller.infection.install.InstallationArtifactTableModel;
import com.spacekiller.infection.install.InstallerPageContext;
import com.spacekiller.infection.install.InstallerStrategy;
import com.spacekiller.infection.install.InstallerStrategyV10;
import com.spacekiller.infection.install.InstallerTaskListener;
import com.spacekiller.infection.install.InstallerTaskManager;
import com.spacekiller.infection.util.InfectionXmlUtil;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public abstract class InstallerPageManager {
    private static final Logger logger = Logger.getLogger(InstallerPageManager.class.getName());
    private String distributionTitle;
    private InfectionRuntime runtime;
    private InfectionInstaller installer;
    private File installationDirectory;
    private InfectionInstallation installation;
    private InfectionIndex installationIndex;
    private InstallationArtifactTableModel installedArtifacts;
    private DownloadSiteQueue siteDownloadQueue;
    private DefaultTreeModel siteTreeModel;
    private DefaultMutableTreeNode siteRootNode;
    private long refreshUpdateSitesId = 0L;
    private long nextRefreshUpdateSitesId = 1L;
    private FireUpdateSiteChange fireUpdateSiteChange = new FireUpdateSiteChange();
    private EventListenerList updateSiteChangeListeners;
    private boolean promptUpgrade = true;
    private boolean autoSaveConfig = false;
    private boolean promptRestart = false;

    protected InstallerPageManager() {
        this.installedArtifacts = new InstallationArtifactTableModel();
        this.siteRootNode = new DefaultMutableTreeNode();
        this.siteTreeModel = new DefaultTreeModel(this.siteRootNode);
        this.updateSiteChangeListeners = new EventListenerList();
    }

    public abstract boolean closePageManager();

    public abstract boolean showLicenseAcceptPage();

    public abstract boolean showLocationMenuPage();

    protected boolean startSitesUpdate(boolean sync) {
        try {
            if (this.installer != null) {
                this.installer.initInstallationDirectory(this.installation);
            }
            boolean refresh = true;
            this.showUpdateSitesTreePage(refresh);
            this.refreshUpdateSites(sync);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    public abstract boolean showSitesProxyPage();

    public abstract boolean showSitesAddPage();

    public abstract boolean showLocationConfigPage();

    public abstract boolean showLocationCleanupPage();

    public boolean showUpdateSitesTreePage() {
        boolean refresh = true;
        return this.showUpdateSitesTreePage(refresh);
    }

    public abstract boolean showUpdateSitesTreePage(boolean var1);

    public boolean showArtifactsTablePage() {
        boolean refresh = true;
        return this.showArtifactsTablePage(refresh);
    }

    public abstract boolean showArtifactsTablePage(boolean var1);

    protected abstract boolean showArtifactsDownloadPage();

    protected InfectionRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(InfectionRuntime runtime) {
        this.runtime = runtime;
    }

    protected InfectionInstaller getInstaller() {
        return this.installer;
    }

    public void setInstaller(InfectionInstaller installer) {
        this.installer = installer;
    }

    protected InfectionInstallation getInstallation() {
        return this.installation;
    }

    public void setInstallation(InfectionInstallation installation) {
        this.installation = installation;
    }

    protected InfectionIndex getInstallationIndex() {
        return this.installationIndex;
    }

    protected void setInstallationIndex(InfectionIndex installationIndex) {
        this.installationIndex = installationIndex;
    }

    public String getDistributionTitle() {
        return this.distributionTitle;
    }

    public void setDistributionTitle(String distributionTitle) {
        this.distributionTitle = distributionTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDistributionLicenseText() throws Exception {
        String licenseText = null;
        InputStream in = Infection.getInstance().getDistributionResourceInput("license");
        if (in != null) {
            try {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                StringBuffer buf = new StringBuffer();
                while ((s = reader.readLine()) != null) {
                    buf.append(s);
                    buf.append("\n");
                }
                licenseText = buf.toString();
            }
            finally {
                in.close();
            }
        }
        if (licenseText == null) {
            licenseText = "License file not found!";
        }
        return licenseText;
    }

    protected InputStream getDistributionResourceInput(String resourceKey) throws Exception {
        return Infection.getInstance().getDistributionResourceInput(resourceKey);
    }

    protected Image getDistributionResourceImage(String resourceKey) throws Exception {
        return Infection.getInstance().getDistributionResourceImage(resourceKey);
    }

    protected Icon getDistributionResourceIcon(String resourceKey) throws Exception {
        return Infection.getInstance().getDistributionResourceIcon(resourceKey);
    }

    protected File getIndexFileForLocation(File installDir) {
        File indexDir = new File(installDir, ".artifacts");
        File indexFile = new File(indexDir, "index.xml");
        return indexFile;
    }

    protected synchronized File getInstallationDirectory() {
        return this.installationDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInstallationDirectory(File dir) throws Exception {
        InfectionIndex idx;
        this.installationDirectory = null;
        this.installation = null;
        this.installationIndex = null;
        if (dir == null) {
            return;
        }
        this.installationDirectory = dir;
        File indexFile = this.getIndexFileForLocation(dir);
        URL instHomeURL = InfectionUtil.getFileURL(indexFile);
        InfectionSite site = new InfectionSite(instHomeURL.toString());
        this.installationIndex = idx = new InfectionIndex(site);
        File indexDir = indexFile.getParentFile();
        this.installation = new InfectionInstallation(indexDir, indexFile);
        this.installation.setIndex(idx);
        try {
            if (indexFile.exists()) {
                InfectionXmlUtil xmlUtil = new InfectionXmlUtil(idx);
                xmlUtil.loadIndex(indexFile);
            }
        }
        finally {
            this.refreshInstalledArtifacts();
        }
    }

    protected String getInstallationProblemText() {
        File[] files;
        File file = this.installationDirectory;
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return "The specified path is not a directory!";
        }
        boolean indexFileExists = false;
        boolean existingInstance = false;
        InfectionInstallation inst = this.installation;
        if (inst != null) {
            File indexFile = inst.getIndexFile();
            boolean bl = indexFileExists = indexFile != null && indexFile.exists();
        }
        if (!indexFileExists && !existingInstance && (files = file.listFiles()) != null && files.length > 0) {
            boolean instanceFound = false;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!f.isDirectory() || !f.exists() || !new File(f, "instance.xml").exists()) continue;
                instanceFound = true;
                break;
            }
            if (!instanceFound) {
                return "The specified directory is not empty!";
            }
        }
        return null;
    }

    protected synchronized void refreshInstalledArtifacts() throws Exception {
        TreeMap<String, ArrayList<Artifact>> arts = new TreeMap<String, ArrayList<Artifact>>();
        this.installedArtifacts.removeAllArtifacts();
        InfectionIndex index = this.installationIndex;
        if (index == null) {
            return;
        }
        int factCount = index.getArtifactCount();
        for (int i = 0; i < factCount; ++i) {
            String artName;
            Artifact fact = index.getArtifactAt(i);
            if (fact == null || (artName = fact.getName()) == null) continue;
            ArrayList<Artifact> artList = (ArrayList<Artifact>)arts.get(artName);
            if (artList == null) {
                artList = new ArrayList<Artifact>();
                arts.put(artName, artList);
            }
            artList.add(fact);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("refreshInstalledArtifacts: " + arts.size());
        }
        for (Map.Entry entry : arts.entrySet()) {
            ArrayList artList = (ArrayList)entry.getValue();
            int numArts = artList.size();
            for (int j = 0; j < numArts; ++j) {
                Artifact fact = (Artifact)artList.get(j);
                int row = this.installedArtifacts.getRowCount();
                this.installedArtifacts.addArtifact(fact);
                this.installedArtifacts.enableArtifact(row, true);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("refreshInstalledArtifacts: #" + row + " = " + fact);
            }
        }
    }

    protected synchronized int getInstalledArtifactCount() {
        return this.installedArtifacts.getRowCount();
    }

    protected synchronized Artifact getInstalledArtifact(String factName, String factVersion) {
        InfectionIndex index = this.installationIndex;
        if (index == null) {
            return null;
        }
        Artifact existing = index.getArtifact(factName, factVersion);
        return existing;
    }

    public synchronized void verifyInstalledArtifact(Artifact artifact) throws Exception {
        this.installer.verifyArtifact(this.installation, this.installationIndex, artifact);
    }

    public synchronized Artifact[] enumerateUnusedArtifacts() throws Exception {
        Artifact[] unusedArtifacts = this.installer.enumerateUnusedArtifacts(this.installation, this.installationIndex);
        return unusedArtifacts;
    }

    public synchronized Artifact[] cleanupUnusedArtifacts() throws Exception {
        Artifact[] unusedArtifacts = this.installer.cleanupUnusedArtifacts(this.installation, this.installationIndex);
        return unusedArtifacts;
    }

    protected DefaultTreeModel getSiteTreeModel() {
        return this.siteTreeModel;
    }

    protected int getUpdateSiteState(InfectionSite site) {
        DownloadSiteQueue queue = this.siteDownloadQueue;
        if (queue == null || site.getError() != null) {
            return 1;
        }
        if (queue.isSiteLoading(site)) {
            return 3;
        }
        if (queue.isSiteQueued(site)) {
            return 2;
        }
        if (!queue.isSiteLoaded(site)) {
            return 4;
        }
        if (!queue.isSiteLoadedRecursive(site)) {
            return 5;
        }
        return 6;
    }

    protected synchronized boolean addUpdateSite(InfectionSite site) throws Exception {
        this.installer.addSite(this.installation, this.installationIndex, site);
        SwingUtilities.invokeLater(this.fireUpdateSiteChange);
        return true;
    }

    protected synchronized boolean removeUpdateSite(InfectionSite site) throws Exception {
        TreeNode node;
        Object root;
        this.installer.removeSite(this.installation, this.installationIndex, site);
        boolean removed = false;
        DefaultTreeModel model = this.getSiteTreeModel();
        if (model != null && (root = model.getRoot()) != null && root instanceof TreeNode && this.removeUpdateSiteNode(site, model, node = (TreeNode)root)) {
            removed = true;
        }
        if (removed) {
            SwingUtilities.invokeLater(this.fireUpdateSiteChange);
        }
        return true;
    }

    private boolean removeUpdateSiteNode(InfectionSite site, DefaultTreeModel model, TreeNode node) throws Exception {
        boolean removed = false;
        int num = node.getChildCount();
        for (int i = num - 1; i >= 0; --i) {
            DefaultMutableTreeNode childSiteNode;
            InfectionSite childSite;
            TreeNode child = node.getChildAt(i);
            if (child instanceof DefaultMutableTreeNode && (childSite = (InfectionSite)(childSiteNode = (DefaultMutableTreeNode)child).getUserObject()) == site) {
                childSiteNode.removeFromParent();
                model.nodeStructureChanged(node);
                removed = true;
                continue;
            }
            if (!this.removeUpdateSiteNode(site, model, child)) continue;
            removed = true;
        }
        return removed;
    }

    protected void resetDefaultUpdateSites() throws Exception {
        boolean siteAdded = false;
        int num = this.installer.getDefaultSiteCount();
        logger.info("Adding default update sites: " + num);
        for (int i = 0; i < num; ++i) {
            InfectionSite site = this.installer.getDefaultSiteAt(i);
            if (site == null) continue;
            logger.info("Adding default update site: " + site);
            this.installer.addSite(this.installation, this.installationIndex, site);
            siteAdded = true;
        }
        if (siteAdded) {
            boolean sync = false;
            this.refreshUpdateSites(sync);
        }
    }

    protected synchronized void addUpdateSiteChangeListener(ChangeListener listener) {
        this.updateSiteChangeListeners.add(ChangeListener.class, listener);
    }

    protected synchronized void removeUpdateSiteChangeListener(ChangeListener listener) {
        this.updateSiteChangeListeners.remove(ChangeListener.class, listener);
    }

    protected synchronized void fireUpdateSiteChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        this.fireUpdateSiteChangeEvent(event);
    }

    protected synchronized void fireUpdateSiteChangeEvent(ChangeEvent event) {
        Object[] list = this.updateSiteChangeListeners.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ChangeListener)list[i]).stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUpdateSites(final boolean sync) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("refreshSites: sync=" + sync);
        }
        Runnable target = new Runnable(){

            @Override
            public void run() {
                try {
                    InstallerPageManager.this.refreshUpdateSitesImpl(InstallerPageManager.this.installation, sync);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        };
        InstallerPageManager installerPageManager = this;
        synchronized (installerPageManager) {
            this.setRefreshUpdateSitesId(this.nextRefreshUpdateSitesId++);
        }
        if (sync) {
            target.run();
        } else {
            String name = "UpdateSiteRefresher";
            Thread thread = new Thread(target, name);
            thread.start();
        }
    }

    protected boolean isRefreshUpdateSitesRunning() {
        return this.refreshUpdateSitesId != 0L;
    }

    protected synchronized long getRefreshUpdateSitesId() {
        return this.refreshUpdateSitesId;
    }

    protected synchronized void setRefreshUpdateSitesId(long refreshUpdateSitesId) {
        this.refreshUpdateSitesId = refreshUpdateSitesId;
        SwingUtilities.invokeLater(this.fireUpdateSiteChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refreshUpdateSitesImpl(InfectionInstallation installation, boolean sync) throws Exception {
        logger.info("Refreshing update-sites: sync=" + sync);
        long refreshId = -1L;
        try {
            InstallerPageManager installerPageManager = this;
            synchronized (installerPageManager) {
                refreshId = this.nextRefreshUpdateSitesId++;
                this.setRefreshUpdateSitesId(refreshId);
            }
            boolean recursiveSubSites = true;
            int numThreads = 5;
            InstallerTaskManager taskManager = new InstallerTaskManager(numThreads);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("refreshSites: taskManager=" + taskManager + ", numThreads=" + numThreads);
            }
            InstallerPageManager installerPageManager2 = this;
            synchronized (installerPageManager2) {
                DownloadSiteQueue siteDownloadQueue;
                this.siteRootNode.removeAllChildren();
                this.siteDownloadQueue = siteDownloadQueue = new DownloadSiteQueue(taskManager, recursiveSubSites, this.siteTreeModel, this.siteRootNode);
                InfectionIndex x = installation.getIndex();
                int num = x == null ? 0 : x.getSiteCount();
                int activeSites = 0;
                for (int i = 0; i < num; ++i) {
                    InfectionSite site = x.getSiteAt(i);
                    if (!site.isActive()) continue;
                    siteDownloadQueue.addSite(site);
                    ++activeSites;
                }
                if (activeSites < 1) {
                    return;
                }
            }
            taskManager.run();
        }
        finally {
            InstallerPageManager installerPageManager = this;
            synchronized (installerPageManager) {
                if (this.getRefreshUpdateSitesId() == refreshId) {
                    this.setRefreshUpdateSitesId(0L);
                }
            }
        }
        logger.info("Refreshing update-sites: done.");
    }

    protected abstract InfectionSite[] getSelectedUpdateSites();

    protected InfectionSite[] getSelectedUpdateSitesRecursive() {
        InfectionSite[] sites = this.getSelectedUpdateSites();
        int num = sites.length;
        LinkedList<InfectionSite> list = new LinkedList<InfectionSite>();
        boolean recursive = true;
        for (int i = 0; i < num; ++i) {
            InfectionSite site = sites[i];
            if (site == null || !site.isActive() || list.contains(site)) continue;
            list.add(site);
            if (!recursive) continue;
            this.getSubSitesRecursive(site, list);
        }
        return list.toArray(new InfectionSite[list.size()]);
    }

    protected void getSubSitesRecursive(InfectionSite site, List dstSites) {
        if (site == null) {
            return;
        }
        if (!site.isActive()) {
            return;
        }
        if (!site.isRecursive()) {
            return;
        }
        InfectionIndex index = site.getIndex();
        int num = index == null ? 0 : index.getSiteCount();
        for (int i = 0; i < num; ++i) {
            InfectionSite subSite = index.getSiteAt(i);
            if (subSite == null || !subSite.isActive() || dstSites.contains(subSite)) continue;
            dstSites.add(subSite);
            this.getSubSitesRecursive(subSite, dstSites);
        }
    }

    protected String getDistributionArtifactName() throws Exception {
        return Infection.getInstance().getDistributionProperty("artifact");
    }

    protected ArtifactDependency[] getDistributionArtifactDependencies(String distArtifactName) throws Exception {
        InfectionInstaller installer = this.getInstaller();
        if (installer == null) {
            return null;
        }
        return installer.getDistributionArtifactDependencies(distArtifactName);
    }

    public boolean startDownloadArtifacts(boolean sync) {
        try {
            this.showArtifactsDownloadPage();
            this.downloadSelectedArtifacts(sync);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    protected void downloadSelectedArtifacts(boolean sync) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("downloadSelectedArtifacts: sync=" + sync);
        }
        Runnable target = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean success = InstallerPageManager.this.downloadSelectedArtifactsImpl(InstallerPageManager.this.installation);
                    if (success) {
                        boolean refresh = true;
                        InstallerPageManager.this.showArtifactsConfigPage(refresh);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        };
        if (sync) {
            target.run();
        } else {
            String name = "ArtifactDownloader";
            Thread thread = new Thread(target, name);
            thread.start();
        }
    }

    public abstract Artifact[] getSelectedDownloadArtifacts();

    protected abstract InstallerTaskListener createArtifactsDownloadListener(InstallerTaskManager var1);

    protected boolean downloadSelectedArtifactsImpl(InfectionInstallation installation) throws Exception {
        File indexDir;
        if (this.installationIndex == null) {
            throw new NullPointerException("instanceIndex");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Downloading selected artifacts...");
        }
        Artifact[] downloadArtifacts = this.getSelectedDownloadArtifacts();
        int num = downloadArtifacts.length;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Selected download artifacts: " + num);
        }
        if (num < 1) {
            return true;
        }
        File tempDir = indexDir = installation.getIndexDirectory();
        int numThreads = 5;
        InstallerTaskManager taskManager = new InstallerTaskManager(numThreads);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("downloadSelectedArtifactsImpl: taskManager=" + taskManager + ", numThreads=" + numThreads);
        }
        DownloadArtifactTask[] tasks = new DownloadArtifactTask[num];
        for (int i = 0; i < num; ++i) {
            DownloadArtifactTask task;
            Artifact fact = downloadArtifacts[i];
            String factName = fact.getName();
            String factVersion = fact.getVersion();
            String title = "" + factName.trim();
            if (factVersion != null) {
                title = title + "-" + factVersion.trim();
            }
            String tempName = "download-" + i + ".tmp";
            File tempFile = new File(tempDir, tempName);
            tasks[i] = task = new DownloadArtifactTask(title, this.installer, installation, this.installationIndex, fact, tempFile);
            InfectionSite[] selectedSitesRecursive = this.getSelectedUpdateSitesRecursive();
            int numSites = selectedSitesRecursive.length;
            for (int m = 0; m < numSites; ++m) {
                try {
                    InfectionSite site = selectedSitesRecursive[m];
                    InfectionIndex index = site.getIndex();
                    if (index == null) continue;
                    int factCount = index.getArtifactCount();
                    for (int j = 0; j < factCount; ++j) {
                        String artVer;
                        String artName;
                        Artifact art = index.getArtifactAt(j);
                        if (art == null || (artName = art.getName()) == null || !artName.equals(factName) || (artVer = art.getVersion()) == null || !artVer.equals(factVersion)) continue;
                        task.addMirrorArtifact(art);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            taskManager.addTask(task);
        }
        InstallerTaskListener listener = this.createArtifactsDownloadListener(taskManager);
        taskManager.setListener(listener);
        taskManager.run();
        boolean success = true;
        for (int i = 0; i < num; ++i) {
            if (tasks[i].getStatus() == 2) continue;
            success = false;
            logger.warning("Download task failed: " + tasks[i].getTitle());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("downloadSelectedArtifactsImpl: success=" + success);
        }
        return success;
    }

    protected abstract boolean showInstanceConfigPage(boolean var1);

    protected boolean showArtifactsConfigPage() {
        boolean refresh = true;
        return this.showArtifactsConfigPage(refresh);
    }

    protected abstract boolean showArtifactsConfigPage(boolean var1);

    protected void enumerateAvailableArtifacts(InfectionIndex index, ArtifactModel dstArtifactModel) {
        Collection dstEntries = null;
        int factCount = index.getArtifactCount();
        for (int i = 0; i < factCount; ++i) {
            ArtifactKey artifactKey;
            Artifact fact = index.getArtifactAt(i);
            if (fact == null) continue;
            String version = fact.getVersion();
            if (version != null && (dstEntries = dstArtifactModel.findArtifactsForVersion(artifactKey = dstArtifactModel.artifactKey(fact), version, dstEntries)) != null && !dstEntries.isEmpty()) {
                dstEntries.clear();
                continue;
            }
            dstArtifactModel.addArtifact(fact);
        }
    }

    protected ArtifactModel createInstallerModel() {
        return new ArtifactModel();
    }

    protected synchronized ArtifactModel computeUpgradeArtifacts(ArtifactModel availableArtifactModel) throws Exception {
        InstallationArtifactTableModel installedArtifactTableModel = this.installedArtifacts;
        String distArtifactName = this.getDistributionArtifactName();
        ArtifactDependency[] dependencies = this.getDistributionArtifactDependencies(distArtifactName);
        return this.computeUpgradeArtifacts(installedArtifactTableModel, dependencies, availableArtifactModel);
    }

    protected ArtifactModel computeUpgradeArtifacts(InstallationArtifactTableModel installedArtifactTableModel, ArtifactDependency[] dependencies, ArtifactModel availableArtifactModel) {
        ArtifactModel currentArtifactModel = this.createInstallerModel();
        if (installedArtifactTableModel != null) {
            int num = installedArtifactTableModel.getRowCount();
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Number of installed artifacts: " + num);
            }
            for (int i = 0; i < num; ++i) {
                Artifact art = installedArtifactTableModel.getArtifactAt(i);
                if (art == null) continue;
                currentArtifactModel.addArtifact(art);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine(" - " + art);
            }
        }
        return this.computeUpgradeArtifacts(currentArtifactModel, dependencies, availableArtifactModel);
    }

    protected ArtifactModel computeUpgradeArtifacts(ArtifactModel currentArtifactModel, ArtifactDependency[] dependencies, ArtifactModel availableArtifactModel) {
        InstallerStrategy strategy = this.createInstallerStrategy();
        strategy.setAvailableArtifactModel(availableArtifactModel);
        strategy.setDependencies(dependencies);
        strategy.setCurrentArtifactModel(currentArtifactModel);
        strategy.setStrategy(1);
        boolean includeOptionalDependencies = true;
        strategy.setIncludeOptionalDependencies(includeOptionalDependencies);
        boolean autoRemoveArtifacts = false;
        strategy.setAutoRemoveArtifacts(autoRemoveArtifacts);
        boolean executed = strategy.execute();
        if (!executed) {
            return null;
        }
        ArtifactModel resultModel = strategy.getResultArtifactModel();
        return resultModel;
    }

    protected InstallerStrategy createInstallerStrategy() {
        InstallerStrategyV10 strategy = new InstallerStrategyV10();
        return strategy;
    }

    public boolean isPromptUpgrade() {
        return this.promptUpgrade;
    }

    public void setPromptUpgrade(boolean promptUpgrade) {
        this.promptUpgrade = promptUpgrade;
    }

    public boolean isAutoSaveConfig() {
        return this.autoSaveConfig;
    }

    public void setAutoSaveConfig(boolean autoSaveConfig) {
        this.autoSaveConfig = autoSaveConfig;
    }

    public boolean isPromptRestart() {
        return this.promptRestart;
    }

    public void setPromptRestart(boolean promptRestart) {
        this.promptRestart = promptRestart;
    }

    protected class FireUpdateSiteChange
    implements Runnable {
        protected FireUpdateSiteChange() {
        }

        @Override
        public void run() {
            InstallerPageManager.this.fireUpdateSiteChangeEvent();
        }
    }

    protected class InstanceConfigPageContext
    extends AbstractPageContext {
        @Override
        public boolean actionBack() {
            return InstallerPageManager.this.showLocationMenuPage();
        }

        @Override
        public boolean actionNext() {
            return InstallerPageManager.this.showLocationMenuPage();
        }
    }

    protected class ArtifactsDownloadPageContext
    extends AbstractPageContext {
        @Override
        public boolean actionBack() {
            boolean refresh = false;
            return InstallerPageManager.this.showArtifactsTablePage(refresh);
        }

        @Override
        public boolean actionNext() {
            return false;
        }
    }

    protected class ArtifactsTablePageContext
    extends AbstractPageContext {
        @Override
        public boolean actionBack() {
            boolean refresh = false;
            return InstallerPageManager.this.showUpdateSitesTreePage(refresh);
        }

        @Override
        public boolean actionNext() {
            boolean sync = false;
            return InstallerPageManager.this.startDownloadArtifacts(sync);
        }
    }

    protected class UpdateSitesAddPageContext
    extends AbstractPageContext {
        @Override
        public boolean actionBack() {
            boolean refresh = false;
            return InstallerPageManager.this.showUpdateSitesTreePage(refresh);
        }

        @Override
        public boolean actionNext() {
            boolean sync = false;
            return InstallerPageManager.this.startSitesUpdate(sync);
        }
    }

    protected class UpdateSitesProxyPageContext
    extends AbstractPageContext {
        @Override
        public boolean actionBack() {
            boolean refresh = false;
            return InstallerPageManager.this.showUpdateSitesTreePage(refresh);
        }

        @Override
        public boolean actionNext() {
            boolean refresh = true;
            return InstallerPageManager.this.showUpdateSitesTreePage(refresh);
        }
    }

    protected class UpdateSitesTreePageContext
    extends AbstractPageContext {
        @Override
        public boolean actionBack() {
            return InstallerPageManager.this.showLocationMenuPage();
        }

        @Override
        public boolean actionNext() {
            boolean refresh = true;
            return InstallerPageManager.this.showArtifactsTablePage(refresh);
        }
    }

    protected class LocationMenuPageContext
    extends AbstractPageContext {
        @Override
        public boolean actionBack() {
            return this.actionCancel();
        }

        @Override
        public boolean actionNext() {
            boolean refresh = true;
            return InstallerPageManager.this.showUpdateSitesTreePage(refresh);
        }
    }

    protected class LicenseAcceptPageContext
    extends AbstractPageContext {
        @Override
        public boolean actionBack() {
            return this.actionCancel();
        }

        @Override
        public boolean actionNext() {
            return InstallerPageManager.this.showLocationMenuPage();
        }
    }

    protected abstract class AbstractPageContext
    implements InstallerPageContext {
        protected AbstractPageContext() {
        }

        @Override
        public boolean actionCancel() {
            return InstallerPageManager.this.closePageManager();
        }

        @Override
        public boolean showMainPage() {
            logger.info("TODO showMainPage: check license already accepted");
            return this.showLocationPage();
        }

        @Override
        public boolean showLicensePage() {
            return InstallerPageManager.this.showLicenseAcceptPage();
        }

        @Override
        public boolean showLocationPage() {
            return InstallerPageManager.this.showLocationMenuPage();
        }

        @Override
        public boolean showUpdatePage() {
            boolean sync = false;
            InstallerPageManager.this.showUpdateSitesTreePage();
            return InstallerPageManager.this.startSitesUpdate(sync);
        }

        @Override
        public boolean showSitesTreePage() {
            boolean refresh = true;
            return InstallerPageManager.this.showUpdateSitesTreePage(refresh);
        }

        @Override
        public boolean showSitesTreePage(boolean refresh) {
            return InstallerPageManager.this.showUpdateSitesTreePage(refresh);
        }

        @Override
        public boolean showSitesProxyPage() {
            return InstallerPageManager.this.showSitesProxyPage();
        }

        @Override
        public boolean showSitesAddPage() {
            return InstallerPageManager.this.showSitesAddPage();
        }

        @Override
        public boolean showConfigPage() {
            return InstallerPageManager.this.showLocationConfigPage();
        }

        @Override
        public boolean showCleanupPage() {
            return InstallerPageManager.this.showLocationCleanupPage();
        }

        @Override
        public String getDistributionTitle() {
            return InstallerPageManager.this.getDistributionTitle();
        }

        @Override
        public String getDistributionLicenseText() throws Exception {
            return InstallerPageManager.this.getDistributionLicenseText();
        }

        @Override
        public File getInstallationDirectory() {
            return InstallerPageManager.this.getInstallationDirectory();
        }

        @Override
        public void setInstallationDirectory(File dir) throws Exception {
            InstallerPageManager.this.setInstallationDirectory(dir);
        }

        @Override
        public String getInstallationProblemText() {
            return InstallerPageManager.this.getInstallationProblemText();
        }

        @Override
        public int getInstalledArtifactCount() throws Exception {
            return InstallerPageManager.this.getInstalledArtifactCount();
        }

        @Override
        public Artifact getInstalledArtifact(String factName, String factVersion) {
            return InstallerPageManager.this.getInstalledArtifact(factName, factVersion);
        }

        @Override
        public void verifyInstalledArtifact(Artifact artifact) throws Exception {
            InstallerPageManager.this.verifyInstalledArtifact(artifact);
        }

        @Override
        public Artifact[] enumerateUnusedArtifacts() throws Exception {
            return InstallerPageManager.this.enumerateUnusedArtifacts();
        }

        @Override
        public Artifact[] cleanupUnusedArtifacts() throws Exception {
            return InstallerPageManager.this.cleanupUnusedArtifacts();
        }

        @Override
        public void refreshUpdateSites(boolean sync) throws Exception {
            InstallerPageManager.this.refreshUpdateSites(sync);
        }

        @Override
        public boolean isRefreshUpdateSitesRunning() {
            return InstallerPageManager.this.isRefreshUpdateSitesRunning();
        }

        @Override
        public TreeModel getSiteTreeModel() {
            return InstallerPageManager.this.getSiteTreeModel();
        }

        @Override
        public int getUpdateSiteState(InfectionSite site) {
            return InstallerPageManager.this.getUpdateSiteState(site);
        }

        @Override
        public boolean addUpdateSite(InfectionSite site) throws Exception {
            return InstallerPageManager.this.addUpdateSite(site);
        }

        @Override
        public boolean removeUpdateSite(InfectionSite site) throws Exception {
            return InstallerPageManager.this.removeUpdateSite(site);
        }

        @Override
        public void resetDefaultUpdateSites() throws Exception {
            InstallerPageManager.this.resetDefaultUpdateSites();
        }

        @Override
        public void addUpdateSiteChangeListener(ChangeListener listener) {
            InstallerPageManager.this.addUpdateSiteChangeListener(listener);
        }

        @Override
        public void removeUpdateSiteChangeListener(ChangeListener listener) {
            InstallerPageManager.this.removeUpdateSiteChangeListener(listener);
        }

        @Override
        public InfectionSite[] getSelectedUpdateSites() {
            return InstallerPageManager.this.getSelectedUpdateSites();
        }

        @Override
        public InfectionSite[] getSelectedUpdateSitesRecursive() {
            return InstallerPageManager.this.getSelectedUpdateSitesRecursive();
        }

        @Override
        public boolean showInstanceConfigPage(boolean refresh) {
            return InstallerPageManager.this.showInstanceConfigPage(refresh);
        }

        @Override
        public boolean showArtifactsConfigPage() {
            return InstallerPageManager.this.showArtifactsConfigPage();
        }

        @Override
        public boolean showArtifactsConfigPage(boolean refresh) {
            return InstallerPageManager.this.showArtifactsConfigPage(refresh);
        }

        @Override
        public String getDistributionArtifactName() throws Exception {
            return InstallerPageManager.this.getDistributionArtifactName();
        }

        @Override
        public ArtifactDependency[] getDistributionArtifactDependencies(String distArtifactName) throws Exception {
            return InstallerPageManager.this.getDistributionArtifactDependencies(distArtifactName);
        }

        @Override
        public void enumerateAvailableArtifacts(InfectionIndex index, ArtifactModel dstArtifactModel) {
            InstallerPageManager.this.enumerateAvailableArtifacts(index, dstArtifactModel);
        }

        @Override
        public ArtifactModel computeUpgradeArtifacts(ArtifactModel availableArtifactModel) throws Exception {
            return InstallerPageManager.this.computeUpgradeArtifacts(availableArtifactModel);
        }

        @Override
        public ArtifactModel createInstallerModel() {
            return InstallerPageManager.this.createInstallerModel();
        }
    }
}

