/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.install;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.ArtifactDependency;
import com.spacekiller.infection.install.ArtifactKey;
import com.spacekiller.infection.install.ArtifactModel;
import com.spacekiller.infection.install.InstallerStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Logger;

public abstract class InstallerStrategyBase
implements InstallerStrategy {
    public static final int DEFAULT_MAX_ITERATIONS = 10000;
    public static final long DEFAULT_TIMEOUT_MILLIS = 30000L;
    private int strategy = 0;
    private ArtifactDependency[] dependencies;
    private ArtifactModel currentArtifactModel;
    private ArtifactModel availableArtifactModel;
    private boolean includeOptionalDependencies;
    private boolean autoRemoveArtifacts;
    private int maxIterations = 10000;
    private long timeOutMillis = 30000L;
    private ArtifactModel resultArtifactModel;
    protected volatile boolean cancel;

    protected InstallerStrategyBase() {
    }

    @Override
    public int getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(int strategy) {
        this.strategy = strategy;
    }

    @Override
    public ArtifactDependency[] getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setDependencies(ArtifactDependency[] dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public ArtifactModel getCurrentArtifactModel() {
        return this.currentArtifactModel;
    }

    @Override
    public void setCurrentArtifactModel(ArtifactModel currentArtifactModel) {
        this.currentArtifactModel = currentArtifactModel;
    }

    @Override
    public ArtifactModel getAvailableArtifactModel() {
        return this.availableArtifactModel;
    }

    @Override
    public void setAvailableArtifactModel(ArtifactModel availableArtifactModel) {
        this.availableArtifactModel = availableArtifactModel;
    }

    @Override
    public boolean isIncludeOptionalDependencies() {
        return this.includeOptionalDependencies;
    }

    @Override
    public void setIncludeOptionalDependencies(boolean includeOptionalDependencies) {
        this.includeOptionalDependencies = includeOptionalDependencies;
    }

    @Override
    public boolean isAutoRemoveArtifacts() {
        return this.autoRemoveArtifacts;
    }

    @Override
    public void setAutoRemoveArtifacts(boolean autoRemoveArtifacts) {
        this.autoRemoveArtifacts = autoRemoveArtifacts;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public long getTimeOutMillis() {
        return this.timeOutMillis;
    }

    public void setTimeOutMillis(long timeOutMillis) {
        this.timeOutMillis = timeOutMillis;
    }

    protected ArtifactModel createInstallerModel() {
        return new ArtifactModel();
    }

    protected ArtifactModel mergeInstallerModels(ArtifactModel modelA, ArtifactModel modelB) {
        ArtifactModel mergedModel = this.createInstallerModel();
        mergedModel.addAllArtifacts(modelA);
        mergedModel.addAllArtifacts(modelB);
        return mergedModel;
    }

    protected Artifact getArtifactWithHighestVersion(Artifact[] artifacts) {
        Artifact bestArtifact = null;
        String bestVersion = null;
        int num = artifacts == null ? 0 : artifacts.length;
        for (int i = 0; i < num; ++i) {
            Artifact artifact = artifacts[i];
            if (artifact == null) continue;
            String version = artifact.getVersion();
            if (bestVersion != null && (version == null || bestVersion.compareTo(version) >= 0)) continue;
            bestArtifact = artifact;
            bestVersion = version;
        }
        return bestArtifact;
    }

    protected Artifact getArtifactWithLowestVersion(Artifact[] artifacts) {
        Artifact bestArtifact = null;
        String bestVersion = null;
        int num = artifacts == null ? 0 : artifacts.length;
        for (int i = 0; i < num; ++i) {
            Artifact artifact = artifacts[i];
            if (artifact == null) continue;
            String version = artifact.getVersion();
            if (bestVersion != null && (version == null || bestVersion.compareTo(version) <= 0)) continue;
            bestArtifact = artifact;
            bestVersion = version;
        }
        return bestArtifact;
    }

    @Override
    public Artifact computeBestArtifact(ArtifactKey artifactKey, Artifact[] artifacts, ArtifactDependency[] dependencyArray) {
        boolean currentArtifactsPreferred = true;
        int strategy = this.getStrategy();
        switch (strategy) {
            case 0: {
                currentArtifactsPreferred = true;
                break;
            }
            case 1: {
                currentArtifactsPreferred = false;
                break;
            }
            case -1: {
                currentArtifactsPreferred = false;
            }
        }
        return this.computeBestArtifact(artifactKey, artifacts, dependencyArray, currentArtifactsPreferred);
    }

    protected Artifact computeBestArtifact(ArtifactKey artifactKey, Artifact[] artifacts, ArtifactDependency[] dependencyArray, boolean currentArtifactsPreferred) {
        Artifact currentArtifact;
        Artifact[] currentArtifacts;
        Artifact bestArtifact = null;
        if (currentArtifactsPreferred && this.currentArtifactModel != null && (currentArtifacts = this.computeIntersectedArtifacts(this.currentArtifactModel, artifactKey, artifacts)) != null && (currentArtifact = this.computeBestArtifactVersion(artifactKey, currentArtifacts, dependencyArray)) != null) {
            bestArtifact = currentArtifact;
        }
        if (bestArtifact == null) {
            bestArtifact = this.computeBestArtifactVersion(artifactKey, artifacts, dependencyArray);
        }
        return bestArtifact;
    }

    protected Artifact computeBestArtifactVersion(ArtifactKey artifactKey, Artifact[] artifacts, ArtifactDependency[] dependencyArray) {
        int strategy = this.getStrategy();
        switch (strategy) {
            case -1: {
                return this.getArtifactWithLowestVersion(artifacts);
            }
        }
        return this.getArtifactWithHighestVersion(artifacts);
    }

    protected Artifact[] computeIntersectedArtifacts(ArtifactModel model, ArtifactKey artifactKey, Artifact[] artifacts) {
        LinkedList<Artifact> list = null;
        for (Artifact artifact : artifacts) {
            int numFound;
            Artifact[] foundArray;
            String version = artifact.getVersion();
            if (version == null || (foundArray = model.findArtifactsForVersion(artifactKey, version)) == null || (numFound = foundArray.length) < 1) continue;
            if (list == null) {
                list = new LinkedList<Artifact>();
            }
            for (int k = 0; k < numFound; ++k) {
                list.add(foundArray[k]);
            }
        }
        if (list == null) {
            return null;
        }
        return list.toArray(new Artifact[list.size()]);
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    @Override
    public ArtifactModel getResultArtifactModel() {
        return this.resultArtifactModel;
    }

    protected void setResultArtifactModel(ArtifactModel resultArtifactModel) {
        this.resultArtifactModel = resultArtifactModel;
    }

    protected ArtifactDependency[] sortDependencyArrayByWeight(ArtifactDependency[] arr) {
        int i;
        int num = arr.length;
        Object[] dep = new DependencyEntry[num];
        for (i = 0; i < num; ++i) {
            DependencyEntry de = new DependencyEntry();
            de.index = i;
            de.dependency = arr[i];
            dep[i] = de;
        }
        Arrays.sort(dep, 0, num);
        for (i = 0; i < num; ++i) {
            arr[i] = ((DependencyEntry)dep[i]).dependency;
        }
        return arr;
    }

    protected Artifact[] sortArtifactsForStrategy(ArtifactDependency dependency, ArtifactKey artifactKey, Artifact[] artifacts) {
        if (artifacts == null) {
            return artifacts;
        }
        int artifactCount = artifacts.length;
        if (artifactCount < 2) {
            return artifacts;
        }
        int strategy = this.getStrategy();
        switch (strategy) {
            case 1: {
                return this.sortArtifactsForUpgrade(dependency, artifactKey, artifacts);
            }
            case -1: {
                return this.sortArtifactsForDowngrade(dependency, artifactKey, artifacts);
            }
        }
        boolean preferUpgradeForDowngrade = true;
        return this.sortArtifactsForResolve(dependency, artifactKey, artifacts, preferUpgradeForDowngrade);
    }

    protected Artifact[] sortArtifactsForUpgrade(ArtifactDependency dependency, ArtifactKey artifactKey, Artifact[] artifacts) {
        ArtifactModel sortModel = new ArtifactModel();
        sortModel.addAllArtifacts(artifacts);
        boolean ascendingVersion = false;
        sortModel.sortArtifactsByVersion(ascendingVersion);
        return sortModel.getArtifacts();
    }

    protected Artifact[] sortArtifactsForDowngrade(ArtifactDependency dependency, ArtifactKey artifactKey, Artifact[] artifacts) {
        ArtifactModel sortModel = new ArtifactModel();
        sortModel.addAllArtifacts(artifacts);
        boolean ascendingVersion = true;
        sortModel.sortArtifactsByVersion(ascendingVersion);
        return sortModel.getArtifacts();
    }

    protected Artifact[] sortArtifactsForResolve(ArtifactDependency dependency, ArtifactKey artifactKey, Artifact[] artifacts, boolean preferUpgradeForDowngrade) {
        boolean added;
        Artifact artifact;
        ArtifactModel sortModel = new ArtifactModel();
        sortModel.addAllArtifacts(artifacts);
        boolean ascendingVersion = !preferUpgradeForDowngrade;
        sortModel.sortArtifactsByVersion(ascendingVersion);
        Artifact[] sortedArtifacts = sortModel.getArtifacts();
        int numArtifacts = sortedArtifacts.length;
        Artifact[] currentArtifacts = this.getCurrentArtifactModel().findArtifactsForKey(artifactKey);
        ArtifactModel currentModel = null;
        if (currentArtifacts != null && currentArtifacts.length > 0) {
            currentModel = new ArtifactModel();
            currentModel.addAllArtifacts(currentArtifacts);
        }
        LinkedList<Artifact> preCurrentList = null;
        LinkedList<Artifact> foundCurrentList = null;
        LinkedList<Artifact> postCurrentList = null;
        ArrayList<Artifact> dstTempList = new ArrayList<Artifact>();
        for (int i = 0; i < numArtifacts; ++i) {
            artifact = sortedArtifacts[i];
            if (artifact == null) continue;
            String version = artifact.getVersion();
            if (currentModel != null) {
                currentModel.findArtifactsForVersion(artifactKey, version, dstTempList);
                if (!dstTempList.isEmpty()) {
                    dstTempList.clear();
                    if (foundCurrentList == null) {
                        foundCurrentList = new LinkedList<Artifact>();
                    }
                    foundCurrentList.add(artifact);
                    continue;
                }
            }
            if (foundCurrentList == null || foundCurrentList.isEmpty()) {
                if (preCurrentList == null) {
                    preCurrentList = new LinkedList<Artifact>();
                }
                preCurrentList.add(artifact);
                continue;
            }
            if (postCurrentList == null) {
                postCurrentList = new LinkedList<Artifact>();
            }
            postCurrentList.add(artifact);
        }
        if (foundCurrentList != null) {
            dstTempList.addAll(foundCurrentList);
        }
        boolean preSkipFirst = ascendingVersion;
        do {
            added = false;
            if (preCurrentList != null && !preCurrentList.isEmpty()) {
                if (preSkipFirst) {
                    preSkipFirst = false;
                    added = true;
                } else {
                    artifact = (Artifact)preCurrentList.removeLast();
                    dstTempList.add(artifact);
                    added = true;
                }
            }
            if (postCurrentList == null || postCurrentList.isEmpty()) continue;
            artifact = (Artifact)postCurrentList.removeFirst();
            dstTempList.add(artifact);
            added = true;
        } while (added);
        return dstTempList.toArray(new Artifact[dstTempList.size()]);
    }

    protected Artifact[] debugAmbiguousArtifacts(Artifact[] artifacts, Logger logger) {
        LinkedList<Artifact> artifactList = new LinkedList<Artifact>();
        HashMap<ArtifactKey, Artifact> artifactMap = new HashMap<ArtifactKey, Artifact>();
        for (Artifact artifact : artifacts) {
            ArtifactKey artifactKey;
            if (artifact == null || (artifactKey = this.getCurrentArtifactModel().artifactKey(artifact)) == null) continue;
            Artifact ambArtifact = (Artifact)artifactMap.get(artifactKey);
            if (ambArtifact != null) {
                int comp;
                String artVersion = artifact.getVersion();
                String ambVersion = ambArtifact.getVersion();
                if (artVersion == null) {
                    artVersion = "";
                }
                if ((comp = artVersion.compareTo(ambVersion)) == 0) {
                    logger.warning("Duplicate artifact: " + artifact + " == " + ambArtifact);
                } else {
                    logger.warning("Ambiguous artifact: " + artifact + " <> " + ambArtifact);
                }
                if (comp < 0) continue;
                artifactList.remove(ambArtifact);
            }
            artifactList.add(artifact);
            artifactMap.put(artifactKey, artifact);
        }
        return artifactList.toArray(new Artifact[artifactList.size()]);
    }

    protected static class DependencyEntry
    implements Comparable {
        protected int index;
        protected ArtifactDependency dependency;

        protected DependencyEntry() {
        }

        public int compareTo(Object o) {
            int x;
            DependencyEntry de = (DependencyEntry)o;
            int r = Double.compare(de.dependency.getWeight(), this.dependency.getWeight());
            if (r == 0 && this.index != (x = de.index)) {
                return this.index < x ? -1 : 1;
            }
            return r;
        }
    }
}

