/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.install;

import com.spacekiller.infection.install.InstallerTask;
import com.spacekiller.infection.install.InstallerTaskListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallerTaskManager
implements Runnable {
    private static final Logger logger = Logger.getLogger(InstallerTaskManager.class.getName());
    private final Object lock = new Object();
    private List workers = new ArrayList();
    private int activeWorkers = 0;
    private List tasks = new ArrayList();
    private List todo = new LinkedList();
    private List errors = new ArrayList();
    private InstallerTaskListener listener;

    public InstallerTaskManager(int numThreads) {
        if (numThreads < 1) {
            numThreads = 1;
        }
        for (int c = 0; c < numThreads; ++c) {
            TaskWorker worker = new TaskWorker();
            this.workers.add(worker);
        }
    }

    protected int getActiveWorkers() {
        return this.activeWorkers;
    }

    public synchronized void addTask(InstallerTask job) {
        if (job == null) {
            throw new NullPointerException("job is null");
        }
        this.tasks.add(job);
        this.todo.add(job);
    }

    public synchronized int getTaskCount() {
        return this.tasks.size();
    }

    public synchronized InstallerTask getTaskAt(int index) {
        return (InstallerTask)this.tasks.get(index);
    }

    protected synchronized InstallerTask nextTask() {
        if (this.todo.isEmpty()) {
            return null;
        }
        return (InstallerTask)this.todo.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void workerCompleted(TaskWorker w) {
        Object object = this.lock;
        synchronized (object) {
            --this.activeWorkers;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int num = this.workers.size();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TaskManager: worker threads: " + num);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int c = 0; c < num; ++c) {
            TaskWorker worker = (TaskWorker)this.workers.get(c);
            Object object = this.lock;
            synchronized (object) {
                ++this.activeWorkers;
            }
            Thread thread = new Thread(worker);
            threads.add(thread);
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TaskManager: completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        InstallerTaskManager installerTaskManager = this;
        synchronized (installerTaskManager) {
            int num = this.getTaskCount();
            for (int i = num - 1; i >= 0; --i) {
                InstallerTask task = this.getTaskAt(i);
                task.cancel();
            }
        }
    }

    protected void addError(Exception e) {
        this.errors.add(e);
    }

    protected InstallerTaskListener getListener() {
        return this.listener;
    }

    public void setListener(InstallerTaskListener listener) {
        this.listener = listener;
    }

    public class TaskWorker
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized void run() {
            try {
                InstallerTask job;
                while ((job = InstallerTaskManager.this.nextTask()) != null) {
                    InstallerTaskListener listener = InstallerTaskManager.this.getListener();
                    try {
                        if (listener != null) {
                            listener.taskStarted(job);
                        }
                        job.execute();
                    }
                    finally {
                        if (listener == null) continue;
                        listener.taskCompleted(job);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            InstallerTaskManager.this.workerCompleted(this);
        }
    }
}

