/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.load;

import com.spacekiller.infection.load.ArtifactClassLoader;
import com.spacekiller.infection.load.ArtifactLoader;
import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArtifactClassLoaderImpl
extends ArtifactClassLoader {
    private static final Logger logger = Logger.getLogger(ArtifactClassLoaderImpl.class.getName());
    private final Object id;
    private final ArtifactLoader delegate;

    public ArtifactClassLoaderImpl(Object id, ArtifactLoader delegate, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.id = id;
        this.delegate = delegate;
    }

    @Override
    public final Object getId() {
        return this.id;
    }

    @Override
    public final ArtifactLoader getDelegate() {
        return this.delegate;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "loadClass", "name=" + name + ", artifact=" + this.id);
        }
        Class<?> clazz = super.loadClass(name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "loadClass", "name=" + name + ", artifact=" + this.id + ", class=" + clazz);
        }
        return clazz;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "loadClass", "name=" + name + ", resolve=" + resolve + ", artifact=" + this.id);
        }
        Class<?> clazz = super.loadClass(name, resolve);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "loadClass", "name=" + name + ", artifact=" + this.id + ", class=" + clazz);
        }
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findClass", "name=" + name + ", artifact=" + this.id);
        }
        Class clazz = MEDIATOR.findClass(this, this.delegate, name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findClass", "name=" + name + ", artifact=" + this.id + ", class=" + clazz);
        }
        return clazz;
    }

    @Override
    protected String findLibrary(String name) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findLibrary", "name=" + name + ", artifact=" + this.id);
        }
        String path = this.delegate.findLibrary(name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findLibrary", "name=" + name + ", artifact=" + this.id + ", path=" + path);
        }
        return path;
    }

    @Override
    public URL findResource(String name) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findResource", "name=" + name + ", artifact=" + this.id);
        }
        URL url = this.delegate.findResource(name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findResource", "name=" + name + ", artifact=" + this.id + ", url=" + url);
        }
        return url;
    }

    public Enumeration findResources(String name) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findResources", "name=" + name + ", artifact=" + this.id);
        }
        Enumeration en = this.delegate.findResources(name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findResources", "name=" + name + ", artifact=" + this.id + ", en=" + en);
        }
        return en;
    }

    @Override
    protected Class findLocalClass(String name) throws ClassNotFoundException {
        Class<?> rc;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findLocalClass", "name=" + name + ", artifact=" + this.id);
        }
        if ((rc = super.findLoadedClass(name)) != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "findLocalClass", "name=" + name + ", artifact=" + this.id + ", class=" + rc);
            }
            return rc;
        }
        rc = super.findClass(name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findLocalClass", "name=" + name + ", artifact=" + this.id + ", class=" + rc);
        }
        return rc;
    }

    @Override
    protected URL findLocalResource(String name) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findLocalResource", "name=" + name + ", artifact=" + this.id);
        }
        URL url = super.findResource(name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findLocalResource", "name=" + name + ", artifact=" + this.id + ", url=" + url);
        }
        return url;
    }

    @Override
    protected Enumeration findLocalResources(String name) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findLocalResources", "name=" + name + ", artifact=" + this.id);
        }
        Enumeration<URL> en = super.findResources(name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findLocalResources", "name=" + name + ", artifact=" + this.id + ", en=" + en);
        }
        return en;
    }
}

