/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.load;

import com.spacekiller.infection.load.ArtifactClassLoader;
import com.spacekiller.infection.load.ArtifactClassLoaderOwner;
import com.spacekiller.infection.load.ArtifactLoader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class ArtifactClassLoaderMediator {
    private static final Object MEDIATE_LOCK = new MediateLock();
    private static final Logger logger = Logger.getLogger(ArtifactClassLoaderMediator.class.getName());

    protected ArtifactClassLoaderMediator() {
    }

    protected ArtifactClassLoaderOwner getOwner(Thread thread, ArtifactClassLoader loader) {
        return new ArtifactClassLoaderOwner(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(ArtifactClassLoader invoker, ArtifactLoader delegate, String name) throws ClassNotFoundException {
        ClassLoader loader = delegate.findClass(name);
        if (loader == null) {
            throw new ClassNotFoundException(name);
        }
        if (loader == invoker) {
            return invoker.findLocalClass(name);
        }
        Thread thread = Thread.currentThread();
        if (!(loader instanceof ArtifactClassLoader)) {
            return loader.loadClass(name);
        }
        ArtifactClassLoader acl = (ArtifactClassLoader)loader;
        ArtifactClassLoaderOwner aclOwner = null;
        ArtifactClassLoaderOwner owner = null;
        boolean unlock = false;
        Object object = MEDIATE_LOCK;
        synchronized (object) {
            owner = invoker.OWNER;
            if (owner == null) {
                invoker.OWNER = owner = this.getOwner(thread, invoker);
                unlock = true;
            } else if (owner.getThread() != thread) {
                logger.info("" + thread + " >> FIXME: Thread not owner of ClassLoader lock: " + owner.getThread() + " != " + thread);
                ArtifactClassLoaderOwner oldOwner = owner;
                invoker.OWNER = owner = this.getOwner(thread, invoker);
                unlock = true;
                oldOwner.finishWork();
            }
            aclOwner = acl.OWNER;
            if (aclOwner == null) {
                // empty if block
            }
        }
        try {
            object = acl.findLocalClass(name);
            return object;
        }
        finally {
            if (unlock) {
                Object object2 = MEDIATE_LOCK;
                synchronized (object2) {
                    invoker.OWNER = null;
                    owner.finishWork();
                }
            }
        }
    }

    void printThreadTrace(Thread thread, PrintStream out) {
        out.println("Trace: " + thread);
        try {
            Method meth = Thread.class.getMethod("getStackTrace", new Class[0]);
            StackTraceElement[] trace = (StackTraceElement[])meth.invoke((Object)thread, new Object[0]);
            if (trace != null) {
                for (int i = 0; i < trace.length; ++i) {
                    out.println("  " + trace[i]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class MediateLock {
        protected MediateLock() {
        }
    }
}

