/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import com.spacekiller.infection.log.LogFormatter;
import com.spacekiller.infection.log.LogTask;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class InfectionLogFormatter
implements LogFormatter {
    private static final char SPACE = ' ';
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String separator = "\n";
    private int seqColumnLength = 5;
    private int threadColumnLength = 5;
    private int loggerColumnLength = 25;
    private int levelColumnLength = 7;

    protected void appendMessage(LogTask task, LogRecord rec) {
        String levelName;
        int n;
        String msg = rec.getMessage();
        if (msg == null) {
            msg = "null";
        }
        Object[] params = rec.getParameters();
        Level level = rec.getLevel();
        if (level == Level.FINER) {
            if (msg.startsWith("ENTRY")) {
                task.append("FINER > ");
                task.append(this.methodString(rec));
                if (params == null) {
                    task.append("()");
                } else {
                    task.append('(');
                    int n2 = params.length;
                    for (int i = 0; i < n2; ++i) {
                        if (i > 0) {
                            task.append(", ");
                        }
                        task.append(this.paramString(params[i]));
                    }
                    task.append(')');
                }
                return;
            }
            if (msg.startsWith("RETURN")) {
                task.append("FINER < ");
                task.append(this.methodString(rec));
                if (params == null || params.length < 1) {
                    task.append(" RETURN");
                } else {
                    task.append(" RETURN ");
                    task.append(this.paramString(params[0]));
                }
                return;
            }
            if (msg.equals("THROW")) {
                task.append("FINER ! ");
                task.append(this.methodString(rec));
                task.append(" THROW");
                return;
            }
        }
        if ((n = (levelName = level.getName()).length()) >= this.levelColumnLength) {
            task.append(levelName, 0, this.levelColumnLength);
            task.append(' ');
        } else {
            task.append(levelName);
            task.appendBlank(this.levelColumnLength - n + 1);
        }
        task.append(msg, params);
    }

    protected String paramString(Object param) {
        return param == null ? "null" : param.toString();
    }

    protected String methodString(LogRecord rec) {
        String s = rec.getSourceClassName();
        if (s == null) {
            s = "";
        } else {
            int x = s.lastIndexOf(46);
            if (x >= 0) {
                s = s.substring(x + 1);
            }
        }
        String method = rec.getSourceMethodName();
        if (method != null) {
            s = s + "." + method;
        }
        return s;
    }

    protected void appendLogger(LogTask task, String logger, int len) {
        int from = 0;
        if (logger == null) {
            logger = "null";
        } else {
            int x = logger.lastIndexOf(46);
            if (x >= 0) {
                from = x + 1;
            }
        }
        int end = logger.length();
        int n = end - from;
        if (n >= len) {
            end = from + len;
            task.append(logger, from, end);
        } else {
            task.append(logger, from, end);
            task.appendBlank(len - n);
        }
    }

    private static String lengthString(String s, int len) {
        int ori;
        if (s == null) {
            s = "";
        }
        if ((ori = s.length()) > len) {
            return s.substring(0, len);
        }
        if (ori < len) {
            int n = len - ori;
            char[] ch = new char[n];
            Arrays.fill(ch, ' ');
            return s + new String(ch);
        }
        return s;
    }

    @Override
    public String getHead(Handler h) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("-------------------------------------------------------------------------------------------------------------------------------");
        sbuf.append(this.separator);
        Date date = new Date();
        String dateStr = this.dateFormat.format(date);
        sbuf.append(InfectionLogFormatter.lengthString("Time", 13));
        sbuf.append(InfectionLogFormatter.lengthString(" Seq.", 6));
        sbuf.append(InfectionLogFormatter.lengthString("Thrd.", 6));
        sbuf.append(InfectionLogFormatter.lengthString("Logger", 26));
        sbuf.append(InfectionLogFormatter.lengthString("Level", 8));
        sbuf.append("Message");
        sbuf.append(this.separator);
        sbuf.append("+ ");
        sbuf.append(dateStr);
        sbuf.append(" ----- ----- ------------------------- ------- --------------------------------------------------------------------");
        sbuf.append(this.separator);
        return sbuf.toString();
    }

    @Override
    public String getTail(Handler h) {
        char[] sep = new char[180];
        Arrays.fill(sep, '-');
        String sepStr = new String(sep);
        return sepStr;
    }

    @Override
    public void format(LogTask task) {
        LogRecord rec = task.record;
        if (rec == null) {
            return;
        }
        long seq = rec.getSequenceNumber();
        int tid = rec.getThreadID();
        String name = rec.getLoggerName();
        Throwable error = rec.getThrown();
        task.appendTime(rec.getMillis());
        task.append(' ');
        task.appendNumber(seq, this.seqColumnLength);
        task.append(' ');
        task.appendNumber(tid, this.threadColumnLength);
        task.append(' ');
        this.appendLogger(task, name, this.loggerColumnLength);
        task.append(' ');
        this.appendMessage(task, rec);
        task.append(this.separator);
        if (error != null) {
            task.append(error, this.separator);
        }
    }
}

