/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import com.spacekiller.infection.Infection;
import com.spacekiller.infection.log.LogFormatter;
import com.spacekiller.infection.log.LogTask;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public final class Log2ConsoleHandler
extends Handler {
    private static final int INIT_TASK_LEN = 256;
    private static final int MAX_TASK_LEN = 4096;
    private final LogFormatter form;
    private final LogTask task;
    private final PrintStream out = Infection.getLog2ConsoleStream(this);

    public Log2ConsoleHandler() {
        this(true);
    }

    protected Log2ConsoleHandler(boolean register) {
        this.form = Infection.getLog2ConsoleFormatter(this);
        this.task = this.createLogTask();
        String header = this.form.getHead(this);
        if (header != null) {
            this.out.print(header);
        }
        if (register) {
            Infection.registerLogHandler(this);
        }
    }

    protected LogTask createLogTask() {
        return new LogTask(256);
    }

    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        try {
            this.task.record = record;
            this.task.size = 0;
            this.form.format(this.task);
            this.task.printTo(this.out);
            if (this.task.len > 4096) {
                this.task.init(256);
            }
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
            return;
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() throws SecurityException {
        this.flush();
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
    }
}

