/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import com.spacekiller.infection.Infection;
import com.spacekiller.infection.log.LogDecorator;
import com.spacekiller.infection.log.LogFormatter;
import com.spacekiller.infection.log.LogStream;
import com.spacekiller.infection.log.LogTask;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public final class Log2FileHandler
extends Handler {
    private static final int INIT_TASK_LEN = 256;
    private static final int MAX_TASK_LEN = 4096;
    private final LogFormatter form;
    private final Writer osw;
    private final LogTask task;

    public Log2FileHandler() {
        this(true);
    }

    protected Log2FileHandler(boolean register) {
        LogStream stream = Infection.getLog2FileStream(this);
        this.form = Infection.getLog2FileFormatter(this);
        this.task = this.createLogTask();
        this.osw = this.createWriter(stream);
        stream.setDecorator(new Decorator());
        if (register) {
            Infection.registerLogHandler(this);
        }
    }

    protected LogTask createLogTask() {
        return new LogTask(256);
    }

    protected Writer createWriter(LogStream stream) {
        return new OutputStreamWriter(stream);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            this.task.record = record;
            this.task.size = 0;
            this.form.format(this.task);
            this.task.writeTo(this.osw);
            this.osw.flush();
            if (this.task.len > 4096) {
                this.task.init(256);
            }
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    @Override
    public synchronized void flush() {
        try {
            this.osw.flush();
        }
        catch (IOException e) {
            this.reportError(null, e, 2);
        }
    }

    @Override
    public void close() throws SecurityException {
        this.flush();
    }

    protected class Decorator
    implements LogDecorator {
        protected Decorator() {
        }

        @Override
        public void writeHeader(OutputStream out) throws IOException {
            String header = Log2FileHandler.this.form.getHead(Log2FileHandler.this);
            if (header != null) {
                out.write(header.getBytes());
                out.flush();
            }
        }

        @Override
        public void writeFooter(OutputStream out) throws IOException {
            String footer = Log2FileHandler.this.form.getTail(Log2FileHandler.this);
            if (footer != null) {
                out.write(footer.getBytes());
                out.flush();
            }
        }
    }
}

