/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogAsyncHandler
extends Handler {
    public static final int DEFAULT_QUEUE_SIZE = 1024;
    private final Handler handler;
    private Queue queue;
    private Queue queue2;
    private Object qlock;
    private Object qwait;
    private Publisher publisher;
    private long statQueueWait = 0L;
    private long statMaxQueueWait = 0L;
    private boolean doInferCaller = true;

    public LogAsyncHandler(Handler handler) {
        this(handler, 1024);
    }

    public LogAsyncHandler(Handler handler, int maxQueueSize) {
        this.handler = handler;
        this.qlock = new Object();
        this.qwait = new Object();
        this.queue = new Queue(maxQueueSize);
        this.queue2 = new Queue(maxQueueSize);
        this.initInfectionLogHandler();
    }

    protected void initInfectionLogHandler() {
        this.publisher = new Publisher();
        Thread thread = new Thread(this.publisher);
        thread.start();
    }

    protected final Handler getHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (!this.handler.isLoggable(record)) {
            return;
        }
        if (this.doInferCaller) {
            record.getSourceMethodName();
        }
        while (true) {
            Object object = this.qlock;
            synchronized (object) {
                Queue q = this.queue;
                int qsize = q.size();
                if (q.add(record)) {
                    if (qsize < 1) {
                        Publisher publisher = this.publisher;
                        synchronized (publisher) {
                            this.publisher.notify();
                        }
                    }
                    return;
                }
            }
            ++this.statQueueWait;
            object = this.publisher;
            synchronized (object) {
                this.publisher.notify();
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        while (true) {
            Object object = this.qlock;
            synchronized (object) {
                if (this.queue.isEmpty() && this.queue2.isEmpty()) {
                    break;
                }
            }
            try {
                object = this.qwait;
                synchronized (object) {
                    Publisher publisher = this.publisher;
                    synchronized (publisher) {
                        this.publisher.notify();
                    }
                    this.qwait.wait(1000L);
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        this.handler.flush();
    }

    @Override
    public void close() throws SecurityException {
        this.flush();
        this.handler.close();
    }

    @Override
    public String getEncoding() {
        return this.handler.getEncoding();
    }

    @Override
    public ErrorManager getErrorManager() {
        return this.handler.getErrorManager();
    }

    @Override
    public Filter getFilter() {
        return this.handler.getFilter();
    }

    @Override
    public Formatter getFormatter() {
        return this.handler.getFormatter();
    }

    @Override
    public synchronized Level getLevel() {
        return this.handler.getLevel();
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.handler.isLoggable(record);
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
        this.handler.setEncoding(encoding);
    }

    @Override
    public void setErrorManager(ErrorManager em) {
        super.setErrorManager(em);
        this.handler.setErrorManager(em);
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        super.setFilter(newFilter);
        this.handler.setFilter(newFilter);
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
        super.setFormatter(newFormatter);
        this.handler.setFormatter(newFormatter);
        this.doInferCaller = true;
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        super.setLevel(newLevel);
        this.handler.setLevel(newLevel);
    }

    public long getStatMaxQueueWait() {
        return this.statMaxQueueWait;
    }

    public long getStatQueueWait() {
        return this.statQueueWait;
    }

    public String toString() {
        return super.toString() + "[" + this.handler + "]";
    }

    protected class Publisher
    implements Runnable {
        private boolean active = false;

        protected Publisher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: {
                try {
                    this.active = true;
                    while (this.active) {
                        Object object;
                        while (true) {
                            Queue swap = LogAsyncHandler.this.queue2;
                            object = LogAsyncHandler.this.qlock;
                            synchronized (object) {
                                LogAsyncHandler.this.queue2 = LogAsyncHandler.this.queue;
                                LogAsyncHandler.this.queue = swap;
                            }
                            object = LogAsyncHandler.this.qwait;
                            synchronized (object) {
                                LogAsyncHandler.this.qwait.notifyAll();
                            }
                            int n = LogAsyncHandler.this.queue2.size();
                            if (n < 1) break;
                            for (int i = 0; i < n; ++i) {
                                LogAsyncHandler.this.handler.publish(LogAsyncHandler.this.queue2.get(i));
                            }
                            LogAsyncHandler.this.handler.flush();
                            LogAsyncHandler.this.queue2.clear();
                        }
                        try {
                            object = LogAsyncHandler.this.qwait;
                            synchronized (object) {
                                LogAsyncHandler.this.qwait.notifyAll();
                            }
                            object = this;
                            synchronized (object) {
                                if (LogAsyncHandler.this.queue.isEmpty()) {
                                    this.wait();
                                }
                            }
                        }
                        catch (InterruptedException e) {
                        }
                    }
                }
                catch (Exception e) {
                    ErrorManager errMan = LogAsyncHandler.this.getErrorManager();
                    if (errMan == null) break block20;
                    errMan.error(e.getMessage(), e, 0);
                }
            }
        }

        protected void stop() {
            this.active = false;
        }
    }

    protected static class Queue {
        private LogRecord[] arr;
        private int len;
        private int size;

        public Queue(int len) {
            this.len = len;
            this.size = 0;
            this.arr = new LogRecord[len];
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public void clear() {
            if (this.size < 1) {
                return;
            }
            for (int i = 0; i < this.size; ++i) {
                this.arr[i] = null;
            }
            this.size = 0;
        }

        public LogRecord get(int i) {
            return this.arr[i];
        }

        public boolean add(LogRecord rec) {
            if (this.size < this.len) {
                this.arr[this.size++] = rec;
                return true;
            }
            return false;
        }
    }
}

