/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import java.util.Properties;
import java.util.logging.LogManager;

public class LogFileOptions
implements Cloneable {
    public static final int MIN_LIMIT = 0x100000;
    public static final String KEY_DIRECTORY = "directory";
    public static final String KEY_NAME_PREFIX = "namePrefix";
    public static final String KEY_NAME_SUFFIX = "nameSuffix";
    public static final String KEY_LIMIT = "limit";
    public static final String KEY_COUNT = "count";
    public static final String KEY_APPEND = "append";
    private static final String[] KEY_SUFFIXES = new String[]{"directory", "namePrefix", "nameSuffix", "limit", "count", "append"};
    public static final String DEFAULT_LOGFILE_PREFIX = "runtime";
    public static final String DEFAULT_LOGFILE_SUFFIX = ".log";
    public static final int DEFAULT_LOGFILE_LIMIT = 0xA00000;
    public static final int DEFAULT_LOGFILE_COUNT = 10;
    public static final boolean DEFAULT_LOGFILE_APPEND = false;
    public static final boolean DEFAULT_LOGFILE_ASYNC = true;
    public static final String DEFAULT_TRACEFILE_PREFIX = "trace";
    public static final String DEFAULT_TRACEFILE_SUFFIX = ".trc";
    public static final int DEFAULT_TRACEFILE_LIMIT = 0x6400000;
    public static final int DEFAULT_TRACEFILE_COUNT = 5;
    public static final boolean DEFAULT_TRACEFILE_APPEND = false;
    public static final boolean DEFAULT_TRACEFILE_ASYNC = true;
    private String directory;
    private String namePrefix;
    private String nameSuffix;
    private int limit;
    private int count;
    private boolean append;
    private boolean async;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public LogFileOptions cloneLogFileOptions() throws CloneNotSupportedException {
        return (LogFileOptions)super.clone();
    }

    public void setProperties(LogManager manager, String keyPrefix) {
        Properties props = new Properties();
        for (int i = 0; i < KEY_SUFFIXES.length; ++i) {
            String key = keyPrefix + KEY_SUFFIXES[i];
            String value = manager.getProperty(key);
            if (value == null) continue;
            props.setProperty(key, value);
        }
        this.setProperties(props, keyPrefix);
    }

    public void setProperties(Properties props, String keyPrefix) {
        String value = props.getProperty(keyPrefix + KEY_DIRECTORY);
        if (value != null) {
            this.setDirectory(value.trim());
        }
        if ((value = props.getProperty(keyPrefix + KEY_NAME_PREFIX)) != null) {
            this.setNamePrefix(value.trim());
        }
        if ((value = props.getProperty(keyPrefix + KEY_NAME_SUFFIX)) != null) {
            this.setNameSuffix(value.trim());
        }
        if ((value = props.getProperty(keyPrefix + KEY_LIMIT)) != null) {
            try {
                long limit = Long.parseLong(value.trim());
                if (limit > Integer.MAX_VALUE) {
                    limit = Integer.MAX_VALUE;
                }
                if (limit < 0x100000L) {
                    limit = 0x100000L;
                }
                this.setLimit((int)limit);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((value = props.getProperty(keyPrefix + KEY_COUNT)) != null) {
            try {
                long count = Long.parseLong(value.trim());
                if (count > Integer.MAX_VALUE) {
                    count = Integer.MAX_VALUE;
                }
                if (count < 1L) {
                    count = 1L;
                }
                this.setCount((int)count);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((value = props.getProperty(keyPrefix + KEY_APPEND)) != null) {
            this.setAppend("true".equalsIgnoreCase(value));
        }
    }

    public Properties getProperties(String keyPrefix) {
        Properties props = new Properties();
        if (this.directory != null) {
            props.setProperty(keyPrefix + KEY_DIRECTORY, this.directory);
        }
        if (this.namePrefix != null) {
            props.setProperty(keyPrefix + KEY_NAME_PREFIX, this.namePrefix);
        }
        if (this.nameSuffix != null) {
            props.setProperty(keyPrefix + KEY_NAME_SUFFIX, this.nameSuffix);
        }
        props.setProperty(keyPrefix + KEY_LIMIT, String.valueOf(this.limit));
        props.setProperty(keyPrefix + KEY_COUNT, String.valueOf(this.count));
        props.setProperty(keyPrefix + KEY_APPEND, String.valueOf(this.append));
        return props;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public static LogFileOptions createDefaultLogFileOptions() {
        LogFileOptions options = new LogFileOptions();
        options.setNamePrefix(DEFAULT_LOGFILE_PREFIX);
        options.setNameSuffix(DEFAULT_LOGFILE_SUFFIX);
        options.setLimit(0xA00000);
        options.setCount(10);
        options.setAppend(false);
        options.setAsync(true);
        return options;
    }

    public static LogFileOptions createDefaultTraceFileOptions() {
        LogFileOptions options = new LogFileOptions();
        options.setNamePrefix(DEFAULT_TRACEFILE_PREFIX);
        options.setNameSuffix(DEFAULT_TRACEFILE_SUFFIX);
        options.setLimit(0x6400000);
        options.setCount(5);
        options.setAppend(false);
        options.setAsync(true);
        return options;
    }
}

