/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.LogRecord;

public final class LogTask {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static char[] BLANK = new char[64];
    LogRecord record;
    char[] cbuf;
    int len;
    int size;
    private Date date;
    private DateFormat secFormat;
    private Second prev;

    public LogTask(int initLen) {
        long time = System.currentTimeMillis();
        long sec = time / 1000L;
        this.secFormat = new SimpleDateFormat("HH:mm:ss.");
        this.date = new Date(time);
        String secString = this.secFormat.format(this.date);
        this.prev = new Second(sec, secString);
        this.init(initLen);
    }

    public LogTask(int initLen, LogRecord record) {
        this(initLen);
        this.record = record;
    }

    public LogRecord getRecord() {
        return this.record;
    }

    public void setString(String s) {
        int n = s.length();
        if (n > this.len) {
            this.resize(Math.max(n, this.len * 2));
        }
        s.getChars(0, n, this.cbuf, 0);
        this.size = n;
    }

    public void setChars(char[] c, int o, int n) {
        if (n < 1) {
            n = 0;
        }
        if (n > this.len) {
            this.resize(Math.max(n, this.len * 2));
        }
        System.arraycopy(c, o, this.cbuf, 0, n);
        this.size = n;
    }

    public void append(char c) {
        if (this.size >= this.len) {
            this.resize(Math.max(this.size + 1, this.len * 2));
        }
        this.cbuf[this.size++] = c;
    }

    public void append(char[] c, int o, int n) {
        if (n < 1) {
            return;
        }
        int z = this.size + n;
        if (z > this.len) {
            this.resize(Math.max(z, this.len * 2));
        }
        System.arraycopy(c, o, this.cbuf, this.size, n);
        this.size = z;
    }

    public void append(String s) {
        int n = s.length();
        int z = this.size + n;
        if (z > this.len) {
            this.resize(Math.max(z, this.len * 2));
        }
        s.getChars(0, n, this.cbuf, this.size);
        this.size = z;
    }

    public void append(String s, int from, int end) {
        int n = end - from;
        if (n < 1) {
            return;
        }
        int z = this.size + n;
        if (z > this.len) {
            this.resize(Math.max(z, this.len * 2));
        }
        s.getChars(from, end, this.cbuf, this.size);
        this.size = z;
    }

    public void append(String msg, Object[] params) {
        int y;
        int x;
        if (params == null || params.length < 1) {
            this.append(msg);
            return;
        }
        int paramCount = params.length;
        int end = msg.length();
        int from = 0;
        while ((x = msg.indexOf(123, from)) >= 0 && (y = msg.indexOf(125, x + 1)) >= 0) {
            int z;
            try {
                z = Integer.parseInt(msg.substring(x + 1, y));
            }
            catch (NumberFormatException e) {
                this.append(msg, from, x + 1);
                from = x + 1;
                continue;
            }
            if (z >= 0 && z < paramCount) {
                this.append(msg, from, x);
                this.append(this.formatParameter(params[z]));
            } else {
                this.append(msg, from, y + 1);
            }
            from = y + 1;
        }
        this.append(msg, from, end);
    }

    public void append(Throwable error, String separator) {
        this.append(String.valueOf(error));
        this.append(separator);
        StackTraceElement[] trace = error.getStackTrace();
        if (trace != null) {
            for (int i = 0; i < trace.length; ++i) {
                this.append("\tat ");
                this.append(String.valueOf(trace[i]));
                this.append(separator);
            }
        }
        for (Throwable cause = error.getCause(); cause != null; cause = cause.getCause()) {
            this.append("Caused by: ");
            this.append(String.valueOf(cause));
            this.append(separator);
            StackTraceElement[] causeTrace = cause.getStackTrace();
            if (trace != null) {
                int m = causeTrace.length - 1;
                for (int n = trace.length - 1; m >= 0 && n >= 0 && causeTrace[m].equals(trace[n]); --m, --n) {
                }
                int framesInCommon = causeTrace.length - 1 - m;
                for (int i = 0; i <= m; ++i) {
                    this.append("\tat ");
                    this.append(String.valueOf(causeTrace[i]));
                    this.append(separator);
                }
                if (framesInCommon != 0) {
                    this.append("\t... " + framesInCommon + " more");
                    this.append(separator);
                }
            }
            trace = causeTrace;
        }
    }

    public static void formatException(Throwable error, String separator, StringBuffer dest) {
        dest.append(String.valueOf(error));
        dest.append(separator);
        StackTraceElement[] trace = error.getStackTrace();
        if (trace != null) {
            for (int i = 0; i < trace.length; ++i) {
                dest.append("\tat ");
                dest.append(String.valueOf(trace[i]));
                dest.append(separator);
            }
        }
        for (Throwable cause = error.getCause(); cause != null; cause = cause.getCause()) {
            dest.append("Caused by: ");
            dest.append(String.valueOf(cause));
            dest.append(separator);
            StackTraceElement[] causeTrace = cause.getStackTrace();
            if (trace != null) {
                int m = causeTrace.length - 1;
                for (int n = trace.length - 1; m >= 0 && n >= 0 && causeTrace[m].equals(trace[n]); --m, --n) {
                }
                int framesInCommon = causeTrace.length - 1 - m;
                for (int i = 0; i <= m; ++i) {
                    dest.append("\tat ");
                    dest.append(String.valueOf(causeTrace[i]));
                    dest.append(separator);
                }
                if (framesInCommon != 0) {
                    dest.append("\t... " + framesInCommon + " more");
                    dest.append(separator);
                }
            }
            trace = causeTrace;
        }
    }

    private void resize(int newLen) {
        char[] newBuf = new char[newLen];
        System.arraycopy(this.cbuf, 0, newBuf, 0, this.size);
        this.cbuf = newBuf;
        this.len = newLen;
    }

    public void ensureCapacity(int n) {
        if (n > this.len - this.size) {
            this.resize(Math.max(this.size + n, this.len * 2));
        }
    }

    void init(int initLen) {
        this.len = initLen;
        this.cbuf = new char[this.len];
        this.size = 0;
    }

    public String toString() {
        return new String(this.cbuf, 0, this.size);
    }

    public String getString() {
        return new String(this.cbuf, 0, this.size);
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.cbuf, 0, this.size);
    }

    public void printTo(PrintStream out) {
        if (this.size > 0) {
            out.print(new String(this.cbuf, 0, this.size));
        }
    }

    public String formatParameter(Object param) {
        if (param == null) {
            return "null";
        }
        try {
            return param.toString();
        }
        catch (Throwable e) {
            return param.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(param));
        }
    }

    public void appendTime(long time) {
        Second prev = this.prev;
        long sec = time / 1000L;
        if (sec == prev.sec) {
            this.append(prev.secString);
            this.appendMillis(time);
        } else {
            this.date.setTime(time);
            String secString = this.secFormat.format(this.date);
            this.prev = prev = new Second(sec, secString);
            this.append(prev.secString);
            this.appendMillis(time);
        }
    }

    private void appendMillis(long time) {
        int ms;
        int z = this.size + 3;
        if (z > this.len) {
            this.resize(Math.max(z, this.len * 2));
        }
        if ((ms = (int)(time % 1000L)) < 0) {
            ms += 1000;
        }
        int ms2 = ms / 10;
        int ms3 = ms2 / 10;
        this.cbuf[this.size++] = DIGITS[ms3];
        this.cbuf[this.size++] = DIGITS[ms2 % 10];
        this.cbuf[this.size++] = DIGITS[ms % 10];
    }

    public void appendNumber(long value, int len) {
        String s = Long.toString(value);
        int n = s.length();
        if (n >= len) {
            this.append(s, n - len, n);
        } else {
            this.appendBlank(len - n);
            this.append(s);
        }
    }

    public void appendBlank(int len) {
        while (len > 0) {
            int n = Math.min(len, BLANK.length);
            this.append(BLANK, 0, n);
            len -= n;
        }
    }

    static {
        Arrays.fill(BLANK, ' ');
    }

    private static class Second {
        long sec;
        String secString;

        public Second(long sec, String secString) {
            this.sec = sec;
            this.secString = secString;
        }
    }
}

