/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class LoggedStream
extends OutputStream {
    private static final String LogStreamClassName = LoggedStream.class.getName();
    private static final byte CR = 13;
    private static final byte LF = 10;
    private Logger logger;
    private String loggerName;
    private Level level;
    private byte[] buf;
    private int ofs;
    private int len;
    private boolean wasCR = false;
    private PrintStream debug;

    public LoggedStream(Logger logger, Level level, int bufSize, PrintStream debug) {
        this.logger = logger;
        this.level = level;
        this.debug = debug;
        if (bufSize < 1024) {
            bufSize = 1024;
        }
        this.buf = new byte[bufSize];
        this.ofs = 0;
        this.len = this.buf.length;
        this.loggerName = logger.getName();
    }

    @Override
    public void write(int b) throws IOException {
        this.write((byte)b);
    }

    public void write(byte b) throws IOException {
        if (b == 10 || b == 13) {
            if (this.ofs == 0 && b == 10 && this.wasCR) {
                this.wasCR = false;
                return;
            }
            this.log(this.buf, 0, this.ofs);
            this.ofs = 0;
            this.wasCR = b == 13;
            return;
        }
        if (this.ofs >= this.len) {
            this.log(this.buf, 0, this.ofs);
            this.ofs = 0;
        }
        this.buf[this.ofs++] = b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            this.write(b[i]);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    protected void log(byte[] b, int off, int len) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        try {
            String msg = new String(b, off, len);
            LogRecord rec = new LogRecord(this.level, msg);
            rec.setLoggerName(this.loggerName);
            this.inferCaller(rec);
            this.logger.log(rec);
        }
        catch (Exception e) {
            e.printStackTrace(this.debug);
        }
    }

    private void inferCaller(LogRecord rec) {
        String cname;
        StackTraceElement frame;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length; ++ix) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(LogStreamClassName)) continue;
            ++ix;
            break;
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!(cname.equals(LogStreamClassName) || cname.startsWith("java.") || cname.startsWith("sun.nio") || cname.equals("com.spacekiller.util.Sys"))) {
                rec.setSourceClassName(cname);
                rec.setSourceMethodName(frame.getMethodName());
                return;
            }
            ++ix;
        }
    }

    @Override
    public void close() throws IOException {
    }
}

