/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LoggingConfig {
    public static final Level DEFAULT_LEVEL = Level.INFO;
    private Set levels = new TreeSet(new LevelComparator());
    private Map levelMap = new HashMap();
    private Map levelIcons = new HashMap();
    private Map loggerLevels = new HashMap();
    private Map packageLevels = new HashMap();

    public LoggingConfig() {
        this.initLoggingConfig();
    }

    protected void initLoggingConfig() {
        this.addLevel(Level.OFF);
        this.addLevel(Level.SEVERE);
        this.addLevel(Level.WARNING);
        this.addLevel(Level.INFO);
        this.addLevel(Level.CONFIG);
        this.addLevel(Level.FINE);
        this.addLevel(Level.FINER);
        this.addLevel(Level.FINEST);
        this.addLevel(Level.ALL);
        this.setLevelIcon(Level.OFF, this.loadIcon("/com/spacekiller/infection/icons/log_disabled.png"));
        this.setLevelIcon(Level.SEVERE, this.loadIcon("/com/spacekiller/infection/icons/log_severe.png"));
        this.setLevelIcon(Level.WARNING, this.loadIcon("/com/spacekiller/infection/icons/log_warning.png"));
        this.setLevelIcon(Level.INFO, this.loadIcon("/com/spacekiller/infection/icons/log_info.png"));
        this.setLevelIcon(Level.CONFIG, this.loadIcon("/com/spacekiller/infection/icons/log_config.png"));
        this.setLevelIcon(Level.FINE, this.loadIcon("/com/spacekiller/infection/icons/log_fine.png"));
        this.setLevelIcon(Level.FINER, this.loadIcon("/com/spacekiller/infection/icons/log_finer.png"));
        this.setLevelIcon(Level.FINEST, this.loadIcon("/com/spacekiller/infection/icons/log_finest.png"));
        this.setLevelIcon(Level.ALL, this.loadIcon("/com/spacekiller/infection/icons/log_all.png"));
        this.setLoggerLevel("", DEFAULT_LEVEL);
        this.setLoggerLevel("SystemOut", null);
        this.setLoggerLevel("SystemErr", null);
    }

    public void addLevel(Level level) {
        if (level == null) {
            return;
        }
        this.levels.add(level);
        String name = level.getName();
        this.levelMap.put(name, level);
    }

    public void removeLevel(Level level) {
        this.levels.remove(level);
        String name = level.getName();
        this.levelMap.remove(name);
    }

    public void setLevelIcon(Level level, Icon icon) {
        if (level == null) {
            return;
        }
        this.levelIcons.put(level, icon);
    }

    protected Icon loadIcon(String resource) {
        URL url = this.getClass().getResource(resource);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public Level[] getLevels() {
        return this.levels.toArray(new Level[this.levels.size()]);
    }

    public Icon getLevelIcon(Level level) {
        return (Icon)this.levelIcons.get(level);
    }

    public Iterator getLoggers() {
        return this.loggerLevels.keySet().iterator();
    }

    public Level getLoggerLevel(String logger) {
        return (Level)this.loggerLevels.get(logger);
    }

    public void setLoggerLevel(String logger, Level level) {
        if (logger == null) {
            return;
        }
        if ("".equals(logger) && level == null) {
            level = DEFAULT_LEVEL;
        }
        this.loggerLevels.put(logger, level);
    }

    public Level resolveLevel(String name) {
        if (name == null) {
            return null;
        }
        Level level = (Level)this.levelMap.get(name);
        if (level != null) {
            return level;
        }
        level = Level.parse(name);
        if (level != null) {
            this.addLevel(level);
        }
        return level;
    }

    public Iterator getPackages() {
        return this.packageLevels.keySet().iterator();
    }

    public Level getPackageLevel(String pkg) {
        return (Level)this.packageLevels.get(pkg);
    }

    public void setPackageLevel(String pkg, Level level) {
        if (pkg == null) {
            return;
        }
        if (pkg.length() < 1) {
            return;
        }
        this.packageLevels.put(pkg, level);
    }

    protected static class LevelComparator
    implements Comparator {
        protected LevelComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            int i1;
            Level lvl0 = (Level)arg0;
            Level lvl1 = (Level)arg1;
            int i0 = lvl0.intValue();
            if (i0 < (i1 = lvl1.intValue())) {
                return -1;
            }
            if (i0 > i1) {
                return 1;
            }
            return lvl0.getName().compareTo(lvl1.getName());
        }
    }
}

