/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.old;

import com.spacekiller.infection.Infection;
import com.spacekiller.infection.old.ErrorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ErrorDialog
extends JDialog {
    private static final long serialVersionUID = 6867551294782061303L;
    private static final Logger logger = Logger.getLogger(ErrorDialog.class.getName());
    private Throwable error;
    private ErrorPanel errorPanel = null;
    private JButton jButtonOk = null;

    public ErrorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.initialize();
    }

    public ErrorDialog() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(316, 196));
        this.setContentPane(this.getErrorPanel());
        this.setTitle("Error");
    }

    private ErrorPanel getErrorPanel() {
        if (this.errorPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 2;
            this.errorPanel = new ErrorPanel();
            this.errorPanel.add((Component)this.getJButton(), gridBagConstraints);
        }
        return this.errorPanel;
    }

    public static void showErrorDialog(Throwable error) {
        ErrorDialog.showErrorDialog(error, "Error");
    }

    public static void showErrorDialog(Throwable error, String title) {
        if (error == null) {
            return;
        }
        JFrame owner = new JFrame();
        try {
            ImageIcon icon = new ImageIcon(ErrorDialog.class.getResource("/com/spacekiller/infection/icons/statusstop.gif"));
            owner.setIconImage(icon.getImage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        ErrorDialog dialog = new ErrorDialog(owner);
        dialog.setTitle(title);
        dialog.setError(error);
        dialog.pack();
        int maxWidth = 500;
        int maxHeight = 500;
        Rectangle bounds = dialog.getBounds();
        if (bounds.width > maxWidth) {
            bounds.width = maxWidth;
        }
        if (bounds.height > maxHeight) {
            bounds.height = maxHeight;
        }
        dialog.setBounds(bounds);
        Infection.centerWindow(dialog);
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    public Throwable getError() {
        return this.error;
    }

    public synchronized void setError(Throwable error) {
        this.error = error;
        this.refresh();
    }

    protected synchronized void refresh() {
        this.getErrorPanel().setError(this.error);
    }

    private JButton getJButton() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText("Ok");
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ErrorDialog.this.dispose();
                }
            });
        }
        return this.jButtonOk;
    }

    public static void main(String[] args) {
        try {
            ErrorDialog.showErrorDialog(new Throwable("My Test-Error"));
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        System.exit(0);
    }
}

