/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionInstaller;
import com.spacekiller.infection.InfectionRuntime;
import com.spacekiller.infection.swing.InstallerPageManagerPanel;
import com.spacekiller.infection.swing.InstanceCustomizer;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class InfectionDialog {
    private static final Logger logger = Logger.getLogger(InfectionDialog.class.getName());
    private Window initWindow;
    private JFrame frame;
    private InfectionRuntime access;
    private InfectionInstaller installer;
    private String distributionTitle = "Infection Platform";
    private InstallerPageManagerPanel installerPageManagerPanel;
    private Object dialogLock = new Object();
    private int dialogAction = 0;
    private boolean promptUpgrade = true;
    private boolean autoSaveConfig = false;
    private boolean promptRestart = false;

    public InfectionDialog(InfectionInstaller installer, Window initWindow, JFrame frame, InfectionRuntime access) {
        this.initWindow = initWindow;
        this.frame = frame;
        this.setInstaller(installer);
        this.setAccess(access);
        this.initInfectionDialog();
    }

    private void setupDialog() throws Exception {
        if (this.frame != null) {
            this.frame.setTitle(this.distributionTitle);
        }
    }

    public void showDialog() throws Exception {
        this.setupDialog();
        if (this.frame != null) {
            Infection.centerWindow(this.frame);
            this.frame.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean installPlatform(int panelId) throws Exception {
        this.setupDialog();
        if (this.frame != null) {
            this.frame.pack();
            Infection.centerWindow(this.frame);
        }
        switch (panelId) {
            case 200: {
                this.actionShowLocationMenuPage();
                this.actionShowInstanceConfigPage();
                break;
            }
            case 209: {
                this.actionShowLocationMenuPage();
                this.actionShowInstanceConfigPage();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InfectionDialog.this.getInfectionInstanceCustomizer().clickShowJavaOptionsWizard();
                    }
                });
                break;
            }
            case 210: {
                this.actionShowLocationMenuPage();
                this.actionShowInstanceConfigPage();
                this.getInfectionInstanceCustomizer().showTabArtifacts();
                break;
            }
            case 290: {
                this.actionShowLocationMenuPage();
                this.actionShowInstanceConfigPage();
                this.getInfectionInstanceCustomizer().showTabAdvanced();
                break;
            }
            case 110: {
                this.actionShowLocationMenuPage();
                boolean refresh = true;
                this.actionShowUpdateSites(refresh);
                break;
            }
            case 1: {
                this.actionShowLicense();
                break;
            }
            default: {
                this.actionShowLocationMenuPage();
            }
        }
        if (this.initWindow != null) {
            this.initWindow.setVisible(false);
            this.initWindow = null;
        }
        this.frame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                Object object = InfectionDialog.this.dialogLock;
                synchronized (object) {
                    InfectionDialog.this.dialogLock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent e) {
                Object object = InfectionDialog.this.dialogLock;
                synchronized (object) {
                    InfectionDialog.this.dialogLock.notifyAll();
                }
            }
        });
        this.dialogAction = -1;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfectionDialog.this.frame.setVisible(true);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfectionDialog.this.frame.validate();
                InfectionDialog.this.frame.repaint();
            }
        });
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DEBUG: Waiting for platform installer dialog: " + this.frame);
            logger.fine("DEBUG: isEventDispatchThread=" + SwingUtilities.isEventDispatchThread());
        }
        Object refresh = this.dialogLock;
        synchronized (refresh) {
            this.dialogLock.wait();
        }
        int action = this.dialogAction;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DEBUG: Platform install dialog completed: action=" + action);
        }
        switch (action) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    protected void initInfectionDialog() {
        this.installerPageManagerPanel = new InstallerPageManagerPanel();
        this.installerPageManagerPanel.getInstallerPageManager().setRuntime(this.access);
        this.installerPageManagerPanel.getInstallerPageManager().setInstaller(this.installer);
        this.installerPageManagerPanel.getInstallerPageManager().setDistributionTitle(this.distributionTitle);
        File installDir = this.installer.getInstallationDirectory();
        try {
            this.installerPageManagerPanel.getInstallerPageManager().setInstallationDirectory(installDir);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (this.frame == null) {
            return;
        }
        this.frame.setContentPane(this.installerPageManagerPanel);
        this.frame.pack();
        Infection.centerWindow(this.frame);
    }

    private InstanceCustomizer getInfectionInstanceCustomizer() {
        return this.installerPageManagerPanel.getInfectionInstanceCustomizer();
    }

    protected void actionShowLicense() {
        this.installerPageManagerPanel.getInstallerPageManager().showLicenseAcceptPage();
    }

    public void actionShowLocationMenuPage() {
        this.installerPageManagerPanel.getInstallerPageManager().showLocationMenuPage();
    }

    public void actionShowUpdateSites(boolean refresh) {
        this.installerPageManagerPanel.getInstallerPageManager().showUpdateSitesTreePage(refresh);
    }

    public void refreshUpdateSites(boolean sync) {
        this.installerPageManagerPanel.getInstallerPageManager().refreshUpdateSites(sync);
    }

    public void showDownloadArtifactsTablePage() {
        this.installerPageManagerPanel.getInstallerPageManager().showArtifactsTablePage();
    }

    public int getSelectedDownloadArtifactCount() {
        Artifact[] artifacts = this.installerPageManagerPanel.getInstallerPageManager().getSelectedDownloadArtifacts();
        return artifacts.length;
    }

    public boolean startDownloadArtifacts(boolean sync) {
        return this.installerPageManagerPanel.getInstallerPageManager().startDownloadArtifacts(sync);
    }

    protected void actionShowInstanceConfigPage() {
        this.installerPageManagerPanel.getInstallerPageManager().showLocationConfigPage();
    }

    protected InfectionInstaller getInstaller() {
        return this.installer;
    }

    protected void setInstaller(InfectionInstaller installer) {
        this.installer = installer;
    }

    protected InfectionRuntime getAccess() {
        return this.access;
    }

    protected void setAccess(InfectionRuntime access) {
        this.access = access;
    }

    protected String getDistributionTitle() {
        return this.distributionTitle;
    }

    public void setDistributionTitle(String distributionTitle) {
        this.distributionTitle = distributionTitle;
    }

    public boolean isPromptUpgrade() {
        return this.promptUpgrade;
    }

    public void setPromptUpgrade(boolean promptUpgrade) {
        this.promptUpgrade = promptUpgrade;
        this.installerPageManagerPanel.getInstallerPageManager().setPromptUpgrade(promptUpgrade);
    }

    public boolean isPromptRestart() {
        return this.promptRestart;
    }

    public void setPromptRestart(boolean promptRestart) {
        this.promptRestart = promptRestart;
        this.installerPageManagerPanel.getInstallerPageManager().setPromptRestart(promptRestart);
    }

    public boolean isAutoSaveConfig() {
        return this.autoSaveConfig;
    }

    public void setAutoSaveConfig(boolean autoSaveConfig) {
        this.autoSaveConfig = autoSaveConfig;
        this.installerPageManagerPanel.getInstallerPageManager().setAutoSaveConfig(autoSaveConfig);
    }
}

