/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionRuntime;
import com.spacekiller.infection.swing.InstanceLoggingEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class InfectionRuntimeLoggingEditor
extends JPanel {
    private static final long serialVersionUID = 5202579005155235211L;
    private static final Logger logger = Logger.getLogger(InfectionRuntimeLoggingEditor.class.getName());
    private InfectionRuntime runtime;
    private InfectionInstallation installation;
    private InfectionIndex index;
    private InfectionInstance instance;
    private InfectionInstance modifiedInstance;
    private InstanceLoggingEditor infectionInstanceLoggingEditor = null;
    private JPanel jPanel = null;
    private JButton jButtonApply = null;
    private JButton jButtonSave = null;

    public InfectionRuntimeLoggingEditor() {
        this.initialize();
        this.initInfectionRuntimeLoggingEditor();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 13;
        gridBagConstraints1.weighty = 0.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(524, 394));
        this.add((Component)this.getInfectionInstanceLoggingEditor(), gridBagConstraints);
        this.add((Component)this.getJPanel(), gridBagConstraints1);
    }

    private InstanceLoggingEditor getInfectionInstanceLoggingEditor() {
        if (this.infectionInstanceLoggingEditor == null) {
            this.infectionInstanceLoggingEditor = new InstanceLoggingEditor();
        }
        return this.infectionInstanceLoggingEditor;
    }

    public void showLoggingConfigDialog() {
        JDialog dialog = new JDialog();
        dialog.setTitle("Logging Configuration");
        dialog.setContentPane(this);
        dialog.pack();
        Infection.centerWindow(dialog);
        dialog.setModal(false);
        dialog.setVisible(true);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints2.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setOpaque(false);
            this.jPanel.add((Component)this.getJButtonApply(), gridBagConstraints2);
            this.jPanel.add((Component)this.getJButtonSave(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private JButton getJButtonApply() {
        if (this.jButtonApply == null) {
            this.jButtonApply = new JButton();
            this.jButtonApply.setText("Apply");
            this.jButtonApply.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/statusok.gif")));
            this.jButtonApply.setToolTipText("Apply the settings for this session");
            this.jButtonApply.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InfectionRuntimeLoggingEditor.this.actionApply();
                }
            });
        }
        return this.jButtonApply;
    }

    private JButton getJButtonSave() {
        if (this.jButtonSave == null) {
            this.jButtonSave = new JButton();
            this.jButtonSave.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/save_edit.gif")));
            this.jButtonSave.setToolTipText("Apply and save the settings");
            this.jButtonSave.setText("Save");
            this.jButtonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InfectionRuntimeLoggingEditor.this.actionSave();
                }
            });
        }
        return this.jButtonSave;
    }

    protected InfectionIndex getIndex() {
        return this.index;
    }

    public void setIndex(InfectionIndex index) {
        this.index = index;
        this.getInfectionInstanceLoggingEditor().setIndex(index);
    }

    protected InfectionInstallation getInstallation() {
        return this.installation;
    }

    public void setInstallation(InfectionInstallation installation) {
        this.installation = installation;
        this.getInfectionInstanceLoggingEditor().setInstallation(installation);
    }

    protected InfectionInstance getInstance() {
        return this.instance;
    }

    public void setInstance(InfectionInstance instance) {
        this.instance = instance;
        this.modifiedInstance = instance == null ? null : new InfectionInstance(instance);
        this.getInfectionInstanceLoggingEditor().setInstance(this.modifiedInstance);
    }

    public void refresh() {
        this.getInfectionInstanceLoggingEditor().refresh();
    }

    public void refreshAsync() {
        this.getInfectionInstanceLoggingEditor().refreshAsync();
    }

    private void initInfectionRuntimeLoggingEditor() {
        this.getInfectionInstanceLoggingEditor().setIncludeRegisteredLoggers(true);
    }

    protected void actionApply() {
        try {
            if (this.runtime == null) {
                throw new NullPointerException("runtime");
            }
            Properties loggingProperties = this.applyInstanceLoggingProperties();
            if (loggingProperties == null) {
                return;
            }
            Infection.getInstance().reloadRuntimeLoggingConfig(this.runtime, loggingProperties);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionSave() {
        try {
            if (this.runtime == null) {
                throw new NullPointerException("runtime");
            }
            Properties loggingProperties = this.applyInstanceLoggingProperties();
            if (loggingProperties == null) {
                return;
            }
            throw new RuntimeException("TODO save instance config");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
    }

    protected Properties applyInstanceLoggingProperties() {
        if (this.modifiedInstance == null) {
            return null;
        }
        if (this.instance == null) {
            return null;
        }
        Properties props = this.modifiedInstance.getLoggingProperties();
        this.instance.setLoggingProperties(props);
        return props;
    }

    protected InfectionRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(InfectionRuntime runtime) {
        this.runtime = runtime;
    }
}

