/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.install.DownloadArtifactTask;
import com.spacekiller.infection.install.InstallerTask;
import com.spacekiller.infection.install.InstallerTaskListener;
import com.spacekiller.infection.install.InstallerTaskManager;
import com.spacekiller.infection.swing.InstallerBanner;
import com.spacekiller.infection.swing.InstallerPagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class InstallationArtifactDownloadPanel
extends InstallerPagePanel {
    private static final long serialVersionUID = 6660682443711567626L;
    private static final Logger logger = Logger.getLogger(InstallationArtifactDownloadPanel.class.getName());
    private ArtifactsDownloadListener artifactsDownloadListener;
    private DefaultListModel downloadListModel;
    private InstallerTaskManager taskManager;
    private JPanel jPanel11 = null;
    private JPanel jPanel12 = null;
    private JLabel jLabel5 = null;
    private JButton jButtonCancelDownload = null;
    private JProgressBar jProgressBarDownload = null;
    private JScrollPane jScrollPane3 = null;
    private JList jListDownloadJobs = null;
    private InstallerBanner infectionBanner;

    public InstallationArtifactDownloadPanel() {
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.insets = new Insets(0, 0, 4, 0);
        gridBagConstraints13.fill = 1;
        gridBagConstraints13.gridy = 1;
        GridBagConstraints gridBagConstraints38 = new GridBagConstraints();
        gridBagConstraints38.anchor = 11;
        gridBagConstraints38.insets = new Insets(4, 4, 5, 4);
        gridBagConstraints38.gridx = 0;
        gridBagConstraints38.gridy = 1;
        gridBagConstraints38.weightx = 1.0;
        gridBagConstraints38.weighty = 1.0;
        gridBagConstraints38.fill = 1;
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.anchor = 13;
        gridBagConstraints31.gridx = 0;
        gridBagConstraints31.gridy = 2;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(619, 409));
        GridBagConstraints gbc_infectionBanner = new GridBagConstraints();
        gbc_infectionBanner.fill = 2;
        gbc_infectionBanner.gridx = 0;
        gbc_infectionBanner.gridy = 0;
        this.add((Component)this.getInfectionBanner(), gbc_infectionBanner);
        this.add((Component)this.getJPanel11(), gridBagConstraints31);
        this.add((Component)this.getJPanel12(), gridBagConstraints38);
        this.initInstallationDownloadPanel();
    }

    private void initInstallationDownloadPanel() {
        this.artifactsDownloadListener = new ArtifactsDownloadListener();
        this.downloadListModel = new DefaultListModel();
        this.getJListDownloadJobs().setModel(this.downloadListModel);
        DownloadListCellRenderer downloadListCellRenderer = new DownloadListCellRenderer();
        downloadListCellRenderer.setQueueIcon(this.createIcon("/com/spacekiller/infection/icons/blue-ball-small.gif"));
        downloadListCellRenderer.setDownloadIcon(this.createIcon("/com/spacekiller/infection/icons/blue-ball.gif"));
        downloadListCellRenderer.setSuccessIcon(this.createIcon("/com/spacekiller/infection/icons/green-ball.gif"));
        downloadListCellRenderer.setFailedIcon(this.createIcon("/com/spacekiller/infection/icons/red-ball.gif"));
        this.getJListDownloadJobs().setCellRenderer(downloadListCellRenderer);
    }

    private JPanel getJPanel11() {
        if (this.jPanel11 == null) {
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.gridx = 0;
            gridBagConstraints36.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints36.gridy = 0;
            this.jPanel11 = new JPanel();
            this.jPanel11.setLayout(new GridBagLayout());
            this.jPanel11.add((Component)this.getJButtonCancelDownload(), gridBagConstraints36);
        }
        return this.jPanel11;
    }

    private JPanel getJPanel12() {
        if (this.jPanel12 == null) {
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.anchor = 17;
            gridBagConstraints34.gridx = 0;
            gridBagConstraints34.gridy = 0;
            gridBagConstraints34.insets = new Insets(4, 0, 5, 4);
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("Transferring artifacts, please wait...");
            this.jPanel12 = new JPanel();
            this.jPanel12.setLayout(new GridBagLayout());
            this.jPanel12.add((Component)this.jLabel5, gridBagConstraints34);
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints35.gridx = 0;
            gridBagConstraints35.weightx = 1.0;
            gridBagConstraints35.fill = 2;
            gridBagConstraints35.gridy = 1;
            this.jPanel12.add((Component)this.getJProgressBarDownload(), gridBagConstraints35);
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.fill = 1;
            gridBagConstraints27.gridy = 2;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.weighty = 1.0;
            gridBagConstraints27.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints27.gridx = 0;
            this.jPanel12.add((Component)this.getJScrollPane3(), gridBagConstraints27);
        }
        return this.jPanel12;
    }

    private JButton getJButtonCancelDownload() {
        if (this.jButtonCancelDownload == null) {
            this.jButtonCancelDownload = new JButton();
            this.jButtonCancelDownload.setText("Cancel");
            this.jButtonCancelDownload.setEnabled(true);
            this.jButtonCancelDownload.setToolTipText("Cancel download..");
            this.jButtonCancelDownload.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonCancelDownload.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationArtifactDownloadPanel.this.actionCancelDownload();
                }
            });
        }
        return this.jButtonCancelDownload;
    }

    private JProgressBar getJProgressBarDownload() {
        if (this.jProgressBarDownload == null) {
            this.jProgressBarDownload = new JProgressBar();
            this.jProgressBarDownload.setStringPainted(true);
        }
        return this.jProgressBarDownload;
    }

    private JScrollPane getJScrollPane3() {
        if (this.jScrollPane3 == null) {
            this.jScrollPane3 = new JScrollPane();
            this.jScrollPane3.setViewportView(this.getJListDownloadJobs());
        }
        return this.jScrollPane3;
    }

    private JList getJListDownloadJobs() {
        if (this.jListDownloadJobs == null) {
            this.jListDownloadJobs = new JList();
            this.jListDownloadJobs.setEnabled(false);
        }
        return this.jListDownloadJobs;
    }

    public InstallerBanner getInfectionBanner() {
        if (this.infectionBanner == null) {
            this.infectionBanner = new InstallerBanner();
            this.infectionBanner.setTitle("Download");
            this.infectionBanner.setForeground(Color.WHITE);
        }
        return this.infectionBanner;
    }

    @Override
    protected synchronized void refresh() {
        this.decorateBanner(this.getInfectionBanner());
        this.downloadListModel.removeAllElements();
        InstallerTaskManager taskManager = this.getTaskManager();
        if (taskManager != null) {
            int num = taskManager.getTaskCount();
            for (int i = 0; i < num; ++i) {
                InstallerTask task = taskManager.getTaskAt(i);
                this.downloadListModel.addElement(task);
            }
        }
    }

    protected Icon createIcon(String resource) {
        try {
            URL url = this.getClass().getResource(resource);
            if (url == null) {
                return null;
            }
            return new ImageIcon(url);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected InstallerTaskManager getTaskManager() {
        return this.taskManager;
    }

    protected void setTaskManager(InstallerTaskManager taskManager) {
        this.taskManager = taskManager;
        this.refresh();
    }

    protected ArtifactsDownloadListener getArtifactsDownloadListener() {
        return this.artifactsDownloadListener;
    }

    protected void actionCancelDownload() {
        try {
            InstallerTaskManager taskManager = this.getTaskManager();
            if (taskManager != null) {
                Component parentComponent = null;
                String message = "Are you sure to cancel the download ?";
                String title = "Cancel Download";
                int optionType = 0;
                int messageType = 3;
                int rc = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
                if (rc != 0) {
                    return;
                }
                taskManager.cancel();
            }
            this.getPageContext().actionBack();
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected class ArtifactsDownloadListener
    implements InstallerTaskListener {
        protected ArtifactsDownloadListener() {
        }

        @Override
        public void taskStarted(final InstallerTask job) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int row = ArtifactsDownloadListener.this.getTaskIndex(job);
                    if (row >= 0) {
                        InstallationArtifactDownloadPanel.this.getJListDownloadJobs().getSelectionModel().addSelectionInterval(row, row);
                        ArtifactsDownloadListener.this.scrollToLastActiveJob();
                    }
                }
            });
        }

        @Override
        public void taskCompleted(final InstallerTask job) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int row = ArtifactsDownloadListener.this.getTaskIndex(job);
                    if (row >= 0) {
                        InstallationArtifactDownloadPanel.this.getJListDownloadJobs().getSelectionModel().removeSelectionInterval(row, row);
                        ArtifactsDownloadListener.this.scrollToLastActiveJob();
                    }
                }
            });
        }

        private int getTaskIndex(InstallerTask job) {
            int num = InstallationArtifactDownloadPanel.this.taskManager.getTaskCount();
            for (int i = num - 1; i >= 0; --i) {
                InstallerTask task = InstallationArtifactDownloadPanel.this.taskManager.getTaskAt(i);
                if (task != job) continue;
                return i;
            }
            return -1;
        }

        private void scrollToLastActiveJob() {
            int num = InstallationArtifactDownloadPanel.this.taskManager.getTaskCount();
            for (int i = num - 1; i >= 0; --i) {
                InstallerTask task = InstallationArtifactDownloadPanel.this.taskManager.getTaskAt(i);
                if (task.getStatus() == 0) continue;
                this.scrollJobToVisible(i);
                return;
            }
        }

        private void scrollJobToVisible(int row) {
            Rectangle rect = InstallationArtifactDownloadPanel.this.getJListDownloadJobs().getCellBounds(row, row);
            if (rect == null) {
                return;
            }
            InstallationArtifactDownloadPanel.this.getJListDownloadJobs().scrollRectToVisible(rect);
        }
    }

    protected class DownloadListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -8928299180964475291L;
        private Icon queueIcon;
        private Icon downloadIcon;
        private Icon successIcon;
        private Icon failedIcon;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean arg3, boolean arg4) {
            Component rc = super.getListCellRendererComponent((JList<?>)list, value, index, arg3, arg4);
            String text = "" + value;
            Icon icon = null;
            if (value instanceof DownloadArtifactTask) {
                DownloadArtifactTask job = (DownloadArtifactTask)value;
                text = "" + job.getTitle();
                String downloadPath = job.getCurrentDownloadPath();
                if (downloadPath != null) {
                    text = downloadPath;
                }
                icon = this.queueIcon;
                int status = job.getStatus();
                switch (status) {
                    case 0: {
                        icon = this.queueIcon;
                        break;
                    }
                    case 1: {
                        icon = this.downloadIcon;
                        break;
                    }
                    case 2: {
                        icon = this.successIcon;
                        break;
                    }
                    case 3: {
                        icon = this.failedIcon;
                    }
                }
            }
            this.setText(text);
            this.setIcon(icon);
            this.setEnabled(true);
            return rc;
        }

        public Icon getFailedIcon() {
            return this.failedIcon;
        }

        public void setFailedIcon(Icon failedIcon) {
            this.failedIcon = failedIcon;
        }

        public Icon getQueueIcon() {
            return this.queueIcon;
        }

        public void setQueueIcon(Icon queueIcon) {
            this.queueIcon = queueIcon;
        }

        public Icon getSuccessIcon() {
            return this.successIcon;
        }

        public void setSuccessIcon(Icon successIcon) {
            this.successIcon = successIcon;
        }

        public Icon getDownloadIcon() {
            return this.downloadIcon;
        }

        public void setDownloadIcon(Icon downloadIcon) {
            this.downloadIcon = downloadIcon;
        }
    }
}

