/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.ArtifactDependency;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.install.ArtifactKey;
import com.spacekiller.infection.install.ArtifactModel;
import com.spacekiller.infection.install.InstallationArtifactTableModel;
import com.spacekiller.infection.install.InstallerPageContext;
import com.spacekiller.infection.swing.InstallationArtifactTable;
import com.spacekiller.infection.swing.InstallerBanner;
import com.spacekiller.infection.swing.InstallerPagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class InstallationArtifactTablePanel
extends InstallerPagePanel {
    private static final long serialVersionUID = -901831748552873299L;
    private static final Logger logger = Logger.getLogger(InstallationArtifactTablePanel.class.getName());
    private final ArtifactSelectionListener artifactSelectionListener = new ArtifactSelectionListener();
    private InstallationArtifactTableModel artifactTableModel;
    private JScrollPane jScrollPane2 = null;
    private JPanel jPanel4 = null;
    private JPanel jPanel9 = null;
    private InstallationArtifactTable artifactTable = null;
    private JButton jButtonArtifactsNext = null;
    private JButton jButton1 = null;
    private JLabel jLabelArtifactDownloadInfo = null;
    private JCheckBox jCheckBoxArtifactsLatest = null;
    private JButton jButtonArtifactDeselectAll = null;
    private JCheckBox jCheckBoxArtifactsResolve = null;
    private JCheckBox jCheckBoxArtifactsResolveOptional = null;
    private InstallerBanner infectionBanner;

    public InstallationArtifactTablePanel() {
        GridBagConstraints gridBagConstraints75 = new GridBagConstraints();
        gridBagConstraints75.gridx = 0;
        gridBagConstraints75.fill = 2;
        gridBagConstraints75.insets = new Insets(0, 0, 4, 0);
        gridBagConstraints75.gridy = 1;
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.anchor = 17;
        gridBagConstraints28.insets = new Insets(0, 4, 5, 4);
        gridBagConstraints28.gridx = 0;
        gridBagConstraints28.gridy = 2;
        gridBagConstraints28.weightx = 1.0;
        gridBagConstraints28.fill = 2;
        GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
        gridBagConstraints32.gridx = 0;
        gridBagConstraints32.fill = 2;
        gridBagConstraints32.gridy = 3;
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.fill = 1;
        gridBagConstraints14.gridx = 0;
        gridBagConstraints14.gridy = 1;
        gridBagConstraints14.weightx = 1.0;
        gridBagConstraints14.weighty = 1.0;
        gridBagConstraints14.insets = new Insets(4, 4, 5, 4);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(826, 465));
        GridBagConstraints gbc_infectionBanner = new GridBagConstraints();
        gbc_infectionBanner.fill = 2;
        gbc_infectionBanner.gridx = 0;
        gbc_infectionBanner.gridy = 0;
        this.add((Component)this.getInfectionBanner(), gbc_infectionBanner);
        this.add((Component)this.getJScrollPane2(), gridBagConstraints14);
        this.add((Component)this.getJPanel4(), gridBagConstraints32);
        this.add((Component)this.getJPanel9(), gridBagConstraints28);
        this.initInstallationArtifactsPanel();
    }

    protected void initInstallationArtifactsPanel() {
        this.artifactTableModel = new InstallationArtifactTableModel();
        this.getArtifactTable().setModel(this.artifactTableModel);
        this.artifactTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent ev) {
                InstallationArtifactTablePanel.this.checkArtifactsSelected();
            }
        });
        this.artifactTableModel.getCheckModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                InstallationArtifactTablePanel.this.checkArtifactsSelected();
            }
        });
        this.artifactTableModel.getCheckModel().addListSelectionListener(this.artifactSelectionListener);
        String fontName = "dialog";
        int normalFontSize = 14;
        Font font = this.getJButton1().getFont();
        if (font != null) {
            fontName = font.getName();
            normalFontSize = font.getSize();
        }
        int largeFontSize = normalFontSize * 4 / 3;
        this.getJButtonArtifactsNext().setFont(new Font(fontName, 1, largeFontSize));
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getArtifactTable());
        }
        return this.jScrollPane2;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints12.anchor = 16;
            gridBagConstraints12.gridy = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints10.gridy = -1;
            gridBagConstraints10.anchor = 13;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.gridx = 1;
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new GridBagLayout());
            this.jPanel4.add((Component)this.getJButtonArtifactsNext(), gridBagConstraints10);
            this.jPanel4.add((Component)this.getJButton1(), gridBagConstraints12);
        }
        return this.jPanel4;
    }

    private JPanel getJPanel9() {
        if (this.jPanel9 == null) {
            GridBagConstraints gridBagConstraints79 = new GridBagConstraints();
            gridBagConstraints79.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints79.gridx = 0;
            gridBagConstraints79.fill = 2;
            gridBagConstraints79.anchor = 11;
            gridBagConstraints79.gridy = 0;
            this.jLabelArtifactDownloadInfo = new JLabel();
            this.jLabelArtifactDownloadInfo.setText("JLabelInfo abcdefg");
            GridBagConstraints gridBagConstraints78 = new GridBagConstraints();
            gridBagConstraints78.gridx = 2;
            gridBagConstraints78.anchor = 17;
            gridBagConstraints78.insets = new Insets(0, 0, 5, 8);
            gridBagConstraints78.gridy = 0;
            GridBagConstraints gridBagConstraints57 = new GridBagConstraints();
            gridBagConstraints57.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints57.gridx = 1;
            gridBagConstraints57.anchor = 17;
            gridBagConstraints57.gridy = 1;
            GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
            gridBagConstraints40.gridx = 0;
            gridBagConstraints40.insets = new Insets(0, 4, 0, 5);
            gridBagConstraints40.weightx = 1.0;
            gridBagConstraints40.anchor = 17;
            gridBagConstraints40.gridy = 1;
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.anchor = 17;
            gridBagConstraints29.gridx = 1;
            gridBagConstraints29.gridy = 0;
            gridBagConstraints29.insets = new Insets(0, 0, 5, 8);
            this.jPanel9 = new JPanel();
            this.jPanel9.setLayout(new GridBagLayout());
            this.jPanel9.add((Component)this.getJCheckBoxArtifactsLatest(), gridBagConstraints29);
            this.jPanel9.add((Component)this.getJButtonArtifactDeselectAll(), gridBagConstraints40);
            this.jPanel9.add((Component)this.getJCheckBoxArtifactsResolve(), gridBagConstraints57);
            this.jPanel9.add((Component)this.getJCheckBoxArtifactsResolveOptional(), gridBagConstraints78);
            this.jPanel9.add((Component)this.jLabelArtifactDownloadInfo, gridBagConstraints79);
        }
        return this.jPanel9;
    }

    private InstallationArtifactTable getArtifactTable() {
        if (this.artifactTable == null) {
            this.artifactTable = new InstallationArtifactTable();
        }
        return this.artifactTable;
    }

    private JButton getJButtonArtifactsNext() {
        if (this.jButtonArtifactsNext == null) {
            this.jButtonArtifactsNext = new JButton();
            this.jButtonArtifactsNext.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/install.gif")));
            this.jButtonArtifactsNext.setText("Install");
            this.jButtonArtifactsNext.setToolTipText("Download and install the selected artifacts...");
            this.jButtonArtifactsNext.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonArtifactsNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationArtifactTablePanel.this.actionArtifactsNext();
                }
            });
        }
        return this.jButtonArtifactsNext;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText("< Back");
            this.jButton1.setToolTipText("Back to previous page..");
            this.jButton1.setMargin(new Insets(2, 4, 2, 4));
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationArtifactTablePanel.this.actionArtifactsPrev();
                }
            });
        }
        return this.jButton1;
    }

    private JCheckBox getJCheckBoxArtifactsLatest() {
        if (this.jCheckBoxArtifactsLatest == null) {
            this.jCheckBoxArtifactsLatest = new JCheckBox();
            this.jCheckBoxArtifactsLatest.setText("show latest version only");
            this.jCheckBoxArtifactsLatest.setToolTipText("show latest version only ?");
            this.jCheckBoxArtifactsLatest.setSelected(true);
            this.jCheckBoxArtifactsLatest.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InstallationArtifactTablePanel.this.refreshArtifacts();
                }
            });
        }
        return this.jCheckBoxArtifactsLatest;
    }

    private JButton getJButtonArtifactDeselectAll() {
        if (this.jButtonArtifactDeselectAll == null) {
            this.jButtonArtifactDeselectAll = new JButton();
            this.jButtonArtifactDeselectAll.setCursor(new Cursor(0));
            this.jButtonArtifactDeselectAll.setMargin(new Insets(0, 4, 0, 4));
            this.jButtonArtifactDeselectAll.setText("Deselect All");
            this.jButtonArtifactDeselectAll.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/deselect_all.gif")));
            this.jButtonArtifactDeselectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationArtifactTablePanel.this.deselectAllArtifacts();
                }
            });
        }
        return this.jButtonArtifactDeselectAll;
    }

    private JCheckBox getJCheckBoxArtifactsResolve() {
        if (this.jCheckBoxArtifactsResolve == null) {
            this.jCheckBoxArtifactsResolve = new JCheckBox();
            this.jCheckBoxArtifactsResolve.setText("resolve dependencies");
            this.jCheckBoxArtifactsResolve.setMargin(new Insets(0, 2, 2, 2));
            this.jCheckBoxArtifactsResolve.setToolTipText("resolve dependencies ?");
            this.jCheckBoxArtifactsResolve.setSelected(true);
        }
        return this.jCheckBoxArtifactsResolve;
    }

    private JCheckBox getJCheckBoxArtifactsResolveOptional() {
        if (this.jCheckBoxArtifactsResolveOptional == null) {
            this.jCheckBoxArtifactsResolveOptional = new JCheckBox();
            this.jCheckBoxArtifactsResolveOptional.setSelected(true);
            this.jCheckBoxArtifactsResolveOptional.setText("resolve optional features");
            this.jCheckBoxArtifactsResolveOptional.setToolTipText("resolve optional dependencies ?");
            this.jCheckBoxArtifactsResolveOptional.setMargin(new Insets(0, 2, 2, 2));
        }
        return this.jCheckBoxArtifactsResolveOptional;
    }

    public InstallerBanner getInfectionBanner() {
        if (this.infectionBanner == null) {
            this.infectionBanner = new InstallerBanner();
            this.infectionBanner.setTitle("Artifacts");
            this.infectionBanner.setForeground(Color.WHITE);
        }
        return this.infectionBanner;
    }

    @Override
    protected synchronized void refresh() {
        this.decorateBanner(this.getInfectionBanner());
        this.refreshArtifacts();
    }

    protected void refreshArtifacts() {
        int numArtifactKeys;
        int upgradeArtifactCount;
        int numSites;
        boolean latestOnly = this.getJCheckBoxArtifactsLatest().isSelected();
        this.artifactTableModel.removeAllArtifacts();
        InstallerPageContext context = this.getPageContext();
        if (context == null) {
            return;
        }
        if (context.getInstallationDirectory() == null) {
            return;
        }
        InfectionSite[] sites = context.getSelectedUpdateSitesRecursive();
        int n = numSites = sites == null ? 0 : sites.length;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Number of selected update-sites (recursive): " + numSites);
        }
        ArtifactModel availArtifactModel = new ArtifactModel();
        for (int i = 0; i < numSites; ++i) {
            InfectionSite site = sites[i];
            InfectionIndex siteIndex = site.getIndex();
            if (siteIndex == null) continue;
            context.enumerateAvailableArtifacts(siteIndex, availArtifactModel);
        }
        int availArtifactCount = availArtifactModel.getArtifactCount();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Number of available artifacts: " + availArtifactCount);
        }
        ArtifactModel upgradeArtifactModel = null;
        try {
            upgradeArtifactModel = context.computeUpgradeArtifacts(availArtifactModel);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        int n2 = upgradeArtifactCount = upgradeArtifactModel == null ? 0 : upgradeArtifactModel.getArtifactCount();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Number of upgrade artifacts: " + upgradeArtifactCount);
        }
        boolean ascendingVersion = true;
        availArtifactModel.sortArtifactsByVersion(ascendingVersion);
        Object[] artifactKeys = availArtifactModel.enumerateArtifactKeys();
        int n3 = numArtifactKeys = artifactKeys == null ? 0 : artifactKeys.length;
        if (numArtifactKeys > 0) {
            Arrays.sort(artifactKeys);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Number of available artifact keys: " + numArtifactKeys);
        }
        for (int i = 0; i < numArtifactKeys; ++i) {
            int numArtifacts;
            Object artifactKey = artifactKeys[i];
            Artifact[] availArtifacts = availArtifactModel.findArtifactsForKey((ArtifactKey)artifactKey);
            if (availArtifacts == null || (numArtifacts = availArtifacts.length) < 1) continue;
            for (int k = 0; k < numArtifacts; ++k) {
                Artifact[] upgradeArtifacts;
                Artifact artifact = availArtifacts[k];
                if (artifact == null) continue;
                String version = artifact.getVersion();
                boolean enabled = true;
                boolean selected = false;
                if (upgradeArtifactModel != null && (upgradeArtifacts = upgradeArtifactModel.findArtifactsForVersion((ArtifactKey)artifactKey, version)) != null && upgradeArtifacts.length > 0) {
                    selected = true;
                }
                if (!selected && latestOnly && k < numArtifacts - 1) continue;
                artifact.setInstallTime(0L);
                String factName = artifact.getName();
                Artifact existing = context.getInstalledArtifact(factName, version);
                if (existing != null) {
                    artifact.setInstallTime(existing.getInstallTime());
                    try {
                        context.verifyInstalledArtifact(artifact);
                        enabled = false;
                        selected = false;
                    }
                    catch (Exception e) {
                        selected = true;
                    }
                }
                int row = this.artifactTableModel.getRowCount();
                this.artifactTableModel.addArtifact(artifact);
                this.artifactTableModel.enableArtifact(row, enabled);
                this.artifactTableModel.selectArtifact(row, selected, false);
                if (!selected) continue;
                logger.info("refreshArtifacts: key=" + artifactKey + ", select artifact=" + artifact);
            }
        }
    }

    protected void resolveArtifacts(Set artifacts) {
        LinkedList todo = new LinkedList();
        todo.addAll(artifacts);
        LinkedList queue = new LinkedList();
        while (!todo.isEmpty()) {
            Artifact art = (Artifact)todo.removeFirst();
            int depCount = art.getDependencyCount();
            for (int i = 0; i < depCount; ++i) {
                ArtifactDependency dep = art.getDependencyAt(i);
                if (dep == null || dep.isOptional() && !this.getJCheckBoxArtifactsResolveOptional().isSelected()) continue;
                this.resolveDependency(dep, queue);
            }
        }
    }

    protected void resolveDependency(ArtifactDependency dep, Collection queue) {
        String depName = dep.getArtifact();
        String depVersion = dep.getVersion();
        int selectIndex = -1;
        Artifact selectArt = null;
        int num = this.artifactTableModel.getRowCount();
        for (int c = 0; c < num; ++c) {
            String artName;
            Artifact art = this.artifactTableModel.getArtifactAt(c);
            if (art == null || (artName = art.getName()) == null || !artName.equals(depName)) continue;
            String artVer = art.getVersion();
            if (depVersion != null) {
                if (artVer == null) continue;
                if (!artVer.equals(depVersion)) {
                    if (artVer.compareTo(depVersion) <= 0) continue;
                    if (this.artifactTableModel.isArtifactChecked(c)) {
                        selectIndex = -1;
                        break;
                    }
                    selectIndex = c;
                    selectArt = art;
                    break;
                }
            }
            if (this.artifactTableModel.isArtifactChecked(c) || !this.artifactTableModel.isArtifactEnabled(c)) break;
            boolean newerSelected = false;
            for (int k = 0; k < num; ++k) {
                String xName;
                Artifact x = this.artifactTableModel.getArtifactAt(k);
                if (x == null || k == c || !artName.equals(xName = x.getName())) continue;
                String xVer = x.getVersion();
                if (artVer != null && xVer != null && xVer.compareTo(artVer) > 0) {
                    if (!this.isArtifactInstalled(k) && !this.isArtifactSelected(k)) continue;
                    newerSelected = true;
                    break;
                }
                this.artifactTableModel.selectArtifact(k, false, false);
            }
            if (newerSelected) break;
            selectIndex = c;
            selectArt = art;
            break;
        }
        if (selectIndex >= 0) {
            if (this.artifactTableModel.isArtifactEnabled(selectIndex)) {
                this.artifactTableModel.selectArtifact(selectIndex, true, false);
            }
            queue.add(selectArt);
        }
    }

    protected void selectAllArtifacts() {
        int num = this.artifactTableModel.getRowCount();
        for (int c = 0; c < num; ++c) {
            this.setArtifactSelected(c, true);
        }
        this.getArtifactTable().repaint();
    }

    protected void deselectAllArtifacts() {
        int num = this.artifactTableModel.getRowCount();
        for (int c = 0; c < num; ++c) {
            this.setArtifactSelected(c, false);
        }
        this.getArtifactTable().repaint();
    }

    protected boolean isArtifactSelected(int row) {
        return this.artifactTableModel.isArtifactChecked(row);
    }

    protected boolean isArtifactInstalled(int row) {
        return !this.artifactTableModel.isArtifactEnabled(row);
    }

    protected void setArtifactSelected(int row, boolean selected) {
        if (this.artifactTableModel.isArtifactEnabled(row) && this.isArtifactSelected(row) != selected) {
            this.artifactTableModel.selectArtifact(row, selected, false);
        }
    }

    protected void checkArtifactsSelected() {
        String text;
        int selCount = this.getArtifactSelectionCount();
        String string = text = selCount > 0 ? "Install >" : "Next >";
        if (!text.equals(this.getJButtonArtifactsNext().getText())) {
            this.getJButtonArtifactsNext().setText(text);
        }
    }

    protected int getArtifactSelectionCount() {
        int sel = 0;
        int num = this.artifactTableModel.getRowCount();
        for (int i = 0; i < num; ++i) {
            if (!this.artifactTableModel.isArtifactChecked(i)) continue;
            ++sel;
        }
        return sel;
    }

    protected Artifact[] getSelectedDownloadArtifacts() {
        LinkedList<Artifact> list = new LinkedList<Artifact>();
        int num = this.artifactTableModel.getRowCount();
        for (int i = 0; i < num; ++i) {
            Artifact art;
            if (!this.artifactTableModel.isArtifactChecked(i) || (art = this.artifactTableModel.getArtifactAt(i)) == null) continue;
            list.add(art);
        }
        return list.toArray(new Artifact[list.size()]);
    }

    protected void refreshSelectedArtifactInfo() {
        int selCount = 0;
        long totalSize = 0L;
        boolean totalSizeExact = true;
        int count = this.artifactTableModel.getRowCount();
        for (int i = 0; i <= count; ++i) {
            if (!this.artifactTableModel.isArtifactChecked(i)) continue;
            ++selCount;
            Artifact art = this.artifactTableModel.getArtifactAt(i);
            if (art == null) continue;
            int artLen = art.getLength();
            if (artLen >= 0) {
                totalSize += (long)artLen;
                continue;
            }
            totalSizeExact = false;
        }
        String info = "Selected artifacts: " + selCount;
        if (totalSize > 0L) {
            String sizeStr = this.getSizeString(totalSize);
            if (totalSizeExact) {
                info = info + "  (" + sizeStr + ")";
            } else if (totalSize > 0L) {
                info = info + "  (>~ " + sizeStr + ")";
            }
        }
        this.jLabelArtifactDownloadInfo.setText(info);
    }

    protected String getSizeString(long size) {
        if (size < 0L) {
            return "N/A";
        }
        if (size < 1024L) {
            return "" + size + " bytes";
        }
        long kb = (size - 1L) / 1024L + 1L;
        if (kb < 1024L) {
            return "" + kb + " kB";
        }
        double mb = (double)kb / 1024.0;
        mb = (double)Math.round(mb * 100.0) / 100.0;
        return "" + mb + " MB";
    }

    protected void actionArtifactsPrev() {
        InstallerPageContext context = this.getPageContext();
        if (context == null) {
            return;
        }
        context.actionBack();
    }

    protected void actionArtifactsNext() {
        InstallerPageContext context = this.getPageContext();
        if (context == null) {
            return;
        }
        context.actionNext();
    }

    void actionShowArtifacts() throws Exception {
        logger.info("OLD stuff !!");
        Infection infection = null;
        try {
            infection = Infection.getInstance();
        }
        catch (Exception e) {
            throw new Error(e);
        }
        this.getJButtonArtifactsNext().setEnabled(true);
        this.refreshArtifacts();
        this.getArtifactTable().setModel(this.artifactTableModel);
        String distName = this.getPageContext().getDistributionArtifactName();
        ArtifactDependency[] platformDep = this.getPageContext().getDistributionArtifactDependencies(distName);
        if (platformDep != null) {
            for (int i = 0; i < platformDep.length; ++i) {
                ArtifactDependency dep = platformDep[i];
                ArrayList temp = new ArrayList();
                this.resolveDependency(dep, temp);
            }
        }
        boolean xyz002 = false;
        InfectionIndex installationIndex = null;
        if (installationIndex != null) {
            String factVersion;
            String factName;
            Artifact availArt;
            int c;
            InfectionIndex index = installationIndex;
            HashMap<String, Artifact> installedArtifacts = new HashMap<String, Artifact>();
            int installedCount = index.getArtifactCount();
            for (int c2 = 0; c2 < installedCount; ++c2) {
                String fVersion;
                Artifact installedArt = index.getArtifactAt(c2);
                String factName2 = installedArt.getName();
                String factVersion2 = installedArt.getVersion();
                Artifact f = (Artifact)installedArtifacts.get(factName2);
                if (f != null && (fVersion = f.getVersion()) != null && fVersion.compareTo(factVersion2) >= 0) continue;
                installedArtifacts.put(factName2, installedArt);
            }
            int availCount = this.artifactTableModel.getRowCount();
            for (c = 0; c < availCount; ++c) {
                String fVersion;
                if (!this.isArtifactSelected(c)) continue;
                availArt = this.artifactTableModel.getArtifactAt(c);
                factName = availArt.getName();
                factVersion = availArt.getVersion();
                Artifact f = (Artifact)installedArtifacts.get(factName);
                if (f != null && (fVersion = f.getVersion()) != null && fVersion.compareTo(factVersion) >= 0) continue;
                installedArtifacts.put(factName, availArt);
            }
            for (c = 0; c < availCount; ++c) {
                String installedVersion;
                availArt = this.artifactTableModel.getArtifactAt(c);
                factName = availArt.getName();
                factVersion = availArt.getVersion();
                Artifact installedArt = (Artifact)installedArtifacts.get(factName);
                if (installedArt == null || (installedVersion = installedArt.getVersion()) != null && factVersion != null && installedVersion.compareTo(factVersion) >= 0 || !this.artifactTableModel.isArtifactEnabled(c)) continue;
                for (int k = 0; k < availCount; ++k) {
                    String xName;
                    Artifact x = this.artifactTableModel.getArtifactAt(k);
                    if (x == null || k == c || !factName.equals(xName = x.getName())) continue;
                    this.artifactTableModel.selectArtifact(k, false, false);
                }
                this.artifactTableModel.selectArtifact(c, true, false);
            }
            for (Map.Entry me : installedArtifacts.entrySet()) {
                Artifact fact = (Artifact)me.getValue();
                if (fact == null) continue;
                int depCount = fact.getDependencyCount();
                for (int j = 0; j < depCount; ++j) {
                    int k;
                    String depVer;
                    Artifact art;
                    String depName;
                    ArtifactDependency dep = fact.getDependencyAt(j);
                    if (dep == null || dep.isOptional() && !this.getJCheckBoxArtifactsResolveOptional().isSelected() || (depName = dep.getArtifact()) == null || (art = index.getArtifact(depName, depVer = dep.getVersion())) != null) continue;
                    int numArt = index.getArtifactCount();
                    for (k = 0; k < numArt; ++k) {
                        Artifact art2 = index.getArtifactAt(k);
                        if (!depName.equals(art2.getName())) continue;
                        if (depVer == null) {
                            art = art2;
                            break;
                        }
                        String art2Ver = art2.getVersion();
                        if (art2Ver == null || art2Ver.compareTo(depVer) < 0) continue;
                        art = art2;
                        break;
                    }
                    if (art != null) continue;
                    for (k = 0; k < availCount; ++k) {
                        String factVersion3;
                        Artifact availArt2 = this.artifactTableModel.getArtifactAt(k);
                        if (!depName.equals(availArt2.getName()) || !this.artifactTableModel.isArtifactEnabled(k) || ((factVersion3 = availArt2.getVersion()) == null ? depVer != null : depVer != null && factVersion3.compareTo(depVer) < 0)) continue;
                        this.artifactTableModel.selectArtifact(k, true, false);
                    }
                }
            }
        }
        this.refreshSelectedArtifactInfo();
    }

    protected class ArtifactSelectionListener
    implements ListSelectionListener {
        private boolean adjusting = false;

        protected ArtifactSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent ev) {
            if (this.adjusting) {
                return;
            }
            if (ev.getValueIsAdjusting()) {
                return;
            }
            try {
                this.adjusting = true;
                int first = ev.getFirstIndex();
                int last = ev.getLastIndex();
                int selCount = 0;
                for (int i = first; i <= last; ++i) {
                    if (!InstallationArtifactTablePanel.this.artifactTableModel.isArtifactChecked(i)) continue;
                    ++selCount;
                }
                if (selCount > 0) {
                    boolean autoResolve = InstallationArtifactTablePanel.this.getJCheckBoxArtifactsResolve().isSelected();
                    boolean resolveOptional = InstallationArtifactTablePanel.this.getJCheckBoxArtifactsResolveOptional().isSelected();
                    if (autoResolve) {
                        ArrayList<Artifact> arts = new ArrayList<Artifact>();
                        for (int i = first; i <= last; ++i) {
                            Artifact art;
                            if (!InstallationArtifactTablePanel.this.artifactTableModel.isArtifactChecked(i) || (art = InstallationArtifactTablePanel.this.artifactTableModel.getArtifactAt(i)) == null) continue;
                            arts.add(art);
                        }
                        while (!arts.isEmpty()) {
                            Artifact fact = (Artifact)arts.remove(0);
                            int deps = fact.getDependencyCount();
                            for (int k = 0; k < deps; ++k) {
                                ArtifactDependency dep = fact.getDependencyAt(k);
                                if (dep == null || !resolveOptional && dep.isOptional()) continue;
                                InstallationArtifactTablePanel.this.resolveDependency(dep, arts);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                this.adjusting = false;
            }
            InstallationArtifactTablePanel.this.refreshSelectedArtifactInfo();
        }
    }
}

