/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.swing.InstallerBanner;
import com.spacekiller.infection.swing.InstallerPagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InstallationSiteAddPanel
extends InstallerPagePanel {
    private static final long serialVersionUID = 851822591002092644L;
    private static final Logger logger = Logger.getLogger(InstallationSiteAddPanel.class.getName());
    private JPanel jPanel17 = null;
    private JPanel jPanel18 = null;
    private JLabel jLabel8 = null;
    private JButton jButtonCancelAddSite = null;
    private JButton jButtonAddSite = null;
    private JTextField jTextFieldAddURL = null;
    private JPanel jPanel19 = null;
    private JButton jButtonBrowseSite = null;
    private JButton jButtonPasteSite = null;
    private InstallerBanner infectionBanner;

    public InstallationSiteAddPanel() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.insets = new Insets(0, 0, 4, 0);
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridy = 1;
        GridBagConstraints gridBagConstraints62 = new GridBagConstraints();
        gridBagConstraints62.anchor = 11;
        gridBagConstraints62.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints62.gridx = 0;
        gridBagConstraints62.gridy = 1;
        gridBagConstraints62.weightx = 1.0;
        gridBagConstraints62.weighty = 1.0;
        gridBagConstraints62.fill = 2;
        GridBagConstraints gridBagConstraints48 = new GridBagConstraints();
        gridBagConstraints48.anchor = 13;
        gridBagConstraints48.gridx = 0;
        gridBagConstraints48.gridy = 2;
        gridBagConstraints48.insets = new Insets(4, 4, 4, 4);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(509, 344));
        GridBagConstraints gbc_infectionBanner = new GridBagConstraints();
        gbc_infectionBanner.fill = 2;
        gbc_infectionBanner.gridx = 0;
        gbc_infectionBanner.gridy = 0;
        this.add((Component)this.getInfectionBanner(), gbc_infectionBanner);
        this.add((Component)this.getJPanel17(), gridBagConstraints48);
        this.add((Component)this.getJPanel18(), gridBagConstraints62);
    }

    private JPanel getJPanel17() {
        if (this.jPanel17 == null) {
            GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
            gridBagConstraints61.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints61.gridx = 0;
            gridBagConstraints61.gridy = 0;
            GridBagConstraints gridBagConstraints43 = new GridBagConstraints();
            gridBagConstraints43.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints43.gridy = 0;
            gridBagConstraints43.gridx = 1;
            this.jPanel17 = new JPanel();
            this.jPanel17.setLayout(new GridBagLayout());
            this.jPanel17.add((Component)this.getJButtonCancelAddSite(), gridBagConstraints43);
            this.jPanel17.add((Component)this.getJButtonAddSite(), gridBagConstraints61);
        }
        return this.jPanel17;
    }

    private JPanel getJPanel18() {
        if (this.jPanel18 == null) {
            GridBagConstraints gridBagConstraints59 = new GridBagConstraints();
            gridBagConstraints59.anchor = 17;
            gridBagConstraints59.gridx = 0;
            gridBagConstraints59.gridy = 0;
            gridBagConstraints59.insets = new Insets(4, 4, 5, 4);
            this.jLabel8 = new JLabel();
            this.jLabel8.setText("URL or file path:");
            this.jPanel18 = new JPanel();
            this.jPanel18.setLayout(new GridBagLayout());
            this.jPanel18.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanel18.add((Component)this.jLabel8, gridBagConstraints59);
            GridBagConstraints gridBagConstraints60 = new GridBagConstraints();
            gridBagConstraints60.fill = 2;
            gridBagConstraints60.gridy = 1;
            gridBagConstraints60.weightx = 1.0;
            gridBagConstraints60.insets = new Insets(4, 4, 5, 0);
            gridBagConstraints60.gridx = 0;
            this.jPanel18.add((Component)this.getJTextFieldAddURL(), gridBagConstraints60);
            GridBagConstraints gridBagConstraints65 = new GridBagConstraints();
            gridBagConstraints65.gridx = 0;
            gridBagConstraints65.anchor = 13;
            gridBagConstraints65.gridy = 2;
            this.jPanel18.add((Component)this.getJPanel19(), gridBagConstraints65);
        }
        return this.jPanel18;
    }

    private JButton getJButtonCancelAddSite() {
        if (this.jButtonCancelAddSite == null) {
            this.jButtonCancelAddSite = new JButton();
            this.jButtonCancelAddSite.setEnabled(true);
            this.jButtonCancelAddSite.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonCancelAddSite.setText("Cancel");
            this.jButtonCancelAddSite.setToolTipText("");
            this.jButtonCancelAddSite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteAddPanel.this.actionBack();
                }
            });
        }
        return this.jButtonCancelAddSite;
    }

    private JButton getJButtonAddSite() {
        if (this.jButtonAddSite == null) {
            this.jButtonAddSite = new JButton();
            this.jButtonAddSite.setEnabled(true);
            this.jButtonAddSite.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonAddSite.setText("Add");
            this.jButtonAddSite.setToolTipText("Add update site");
            this.jButtonAddSite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteAddPanel.this.actionConfirm();
                }
            });
        }
        return this.jButtonAddSite;
    }

    private JTextField getJTextFieldAddURL() {
        if (this.jTextFieldAddURL == null) {
            this.jTextFieldAddURL = new JTextField();
            this.jTextFieldAddURL.setColumns(40);
            this.jTextFieldAddURL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteAddPanel.this.getJButtonAddSite().doClick();
                }
            });
        }
        return this.jTextFieldAddURL;
    }

    private JPanel getJPanel19() {
        if (this.jPanel19 == null) {
            GridBagConstraints gridBagConstraints64 = new GridBagConstraints();
            gridBagConstraints64.gridx = 0;
            gridBagConstraints64.insets = new Insets(0, 0, 4, 5);
            gridBagConstraints64.gridy = 0;
            GridBagConstraints gridBagConstraints63 = new GridBagConstraints();
            gridBagConstraints63.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints63.gridy = 0;
            gridBagConstraints63.gridx = 1;
            this.jPanel19 = new JPanel();
            this.jPanel19.setLayout(new GridBagLayout());
            this.jPanel19.add((Component)this.getJButtonBrowseSite(), gridBagConstraints63);
            this.jPanel19.add((Component)this.getJButtonPasteSite(), gridBagConstraints64);
        }
        return this.jPanel19;
    }

    private JButton getJButtonBrowseSite() {
        if (this.jButtonBrowseSite == null) {
            this.jButtonBrowseSite = new JButton();
            this.jButtonBrowseSite.setEnabled(true);
            this.jButtonBrowseSite.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonBrowseSite.setText("Browse");
            this.jButtonBrowseSite.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/search.gif")));
            this.jButtonBrowseSite.setToolTipText("Browse file system...");
            this.jButtonBrowseSite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteAddPanel.this.actionSiteBrowse();
                }
            });
        }
        return this.jButtonBrowseSite;
    }

    private JButton getJButtonPasteSite() {
        if (this.jButtonPasteSite == null) {
            this.jButtonPasteSite = new JButton();
            this.jButtonPasteSite.setEnabled(true);
            this.jButtonPasteSite.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/paste_edit.gif")));
            this.jButtonPasteSite.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonPasteSite.setText("Paste");
            this.jButtonPasteSite.setToolTipText("Paste URL from clipboard..");
            this.jButtonPasteSite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteAddPanel.this.actionSitePaste();
                }
            });
        }
        return this.jButtonPasteSite;
    }

    public InstallerBanner getInfectionBanner() {
        if (this.infectionBanner == null) {
            this.infectionBanner = new InstallerBanner();
            this.infectionBanner.setTitle("Add Update Site");
            this.infectionBanner.setForeground(Color.WHITE);
        }
        return this.infectionBanner;
    }

    @Override
    protected synchronized void refresh() {
        this.decorateBanner(this.getInfectionBanner());
    }

    protected void actionSiteBrowse() {
        try {
            File file;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Browse update site (index.xml)");
            fileChooser.setDialogType(0);
            fileChooser.setFileSelectionMode(2);
            fileChooser.setMultiSelectionEnabled(false);
            int rc = fileChooser.showOpenDialog(null);
            if (rc == 0 && (file = fileChooser.getSelectedFile()) != null) {
                this.getJTextFieldAddURL().setText(file.getPath());
            }
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void actionSitePaste() {
        try {
            List list;
            String s = null;
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable trans = clip.getContents(this);
            if (trans == null) {
                return;
            }
            if (s == null && trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                s = (String)trans.getTransferData(DataFlavor.stringFlavor);
            }
            if (s == null && trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (list = (List)trans.getTransferData(DataFlavor.javaFileListFlavor)) != null && !list.isEmpty()) {
                s = list.get(0).toString();
            }
            if (s != null) {
                this.getJTextFieldAddURL().setText(s);
            }
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void actionConfirm() {
        String url = this.getJTextFieldAddURL().getText();
        if ((url = url.trim()).length() < 1) {
            return;
        }
        url = Infection.getAbsoluteSiteURL(url);
        try {
            InfectionSite site = new InfectionSite(url);
            site.setName(url);
            site.setRecursive(true);
            site.setPath(url);
            this.getPageContext().addUpdateSite(site);
            this.getPageContext().actionNext();
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void actionBack() {
        try {
            this.getPageContext().actionBack();
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }
}

