/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.install.InstallerPageContext;
import com.spacekiller.infection.swing.InstallerBanner;
import com.spacekiller.infection.swing.InstallerPagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class InstallationSiteTreePanel
extends InstallerPagePanel {
    private static final long serialVersionUID = 8260085091131579249L;
    private static final Logger logger = Logger.getLogger(InstallationSiteTreePanel.class.getName());
    private TreeModel siteTreeModel;
    private SiteChangeListener siteChangeListener = new SiteChangeListener();
    private InstallerPageContext siteChangeContext = null;
    private Icon iconQueued;
    private Icon iconProgress;
    private Icon iconAvailable;
    private Icon iconAvailablePartial;
    private Icon iconUnavailable;
    private JScrollPane jScrollPane = null;
    private JPanel jPanel3 = null;
    private JPanel jPanel5 = null;
    private JButton jButton = null;
    private JButton jButtonSourceNext = null;
    private JButton jButtonSourceSelectAll = null;
    private JButton jButtonSourceAdd = null;
    private JButton jButtonSourceRemove = null;
    private JButton jButtonSiteDefaults = null;
    private JButton jButtonProxy = null;
    private JTree jTreeSites = null;
    private JLabel jLabelSiteProgress = null;
    private InstallerBanner infectionBanner;

    public InstallationSiteTreePanel() {
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints17.anchor = 17;
        gridBagConstraints17.gridx = 0;
        gridBagConstraints17.gridy = 2;
        gridBagConstraints17.weightx = 1.0;
        gridBagConstraints17.fill = 2;
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = 0;
        gridBagConstraints15.fill = 1;
        gridBagConstraints15.gridy = 3;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.fill = 1;
        gridBagConstraints9.gridy = 1;
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.weighty = 1.0;
        gridBagConstraints9.insets = new Insets(4, 4, 5, 4);
        gridBagConstraints9.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(545, 397));
        GridBagConstraints gbc_infectionBanner = new GridBagConstraints();
        gbc_infectionBanner.fill = 2;
        gbc_infectionBanner.gridx = 0;
        gbc_infectionBanner.gridy = 0;
        this.add((Component)this.getInfectionBanner(), gbc_infectionBanner);
        this.add((Component)this.getJScrollPane(), gridBagConstraints9);
        this.add((Component)this.getJPanel3(), gridBagConstraints15);
        this.add((Component)this.getJPanel5(), gridBagConstraints17);
        this.initInfectionSitePanel();
    }

    protected void initInfectionSitePanel() {
        try {
            this.iconQueued = new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/blue-ball-small.gif"));
            this.iconProgress = new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/search.gif"));
            this.iconAvailable = new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/green-ball.gif"));
            this.iconAvailablePartial = new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/yellow-ball.gif"));
            this.iconUnavailable = new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/red-ball.gif"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.getJTreeSites().setCellRenderer(new SiteTreeCellRenderer());
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTreeSites());
        }
        return this.jScrollPane;
    }

    private JTree getJTreeSites() {
        if (this.jTreeSites == null) {
            this.jTreeSites = new JTree();
            this.jTreeSites.setRootVisible(false);
            this.jTreeSites.setOpaque(false);
            this.jTreeSites.setShowsRootHandles(true);
            this.jTreeSites.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    InstallationSiteTreePanel.this.handleTreeSelectionChanged();
                }
            });
        }
        return this.jTreeSites;
    }

    private JButton getJButtonSourceNext() {
        if (this.jButtonSourceNext == null) {
            this.jButtonSourceNext = new JButton();
            this.jButtonSourceNext.setText("Next >");
            this.jButtonSourceNext.setToolTipText("Select features...");
            this.jButtonSourceNext.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonSourceNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteTreePanel.this.actionSitesNext();
                }
            });
        }
        return this.jButtonSourceNext;
    }

    private JButton getJButtonSourceRemove() {
        if (this.jButtonSourceRemove == null) {
            this.jButtonSourceRemove = new JButton();
            this.jButtonSourceRemove.setMargin(new Insets(0, 4, 0, 4));
            this.jButtonSourceRemove.setEnabled(false);
            this.jButtonSourceRemove.setToolTipText("Remove the selected sites..");
            this.jButtonSourceRemove.setText("Remove");
            this.jButtonSourceRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteTreePanel.this.actionSiteRemove();
                }
            });
        }
        return this.jButtonSourceRemove;
    }

    private JButton getJButtonSourceSelectAll() {
        if (this.jButtonSourceSelectAll == null) {
            this.jButtonSourceSelectAll = new JButton();
            this.jButtonSourceSelectAll.setText("Select All");
            this.jButtonSourceSelectAll.setToolTipText("Select all update sites..");
            this.jButtonSourceSelectAll.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/select_all.gif")));
            this.jButtonSourceSelectAll.setMargin(new Insets(0, 4, 0, 4));
            this.jButtonSourceSelectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteTreePanel.this.selectAllSites();
                }
            });
        }
        return this.jButtonSourceSelectAll;
    }

    private JButton getJButtonSourceAdd() {
        if (this.jButtonSourceAdd == null) {
            this.jButtonSourceAdd = new JButton();
            this.jButtonSourceAdd.setMargin(new Insets(0, 4, 0, 4));
            this.jButtonSourceAdd.setEnabled(true);
            this.jButtonSourceAdd.setToolTipText("Add a custom update site to the list..");
            this.jButtonSourceAdd.setText("Add Site");
            this.jButtonSourceAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteTreePanel.this.actionSiteAdd();
                }
            });
        }
        return this.jButtonSourceAdd;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints58 = new GridBagConstraints();
            gridBagConstraints58.gridx = 0;
            gridBagConstraints58.insets = new Insets(4, 4, 4, 5);
            gridBagConstraints58.anchor = 16;
            gridBagConstraints58.gridy = 0;
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.add((Component)this.getJButton(), gridBagConstraints58);
            this.jPanel3.add((Component)this.getJButtonSourceNext(), gridBagConstraints1);
        }
        return this.jPanel3;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setMargin(new Insets(2, 4, 2, 4));
            this.jButton.setToolTipText("Back to previous page..");
            this.jButton.setText("< Back");
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteTreePanel.this.actionSitesPrev();
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButtonSiteDefaults() {
        if (this.jButtonSiteDefaults == null) {
            this.jButtonSiteDefaults = new JButton();
            this.jButtonSiteDefaults.setEnabled(true);
            this.jButtonSiteDefaults.setToolTipText("Reset default update sites");
            this.jButtonSiteDefaults.setMargin(new Insets(0, 4, 0, 4));
            this.jButtonSiteDefaults.setText("Defaults");
            this.jButtonSiteDefaults.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteTreePanel.this.actionSiteResetDefaults();
                }
            });
        }
        return this.jButtonSiteDefaults;
    }

    private JButton getJButtonProxy() {
        if (this.jButtonProxy == null) {
            this.jButtonProxy = new JButton();
            this.jButtonProxy.setText("Proxy");
            this.jButtonProxy.setMargin(new Insets(0, 4, 0, 4));
            this.jButtonProxy.setToolTipText("Configure proxy...");
            this.jButtonProxy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationSiteTreePanel.this.actionProxyConfig();
                }
            });
        }
        return this.jButtonProxy;
    }

    protected void handleTreeSelectionChanged() {
        int selNodes = this.getJTreeSites().getSelectionCount();
        boolean refreshSitesRunning = false;
        InstallerPageContext context = this.getPageContext();
        if (context != null) {
            refreshSitesRunning = context.isRefreshUpdateSitesRunning();
            String progressText = refreshSitesRunning ? "Loading sites, please wait..." : (selNodes > 0 ? "Click 'Next' to continue." : "Please select one or more sites.");
            this.jLabelSiteProgress.setText(progressText);
        }
        this.getJButtonSourceNext().setEnabled(selNodes > 0 && !refreshSitesRunning);
        InfectionSite[] selSites = this.getSelectedSites();
        this.getJButtonSourceRemove().setEnabled(selSites.length > 0);
    }

    @Override
    protected synchronized void refresh() {
        this.decorateBanner(this.getInfectionBanner());
        InstallerPageContext newContext = this.getPageContext();
        if (newContext != this.siteChangeContext) {
            if (this.siteChangeContext != null) {
                this.siteChangeContext.removeUpdateSiteChangeListener(this.siteChangeListener);
            }
            if (newContext != null) {
                newContext.addUpdateSiteChangeListener(this.siteChangeListener);
            }
        }
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 4;
            gridBagConstraints7.insets = new Insets(4, 0, 4, 5);
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints72 = new GridBagConstraints();
            gridBagConstraints72.gridx = 2;
            gridBagConstraints72.insets = new Insets(4, 0, 4, 5);
            gridBagConstraints72.gridy = 0;
            GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
            gridBagConstraints71.gridx = 5;
            gridBagConstraints71.weightx = 1.0;
            gridBagConstraints71.fill = 2;
            gridBagConstraints71.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints71.gridy = 0;
            this.jLabelSiteProgress = new JLabel();
            this.jLabelSiteProgress.setText("Please wait...");
            this.jLabelSiteProgress.setHorizontalAlignment(4);
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 3;
            gridBagConstraints19.insets = new Insets(4, 0, 4, 5);
            gridBagConstraints19.gridy = 0;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 1;
            gridBagConstraints18.insets = new Insets(4, 0, 4, 5);
            gridBagConstraints18.gridy = 0;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.insets = new Insets(4, 4, 4, 5);
            gridBagConstraints16.gridy = 0;
            gridBagConstraints16.gridx = -1;
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new GridBagLayout());
            this.jPanel5.add((Component)this.getJButtonSourceSelectAll(), gridBagConstraints16);
            this.jPanel5.add((Component)this.getJButtonSourceAdd(), gridBagConstraints18);
            this.jPanel5.add((Component)this.getJButtonSourceRemove(), gridBagConstraints19);
            this.jPanel5.add((Component)this.jLabelSiteProgress, gridBagConstraints71);
            this.jPanel5.add((Component)this.getJButtonSiteDefaults(), gridBagConstraints72);
            this.jPanel5.add((Component)this.getJButtonProxy(), gridBagConstraints7);
        }
        return this.jPanel5;
    }

    public InstallerBanner getInfectionBanner() {
        if (this.infectionBanner == null) {
            this.infectionBanner = new InstallerBanner();
            this.infectionBanner.setTitle("Update Sites");
            this.infectionBanner.setForeground(Color.WHITE);
        }
        return this.infectionBanner;
    }

    protected void actionSitesPrev() {
        this.getPageContext().actionBack();
    }

    protected void actionSitesNext() {
        this.getPageContext().actionNext();
    }

    protected void actionSiteResetDefaults() {
        try {
            this.getPageContext().resetDefaultUpdateSites();
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void actionSiteRemove() {
        try {
            TreePath[] paths = this.getJTreeSites().getSelectionPaths();
            if (paths != null) {
                for (int c = 0; c < paths.length; ++c) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[c].getLastPathComponent();
                    InfectionSite site = (InfectionSite)node.getUserObject();
                    if (site == null) continue;
                    this.getPageContext().removeUpdateSite(site);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void actionSiteAdd() {
        try {
            this.getPageContext().showSitesAddPage();
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void actionProxyConfig() {
        try {
            this.getPageContext().showSitesProxyPage();
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void selectAllSites() {
        int rowCount = this.getJTreeSites().getRowCount();
        logger.info("selectAllSites: rowCount=" + rowCount);
        if (rowCount > 0) {
            this.getJTreeSites().setSelectionInterval(0, rowCount - 1);
        } else {
            this.getJTreeSites().clearSelection();
        }
    }

    protected InfectionSite[] getSelectedSites() {
        ArrayList<InfectionSite> sites = new ArrayList<InfectionSite>();
        TreePath[] paths = this.getJTreeSites().getSelectionPaths();
        if (paths != null) {
            for (int c = 0; c < paths.length; ++c) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[c].getLastPathComponent();
                Object obj = node.getUserObject();
                if (obj != null && obj instanceof InfectionSite) {
                    InfectionSite site = (InfectionSite)obj;
                    sites.add(site);
                    continue;
                }
                logger.warning("Invalid site tree node: " + obj);
            }
        }
        InfectionSite[] rc = new InfectionSite[sites.size()];
        rc = sites.toArray(rc);
        return rc;
    }

    public TreeModel getSiteTreeModel() {
        return this.siteTreeModel;
    }

    public synchronized void setSiteTreeModel(TreeModel newSiteTreeModel) {
        if (this.siteTreeModel == newSiteTreeModel) {
            return;
        }
        this.siteTreeModel = newSiteTreeModel;
        this.getJTreeSites().setModel(this.siteTreeModel);
    }

    protected class SiteChangeListener
    implements ChangeListener {
        protected SiteChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            InstallationSiteTreePanel.this.handleTreeSelectionChanged();
        }
    }

    protected class SiteTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 6514410638892804740L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object obj;
            Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            String text = "" + value;
            Icon icon = null;
            if (value instanceof DefaultMutableTreeNode && (obj = (node = (DefaultMutableTreeNode)value).getUserObject()) != null && obj instanceof InfectionSite) {
                InfectionSite site = (InfectionSite)obj;
                String siteName = site.getName();
                String sitePath = site.getPath();
                text = "" + siteName + "  (" + sitePath + ")";
                int state = 0;
                InstallerPageContext context = InstallationSiteTreePanel.this.getPageContext();
                if (context != null) {
                    state = context.getUpdateSiteState(site);
                }
                switch (state) {
                    case 1: {
                        icon = InstallationSiteTreePanel.this.iconUnavailable;
                        break;
                    }
                    case 2: {
                        icon = InstallationSiteTreePanel.this.iconQueued;
                        break;
                    }
                    case 3: {
                        icon = InstallationSiteTreePanel.this.iconProgress;
                        break;
                    }
                    case 4: {
                        icon = InstallationSiteTreePanel.this.iconUnavailable;
                        break;
                    }
                    case 5: {
                        icon = InstallationSiteTreePanel.this.iconAvailablePartial;
                        break;
                    }
                    case 6: {
                        icon = InstallationSiteTreePanel.this.iconAvailable;
                    }
                }
            }
            this.setText(text);
            this.setIcon(icon);
            return comp;
        }
    }
}

