/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionUtil;
import com.spacekiller.infection.log.Log2ConsoleAsyncHandler;
import com.spacekiller.infection.log.Log2ConsoleHandler;
import com.spacekiller.infection.log.Log2FileAsyncHandler;
import com.spacekiller.infection.log.Log2FileHandler;
import com.spacekiller.infection.log.Log2TraceAsyncHandler;
import com.spacekiller.infection.log.Log2TraceHandler;
import com.spacekiller.infection.log.LogFileOptions;
import com.spacekiller.infection.log.LoggingConfig;
import com.spacekiller.infection.swing.LogFileOptionsPanel;
import com.spacekiller.infection.swing.LoggingConfigPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InstanceLoggingEditor
extends JPanel {
    private static final long serialVersionUID = -3730464404098319677L;
    private static final String LOG_TO_SYSTEM_OUT = "System.out";
    private static final String LOG_TO_SYSTEM_ERR = "System.err";
    private static final Logger logger = Logger.getLogger(InstanceLoggingEditor.class.getName());
    private InfectionInstallation installation;
    private InfectionIndex index;
    private InfectionInstance instance;
    private LoggingConfig loggingConfig;
    private boolean refreshing;
    private boolean includeRegisteredLoggers;
    private DefaultListModel handlerListModel;
    private LogFileOptions logFileOptions;
    private LogFileOptions traceFileOptions;
    private LoggingConfigPanel loggingConfigPanel = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanel = null;
    private JCheckBox jCheckBoxLog2Console = null;
    private JCheckBox jCheckBoxLog2File = null;
    private JCheckBox jCheckBoxLog2Trace = null;
    private JPanel jPanelHandlers = null;
    private JComboBox jComboBoxConsoleStream = null;
    private JPanel jPanel1 = null;
    private JScrollPane jScrollPane = null;
    private JList jListHandlers = null;
    private JPanel panelHandlerActions;
    private JButton btnHandlerAdd;
    private JButton btnHandlerRemove;
    private JButton btnLogFileOptions;
    private JButton btnTraceFileOptions;
    private JTextField textFieldLogFile;
    private JTextField textFieldTraceFile;
    private JPanel panel_1;
    private JCheckBox chckbxConsoleSync;

    public InstanceLoggingEditor() {
        this.initialize();
        this.initInfectionInstanceLoggingEditor();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(1);
        this.setLayout(gridLayout);
        this.setSize(new Dimension(539, 414));
        this.add((Component)this.getJTabbedPane(), null);
    }

    private LoggingConfigPanel getLoggingConfigPanel() {
        if (this.loggingConfigPanel == null) {
            this.loggingConfigPanel = new LoggingConfigPanel();
            this.loggingConfigPanel.setOpaque(true);
        }
        return this.loggingConfigPanel;
    }

    public InfectionIndex getIndex() {
        return this.index;
    }

    public void setIndex(InfectionIndex index) {
        this.index = index;
    }

    public InfectionInstance getInstance() {
        return this.instance;
    }

    public void setInstance(InfectionInstance instance) {
        this.instance = instance;
    }

    public void refreshAsync() {
        this.getLoggingConfigPanel().setLoggingConfig(null);
        new Thread(new Runnable(){

            @Override
            public void run() {
                InstanceLoggingEditor.this.refresh();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        LogManager man;
        String name;
        try {
            this.refreshing = true;
            this.handlerListModel.removeAllElements();
            InfectionInstance instance = this.instance;
            if (instance != null) {
                Properties props = instance.getLoggingProperties();
                String handlers = props.getProperty("handlers");
                if (handlers == null) {
                    handlers = "";
                }
                StringTokenizer tok = new StringTokenizer(handlers);
                while (tok.hasMoreTokens()) {
                    String handler = tok.nextToken();
                    if (handler.length() < 1) continue;
                    this.handlerListModel.addElement(handler);
                }
                this.logFileOptions = LogFileOptions.createDefaultLogFileOptions();
                this.logFileOptions.setProperties(props, "Log2FileHandler.");
                this.traceFileOptions = LogFileOptions.createDefaultTraceFileOptions();
                this.traceFileOptions.setProperties(props, "Log2TraceHandler.");
            }
        }
        finally {
            this.refreshing = false;
        }
        this.handlerListChanged();
        final LoggingConfig config = new LoggingConfig();
        ArrayList classes = new ArrayList();
        this.enumerateAvailableClasses(classes);
        HashSet<String> packages = new HashSet<String>();
        for (String clazz : classes) {
            int x;
            if (clazz == null || (x = clazz.lastIndexOf(46)) < 0) continue;
            String pkg = clazz.substring(0, x);
            if (packages.add(pkg)) {
                config.setPackageLevel(pkg, null);
            }
            config.setLoggerLevel(clazz, null);
        }
        if (this.instance != null) {
            Iterator i = this.instance.getLoggers();
            while (i.hasNext()) {
                name = (String)i.next();
                String levelName = this.instance.getLoggerLevel(name);
                Level level = config.resolveLevel(levelName);
                if (packages.contains(name)) {
                    config.setPackageLevel(name, level);
                    continue;
                }
                config.setLoggerLevel(name, level);
            }
        }
        if (this.includeRegisteredLoggers && (man = LogManager.getLogManager()) != null) {
            Enumeration<String> en = man.getLoggerNames();
            while (en.hasMoreElements()) {
                name = en.nextElement();
                Logger lgg = man.getLogger(name);
                if (lgg == null) continue;
                Level level = lgg.getLevel();
                if (packages.contains(name)) {
                    config.setPackageLevel(name, level);
                    continue;
                }
                config.setLoggerLevel(name, level);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstanceLoggingEditor.this.setLoggingConfig(config);
            }
        });
    }

    public LoggingConfig getLoggingConfig() {
        return this.loggingConfig;
    }

    public void setLoggingConfig(LoggingConfig loggingConfig) {
        this.loggingConfig = loggingConfig;
        this.getLoggingConfigPanel().setLoggingConfig(loggingConfig);
    }

    protected void enumerateAvailableClasses(Collection dstClasses) {
        InfectionInstance instance = this.instance;
        if (instance == null) {
            return;
        }
        InfectionIndex index = this.index;
        if (index == null) {
            return;
        }
        InfectionInstallation installation = this.installation;
        if (installation == null) {
            return;
        }
        File indexDir = installation.getIndexDirectory();
        ArrayList<File> jars = new ArrayList<File>();
        int artifactCount = instance.getArtifactCount();
        for (int i = 0; i < artifactCount; ++i) {
            String artVersion;
            String artName;
            Artifact art;
            Artifact fact = instance.getArtifactAt(i);
            if (fact == null || (art = index.getArtifact(artName = fact.getName(), artVersion = fact.getVersion())) == null) continue;
            String path = art.getPath();
            File artFile = new File(path);
            if ((artFile = InfectionUtil.getAbsoluteFile(artFile, indexDir)).exists() && !"unzip".equals(art.getDeploy())) {
                jars.add(artFile);
            }
            File artDir = artFile.getParentFile();
            int artCPs = art.getClassPathEntryCount();
            for (int k = 0; k < artCPs; ++k) {
                String artCP = art.getClassPathEntryAt(k);
                File f = new File(artDir, artCP);
                if (!f.exists()) continue;
                jars.add(f);
            }
        }
        int cpCount = instance.getClassPathCount();
        for (int i = 0; i < cpCount; ++i) {
            String path = instance.getClassPathAt(i);
            File file = new File(path);
            jars.add(file);
        }
        for (File file : jars) {
            try {
                if (!file.exists() || file.isDirectory()) continue;
                this.enumerateJavaClasses(file, dstClasses);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enumerateJavaClasses(File file, Collection dstClasses) throws Exception {
        if (file == null) {
            return;
        }
        logger.fine("Scanning: " + file);
        ZipFile zip = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze = en.nextElement();
                String name = ze.getName();
                if (!name.endsWith(".class")) continue;
                name = name.substring(0, name.length() - 6);
                name = name.replace('/', '.');
                dstClasses.add(name);
            }
        }
        finally {
            zip.close();
        }
    }

    public InfectionInstallation getInstallation() {
        return this.installation;
    }

    public void setInstallation(InfectionInstallation installation) {
        this.installation = installation;
    }

    protected void initInfectionInstanceLoggingEditor() {
        this.handlerListModel = new DefaultListModel();
        this.getJListHandlers().setModel(this.handlerListModel);
        this.getJComboBoxConsoleStream().addItem(LOG_TO_SYSTEM_OUT);
        this.getJComboBoxConsoleStream().addItem(LOG_TO_SYSTEM_ERR);
        this.getLoggingConfigPanel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InstanceLoggingEditor.this.applyLoggerLevels();
            }
        });
        this.checkEnable();
    }

    protected void applyLoggerLevels() {
        Level level;
        String name;
        LoggingConfig config = this.loggingConfig;
        if (config == null) {
            return;
        }
        InfectionInstance instance = this.instance;
        if (instance == null) {
            return;
        }
        instance.clearLoggerLevels();
        Iterator i = config.getLoggers();
        while (i.hasNext()) {
            name = (String)i.next();
            level = config.getLoggerLevel(name);
            if (level == null) continue;
            instance.setLoggerLevel(name, level.getName());
        }
        i = config.getPackages();
        while (i.hasNext()) {
            name = (String)i.next();
            level = config.getPackageLevel(name);
            if (level == null) continue;
            instance.setLoggerLevel(name, level.getName());
        }
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Options", new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/logging.png")), this.getJPanel(), "Logging options");
            this.jTabbedPane.addTab("Levels", new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/log_warning.png")), this.getLoggingConfigPanel(), "Logger detail levels");
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.weightx = 1.0;
            gridBagConstraints31.weighty = 0.0;
            gridBagConstraints31.fill = 1;
            gridBagConstraints31.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints31.gridy = 0;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 0;
            gridBagConstraints21.gridy = 1;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.gridx = 1;
            GridBagConstraints gbc_jPanelHandlers = new GridBagConstraints();
            gbc_jPanelHandlers.gridx = 0;
            gbc_jPanelHandlers.weightx = 1.0;
            gbc_jPanelHandlers.weighty = 1.0;
            gbc_jPanelHandlers.fill = 1;
            gbc_jPanelHandlers.insets = new Insets(0, 4, 4, 4);
            gbc_jPanelHandlers.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 1;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setOpaque(true);
            this.jPanel.add((Component)this.getJPanelHandlers(), gbc_jPanelHandlers);
            this.jPanel.add((Component)this.getJPanel1(), gridBagConstraints31);
        }
        return this.jPanel;
    }

    private JCheckBox getJCheckBoxLog2Console() {
        if (this.jCheckBoxLog2Console == null) {
            this.jCheckBoxLog2Console = new JCheckBox();
            this.jCheckBoxLog2Console.setText("Console:");
            this.jCheckBoxLog2Console.setToolTipText("Log to system output stream ?");
            this.jCheckBoxLog2Console.setOpaque(false);
            this.jCheckBoxLog2Console.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!InstanceLoggingEditor.this.refreshing) {
                        InstanceLoggingEditor.this.applyLoggingOptions();
                        InstanceLoggingEditor.this.handlerOptionsChanged();
                    }
                    InstanceLoggingEditor.this.checkEnable();
                }
            });
        }
        return this.jCheckBoxLog2Console;
    }

    private JCheckBox getJCheckBoxLog2File() {
        if (this.jCheckBoxLog2File == null) {
            this.jCheckBoxLog2File = new JCheckBox();
            this.jCheckBoxLog2File.setText("Log file:");
            this.jCheckBoxLog2File.setToolTipText("Log to file ?");
            this.jCheckBoxLog2File.setOpaque(false);
            this.jCheckBoxLog2File.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!InstanceLoggingEditor.this.refreshing) {
                        InstanceLoggingEditor.this.applyLoggingOptions();
                        InstanceLoggingEditor.this.handlerOptionsChanged();
                    }
                    InstanceLoggingEditor.this.checkEnable();
                }
            });
        }
        return this.jCheckBoxLog2File;
    }

    private JCheckBox getJCheckBoxLog2Trace() {
        if (this.jCheckBoxLog2Trace == null) {
            this.jCheckBoxLog2Trace = new JCheckBox();
            this.jCheckBoxLog2Trace.setText("Trace file:");
            this.jCheckBoxLog2Trace.setToolTipText("Log to binary trace file ?");
            this.jCheckBoxLog2Trace.setOpaque(false);
            this.jCheckBoxLog2Trace.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!InstanceLoggingEditor.this.refreshing) {
                        InstanceLoggingEditor.this.applyLoggingOptions();
                        InstanceLoggingEditor.this.handlerOptionsChanged();
                    }
                    InstanceLoggingEditor.this.checkEnable();
                }
            });
        }
        return this.jCheckBoxLog2Trace;
    }

    private JPanel getJPanelHandlers() {
        if (this.jPanelHandlers == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints6.gridx = 0;
            this.jPanelHandlers = new JPanel();
            GridBagLayout gbl_jPanelHandlers = new GridBagLayout();
            gbl_jPanelHandlers.rowWeights = new double[]{0.0};
            gbl_jPanelHandlers.columnWeights = new double[]{1.0, 0.0};
            this.jPanelHandlers.setLayout(gbl_jPanelHandlers);
            this.jPanelHandlers.setOpaque(false);
            this.jPanelHandlers.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Handlers", 4, 2, null, null));
            this.jPanelHandlers.add((Component)this.getJScrollPane(), gridBagConstraints6);
            GridBagConstraints gbc_panelHandlerActions = new GridBagConstraints();
            gbc_panelHandlerActions.insets = new Insets(4, 0, 4, 4);
            gbc_panelHandlerActions.fill = 1;
            gbc_panelHandlerActions.gridx = 1;
            gbc_panelHandlerActions.gridy = 0;
            this.jPanelHandlers.add((Component)this.getPanelHandlerActions(), gbc_panelHandlerActions);
        }
        return this.jPanelHandlers;
    }

    private JComboBox getJComboBoxConsoleStream() {
        if (this.jComboBoxConsoleStream == null) {
            this.jComboBoxConsoleStream = new JComboBox();
            this.jComboBoxConsoleStream.setOpaque(false);
            this.jComboBoxConsoleStream.setToolTipText("Console output stream");
            this.jComboBoxConsoleStream.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!InstanceLoggingEditor.this.refreshing) {
                        InstanceLoggingEditor.this.applyLoggingOptions();
                    }
                }
            });
        }
        return this.jComboBoxConsoleStream;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.insets = new Insets(4, 4, 5, 5);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.insets = new Insets(4, 4, 5, 5);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 0;
            this.jPanel1 = new JPanel();
            GridBagLayout gbl_jPanel1 = new GridBagLayout();
            gbl_jPanel1.columnWeights = new double[]{0.0, 1.0, 0.0};
            this.jPanel1.setLayout(gbl_jPanel1);
            this.jPanel1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Logging", 4, 2, null, new Color(51, 51, 51)));
            this.jPanel1.add((Component)this.getJCheckBoxLog2Console(), gridBagConstraints4);
            GridBagConstraints gbc_panel_1 = new GridBagConstraints();
            gbc_panel_1.fill = 1;
            gbc_panel_1.insets = new Insets(4, 4, 5, 5);
            gbc_panel_1.gridx = 1;
            gbc_panel_1.gridy = 0;
            this.jPanel1.add((Component)this.getPanel_1(), gbc_panel_1);
            this.jPanel1.add((Component)this.getJCheckBoxLog2File(), gridBagConstraints1);
            GridBagConstraints gbc_textFieldLogFile = new GridBagConstraints();
            gbc_textFieldLogFile.insets = new Insets(4, 4, 5, 5);
            gbc_textFieldLogFile.fill = 2;
            gbc_textFieldLogFile.gridx = 1;
            gbc_textFieldLogFile.gridy = 1;
            this.jPanel1.add((Component)this.getTextFieldLogFile(), gbc_textFieldLogFile);
            GridBagConstraints gbc_btnLogFileOptions = new GridBagConstraints();
            gbc_btnLogFileOptions.anchor = 17;
            gbc_btnLogFileOptions.insets = new Insets(4, 4, 5, 4);
            gbc_btnLogFileOptions.gridx = 2;
            gbc_btnLogFileOptions.gridy = 1;
            this.jPanel1.add((Component)this.getBtnLogFileOptions(), gbc_btnLogFileOptions);
            this.jPanel1.add((Component)this.getJCheckBoxLog2Trace(), gridBagConstraints2);
            GridBagConstraints gbc_textFieldTraceFile = new GridBagConstraints();
            gbc_textFieldTraceFile.insets = new Insets(4, 4, 5, 5);
            gbc_textFieldTraceFile.fill = 2;
            gbc_textFieldTraceFile.gridx = 1;
            gbc_textFieldTraceFile.gridy = 2;
            this.jPanel1.add((Component)this.getTextFieldTraceFile(), gbc_textFieldTraceFile);
            GridBagConstraints gbc_btnTraceFileOptions = new GridBagConstraints();
            gbc_btnTraceFileOptions.insets = new Insets(4, 4, 5, 4);
            gbc_btnTraceFileOptions.anchor = 17;
            gbc_btnTraceFileOptions.gridx = 2;
            gbc_btnTraceFileOptions.gridy = 2;
            this.jPanel1.add((Component)this.getBtnTraceFileOptions(), gbc_btnTraceFileOptions);
        }
        return this.jPanel1;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJListHandlers());
        }
        return this.jScrollPane;
    }

    private JList getJListHandlers() {
        if (this.jListHandlers == null) {
            this.jListHandlers = new JList();
            this.jListHandlers.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    InstanceLoggingEditor.this.getBtnHandlerRemove().setEnabled(InstanceLoggingEditor.this.jListHandlers.getSelectedIndices().length > 0);
                }
            });
            this.jListHandlers.setOpaque(false);
        }
        return this.jListHandlers;
    }

    protected void checkEnable() {
        this.getJComboBoxConsoleStream().setEnabled(this.getJCheckBoxLog2Console().isSelected());
        this.getChckbxConsoleSync().setEnabled(this.getJCheckBoxLog2Console().isSelected());
        this.getTextFieldLogFile().setEnabled(this.getJCheckBoxLog2File().isSelected());
        this.getBtnLogFileOptions().setEnabled(this.getJCheckBoxLog2File().isSelected());
        this.getTextFieldTraceFile().setEnabled(this.getJCheckBoxLog2Trace().isSelected());
        this.getBtnTraceFileOptions().setEnabled(this.getJCheckBoxLog2Trace().isSelected());
    }

    protected void applyLoggingOptions() {
        Object value;
        Object key;
        Properties props;
        if (this.instance == null) {
            return;
        }
        StringBuffer handlers = new StringBuffer();
        int num = this.handlerListModel.getSize();
        for (int i = 0; i < num; ++i) {
            Object item = this.handlerListModel.getElementAt(i);
            if (i > 0) {
                handlers.append(' ');
            }
            handlers.append(String.valueOf(item));
        }
        this.instance.setLoggingProperty("handlers", handlers.toString());
        Object consoleStreamItem = this.jComboBoxConsoleStream.getSelectedItem();
        if (this.logFileOptions != null && (props = this.logFileOptions.getProperties("")) != null) {
            for (Map.Entry<Object, Object> me : props.entrySet()) {
                key = me.getKey();
                value = me.getValue();
                if (key == null || value == null) continue;
                this.instance.setLoggingProperty("Log2FileHandler." + key, String.valueOf(value));
            }
        }
        if (this.traceFileOptions != null && (props = this.traceFileOptions.getProperties("")) != null) {
            for (Map.Entry<Object, Object> me : props.entrySet()) {
                key = me.getKey();
                value = me.getValue();
                if (key == null || value == null) continue;
                this.instance.setLoggingProperty("Log2TraceHandler." + key, String.valueOf(value));
            }
        }
    }

    public boolean isIncludeRegisteredLoggers() {
        return this.includeRegisteredLoggers;
    }

    public void setIncludeRegisteredLoggers(boolean includeRegisteredLoggers) {
        this.includeRegisteredLoggers = includeRegisteredLoggers;
    }

    private JPanel getPanelHandlerActions() {
        if (this.panelHandlerActions == null) {
            this.panelHandlerActions = new JPanel();
            GridBagLayout gbl_panelHandlerActions = new GridBagLayout();
            gbl_panelHandlerActions.columnWidths = new int[]{0, 0};
            gbl_panelHandlerActions.rowHeights = new int[]{0, 0, 0};
            gbl_panelHandlerActions.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelHandlerActions.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelHandlerActions.setLayout(gbl_panelHandlerActions);
            GridBagConstraints gbc_btnHandlerAdd = new GridBagConstraints();
            gbc_btnHandlerAdd.fill = 2;
            gbc_btnHandlerAdd.insets = new Insets(0, 0, 5, 0);
            gbc_btnHandlerAdd.gridx = 0;
            gbc_btnHandlerAdd.gridy = 0;
            this.panelHandlerActions.add((Component)this.getBtnHandlerAdd(), gbc_btnHandlerAdd);
            GridBagConstraints gbc_btnHandlerRemove = new GridBagConstraints();
            gbc_btnHandlerRemove.fill = 2;
            gbc_btnHandlerRemove.gridx = 0;
            gbc_btnHandlerRemove.gridy = 1;
            this.panelHandlerActions.add((Component)this.getBtnHandlerRemove(), gbc_btnHandlerRemove);
        }
        return this.panelHandlerActions;
    }

    private JButton getBtnHandlerAdd() {
        if (this.btnHandlerAdd == null) {
            this.btnHandlerAdd = new JButton("Add");
            this.btnHandlerAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceLoggingEditor.this.actionHandlerAdd();
                }
            });
            this.btnHandlerAdd.setToolTipText("Add custom handler...");
        }
        return this.btnHandlerAdd;
    }

    private JButton getBtnHandlerRemove() {
        if (this.btnHandlerRemove == null) {
            this.btnHandlerRemove = new JButton("Remove");
            this.btnHandlerRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceLoggingEditor.this.actionHandlerRemove();
                }
            });
            this.btnHandlerRemove.setToolTipText("Remove selected handler(s)");
        }
        return this.btnHandlerRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlerListChanged() {
        boolean log2Console = false;
        boolean log2ConsoleAsync = false;
        boolean log2File = false;
        boolean log2FileAsync = false;
        boolean log2Trace = false;
        boolean log2TraceAsync = false;
        int num = this.handlerListModel.getSize();
        for (int i = 0; i < num; ++i) {
            String handler = String.valueOf(this.handlerListModel.getElementAt(i));
            if (handler.equals(Log2ConsoleHandler.class.getName())) {
                log2Console = true;
                continue;
            }
            if (handler.equals(Log2ConsoleAsyncHandler.class.getName())) {
                log2ConsoleAsync = true;
                continue;
            }
            if (handler.equals(Log2FileHandler.class.getName())) {
                log2File = true;
                continue;
            }
            if (handler.equals(Log2FileAsyncHandler.class.getName())) {
                log2FileAsync = true;
                continue;
            }
            if (handler.equals(Log2TraceHandler.class.getName())) {
                log2Trace = true;
                continue;
            }
            if (!handler.equals(Log2TraceAsyncHandler.class.getName())) continue;
            log2TraceAsync = true;
        }
        String defaultLogDir = this.getDefaultLogDirectory();
        if (defaultLogDir == null) {
            defaultLogDir = "";
        }
        String logFilePath = null;
        if (this.logFileOptions != null) {
            String dir = this.logFileOptions.getDirectory();
            if (dir == null || dir.length() < 1) {
                dir = defaultLogDir;
            }
            if (dir.length() > 0 && !dir.endsWith(File.separator)) {
                dir = dir + File.separator;
            }
            logFilePath = dir + this.logFileOptions.getNamePrefix() + this.logFileOptions.getNameSuffix();
        }
        String traceFilePath = null;
        if (this.traceFileOptions != null) {
            String dir = this.traceFileOptions.getDirectory();
            if (dir == null || dir.length() < 1) {
                dir = defaultLogDir;
            }
            if (dir.length() > 0 && !dir.endsWith(File.separator)) {
                dir = dir + File.separator;
            }
            traceFilePath = dir + this.traceFileOptions.getNamePrefix() + this.traceFileOptions.getNameSuffix();
        }
        try {
            this.refreshing = true;
            this.getJCheckBoxLog2Console().setSelected(log2Console || log2ConsoleAsync);
            this.getChckbxConsoleSync().setSelected(log2Console);
            this.getJCheckBoxLog2File().setSelected(log2File || log2FileAsync);
            this.getJCheckBoxLog2Trace().setSelected(log2Trace || log2TraceAsync);
            this.getTextFieldLogFile().setText(logFilePath == null ? "" : logFilePath);
            this.getTextFieldTraceFile().setText(traceFilePath == null ? "" : traceFilePath);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void actionHandlerRemove() {
        int[] sel = this.getJListHandlers().getSelectedIndices();
        if (sel.length < 1) {
            return;
        }
        for (int i = sel.length - 1; i >= 0; --i) {
            this.handlerListModel.removeElementAt(sel[i]);
        }
        this.handlerListChanged();
    }

    protected void actionHandlerAdd() {
        String message = "Class Name:";
        String title = "Add Custom Handler";
        int messageType = 3;
        String handlerClassName = JOptionPane.showInputDialog(this, message, title, messageType);
        if (handlerClassName == null) {
            return;
        }
        if ((handlerClassName = handlerClassName.trim()).length() < 1) {
            return;
        }
        boolean handlerValid = false;
        Class<?> handlerClass = null;
        String errorMessage = null;
        try {
            handlerClass = Class.forName(handlerClassName);
            if (Handler.class.isAssignableFrom(handlerClass)) {
                handlerValid = true;
            } else {
                errorMessage = "Invalid handler class: " + handlerClassName;
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            errorMessage = "Class was not found: " + handlerClassName;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            errorMessage = e.getMessage();
        }
        if (!handlerValid) {
            message = String.valueOf(errorMessage);
            messageType = 0;
            JOptionPane.showMessageDialog(this, message, title, messageType);
            return;
        }
        this.handlerListModel.addElement(handlerClassName);
        this.handlerListChanged();
    }

    protected void handlerOptionsChanged() {
        boolean async;
        boolean log2Console = false;
        boolean log2ConsoleAsync = false;
        boolean log2File = false;
        boolean log2FileAsync = false;
        boolean log2Trace = false;
        boolean log2TraceAsync = false;
        if (this.getJCheckBoxLog2Console().isSelected()) {
            boolean bl = async = !this.chckbxConsoleSync.isSelected();
            if (async) {
                log2ConsoleAsync = true;
            } else {
                log2Console = true;
            }
        }
        if (this.getJCheckBoxLog2File().isSelected()) {
            async = this.logFileOptions.isAsync();
            if (async) {
                log2FileAsync = true;
            } else {
                log2File = true;
            }
        }
        if (this.getJCheckBoxLog2Trace().isSelected()) {
            async = this.traceFileOptions.isAsync();
            if (async) {
                log2TraceAsync = true;
            } else {
                log2Trace = true;
            }
        }
        String handler = Log2TraceAsyncHandler.class.getName();
        this.removeHandler(handler);
        if (log2TraceAsync) {
            this.handlerListModel.insertElementAt(handler, 0);
        }
        handler = Log2TraceHandler.class.getName();
        this.removeHandler(handler);
        if (log2Trace) {
            this.handlerListModel.insertElementAt(handler, 0);
        }
        handler = Log2FileAsyncHandler.class.getName();
        this.removeHandler(handler);
        if (log2FileAsync) {
            this.handlerListModel.insertElementAt(handler, 0);
        }
        handler = Log2FileHandler.class.getName();
        this.removeHandler(handler);
        if (log2File) {
            this.handlerListModel.insertElementAt(handler, 0);
        }
        handler = Log2ConsoleAsyncHandler.class.getName();
        this.removeHandler(handler);
        if (log2ConsoleAsync) {
            this.handlerListModel.insertElementAt(handler, 0);
        }
        handler = Log2ConsoleHandler.class.getName();
        this.removeHandler(handler);
        if (log2Console) {
            this.handlerListModel.insertElementAt(handler, 0);
        }
    }

    protected void removeHandler(String handler) {
        if (handler == null) {
            return;
        }
        int num = this.handlerListModel.getSize();
        for (int i = num - 1; i >= 0; --i) {
            Object item = this.handlerListModel.getElementAt(i);
            if (!handler.equals(String.valueOf(item))) continue;
            this.handlerListModel.removeElementAt(i);
        }
    }

    private JButton getBtnLogFileOptions() {
        if (this.btnLogFileOptions == null) {
            this.btnLogFileOptions = new JButton("Options");
            this.btnLogFileOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceLoggingEditor.this.showLogFileOptionsDialog();
                }
            });
        }
        return this.btnLogFileOptions;
    }

    private JButton getBtnTraceFileOptions() {
        if (this.btnTraceFileOptions == null) {
            this.btnTraceFileOptions = new JButton("Options");
            this.btnTraceFileOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceLoggingEditor.this.showTraceFileOptionsDialog();
                }
            });
        }
        return this.btnTraceFileOptions;
    }

    private JTextField getTextFieldLogFile() {
        if (this.textFieldLogFile == null) {
            this.textFieldLogFile = new JTextField();
            this.textFieldLogFile.setEditable(false);
            this.textFieldLogFile.setOpaque(false);
            this.textFieldLogFile.setColumns(10);
        }
        return this.textFieldLogFile;
    }

    private JTextField getTextFieldTraceFile() {
        if (this.textFieldTraceFile == null) {
            this.textFieldTraceFile = new JTextField();
            this.textFieldTraceFile.setEditable(false);
            this.textFieldTraceFile.setOpaque(false);
            this.textFieldTraceFile.setColumns(10);
        }
        return this.textFieldTraceFile;
    }

    protected void showLogFileOptionsDialog() {
        LogFileOptions options = null;
        if (this.logFileOptions != null) {
            try {
                options = this.logFileOptions.cloneLogFileOptions();
            }
            catch (CloneNotSupportedException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (options == null) {
            options = new LogFileOptions();
        }
        if (this.showLogFileOptionsDialog("Log File Options", options)) {
            this.logFileOptions = options;
            this.handlerOptionsChanged();
            this.handlerListChanged();
        }
    }

    protected void showTraceFileOptionsDialog() {
        LogFileOptions options = null;
        if (this.traceFileOptions != null) {
            try {
                options = this.traceFileOptions.cloneLogFileOptions();
            }
            catch (CloneNotSupportedException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (options == null) {
            options = new LogFileOptions();
        }
        if (this.showLogFileOptionsDialog("Trace File Options", options)) {
            this.traceFileOptions = options;
            this.handlerOptionsChanged();
            this.handlerListChanged();
        }
    }

    protected String getDefaultLogDirectory() {
        File logDir;
        if (this.instance != null && (logDir = this.instance.getLogDir()) != null) {
            return logDir.getPath();
        }
        return null;
    }

    protected boolean showLogFileOptionsDialog(String title, LogFileOptions options) {
        LogFileOptionsPanel panel = new LogFileOptionsPanel();
        String defaultLogDirectory = this.getDefaultLogDirectory();
        panel.setDefaultLogDirectory(defaultLogDirectory);
        panel.setLogFileOptions(options);
        LogFileOptionsPanel message = panel;
        int optionType = 2;
        int messageType = -1;
        int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
        return rc == 0;
    }

    private JPanel getPanel_1() {
        if (this.panel_1 == null) {
            this.panel_1 = new JPanel();
            GridBagLayout gbl_panel_1 = new GridBagLayout();
            gbl_panel_1.columnWidths = new int[]{0, 0, 0};
            gbl_panel_1.rowHeights = new int[]{0, 0};
            gbl_panel_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_1.setLayout(gbl_panel_1);
            GridBagConstraints gbc_jComboBoxConsoleStream = new GridBagConstraints();
            gbc_jComboBoxConsoleStream.insets = new Insets(0, 0, 0, 5);
            gbc_jComboBoxConsoleStream.anchor = 17;
            gbc_jComboBoxConsoleStream.gridx = 0;
            gbc_jComboBoxConsoleStream.gridy = 0;
            this.panel_1.add((Component)this.getJComboBoxConsoleStream(), gbc_jComboBoxConsoleStream);
            GridBagConstraints gbc_chckbxConsoleSync = new GridBagConstraints();
            gbc_chckbxConsoleSync.anchor = 17;
            gbc_chckbxConsoleSync.gridx = 1;
            gbc_chckbxConsoleSync.gridy = 0;
            this.panel_1.add((Component)this.getChckbxConsoleSync(), gbc_chckbxConsoleSync);
        }
        return this.panel_1;
    }

    private JCheckBox getChckbxConsoleSync() {
        if (this.chckbxConsoleSync == null) {
            this.chckbxConsoleSync = new JCheckBox("Synchronize");
            this.chckbxConsoleSync.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!InstanceLoggingEditor.this.refreshing) {
                        InstanceLoggingEditor.this.applyLoggingOptions();
                        InstanceLoggingEditor.this.handlerOptionsChanged();
                    }
                }
            });
        }
        return this.chckbxConsoleSync;
    }
}

