/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.log.LoggingConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LoggingConfigPanel
extends JPanel {
    private static final long serialVersionUID = 3836564933986201127L;
    private LoggingConfig loggingConfig;
    private String rootLoggerTitle = "Default";
    private String refreshingTitle = "Scanning packages, please wait...";
    private boolean refreshing = false;
    private boolean refreshingLevel = false;
    private JScrollPane jScrollPane = null;
    private JTree jTree = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JTextField jTextFieldLogger = null;
    private JLabel jLabel1 = null;
    private JComboBox jComboBoxLevel = null;
    private transient List changeListeners;

    public LoggingConfigPanel() {
        this.initialize();
        this.initLoggingConfigPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(4, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(411, 256));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJPanel(), gridBagConstraints1);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJTree());
        }
        return this.jScrollPane;
    }

    private JTree getJTree() {
        if (this.jTree == null) {
            this.jTree = new JTree();
            this.jTree.setOpaque(false);
            this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    LoggingConfigPanel.this.handleLoggerSelected();
                }
            });
        }
        return this.jTree;
    }

    protected void initLoggingConfigPanel() {
        this.getJTree().setRootVisible(true);
        this.getJTree().setShowsRootHandles(true);
        this.getJTree().setCellRenderer(new LogTreeCellRenderer());
        this.getJTree().getSelectionModel().setSelectionMode(1);
        this.getJComboBoxLevel().setRenderer(new LevelListCellRenderer());
        this.refresh();
        this.handleLoggerSelected();
    }

    public LoggingConfig getLoggingConfig() {
        return this.loggingConfig;
    }

    public void setLoggingConfig(LoggingConfig loggingConfig) {
        this.loggingConfig = loggingConfig;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            Level rootLevel = LoggingConfig.DEFAULT_LEVEL;
            TreeMap<String, LogTreeNode> nodes = new TreeMap<String, LogTreeNode>();
            LoggingConfig config = this.loggingConfig;
            if (config != null) {
                LogTreeNode node;
                Level level;
                String name;
                Iterator i = config.getPackages();
                while (i.hasNext()) {
                    name = (String)i.next();
                    level = config.getPackageLevel(name);
                    if (nodes.containsKey(name)) continue;
                    node = new LogTreeNode(name, level, true);
                    nodes.put(name, node);
                }
                i = config.getLoggers();
                while (i.hasNext()) {
                    name = (String)i.next();
                    level = config.getLoggerLevel(name);
                    if ("".equals(name)) {
                        rootLevel = level;
                        continue;
                    }
                    if (nodes.containsKey(name)) continue;
                    node = new LogTreeNode(name, level, false);
                    nodes.put(name, node);
                }
            }
            LogTreeNode root = new LogTreeNode("", rootLevel, false);
            root.setAllowsChildren(true);
            for (Map.Entry me : nodes.entrySet()) {
                int x;
                String logger = (String)me.getKey();
                LogTreeNode node = (LogTreeNode)me.getValue();
                LogTreeNode parent = null;
                String s = logger;
                while ((x = s.lastIndexOf(".")) >= 0 && (parent = (LogTreeNode)nodes.get(s = s.substring(0, x))) == null) {
                }
                if (parent == null) {
                    parent = root;
                }
                parent.add(node);
            }
            DefaultTreeModel model = new DefaultTreeModel(root);
            this.getJTree().setModel(model);
            this.getJComboBoxLevel().removeAllItems();
            this.getJComboBoxLevel().addItem("<Default>");
            if (config != null) {
                Level[] levels = config.getLevels();
                for (int i = 0; i < levels.length; ++i) {
                    this.getJComboBoxLevel().addItem(levels[i]);
                }
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints5.gridx = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.insets = new Insets(4, 4, 4, 0);
            gridBagConstraints4.gridy = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Level:");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 0);
            gridBagConstraints2.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Logger:");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanel.add((Component)this.jLabel, gridBagConstraints2);
            this.jPanel.add((Component)this.getJTextFieldLogger(), gridBagConstraints3);
            this.jPanel.add((Component)this.jLabel1, gridBagConstraints4);
            this.jPanel.add((Component)this.getJComboBoxLevel(), gridBagConstraints5);
        }
        return this.jPanel;
    }

    private JTextField getJTextFieldLogger() {
        if (this.jTextFieldLogger == null) {
            this.jTextFieldLogger = new JTextField();
            this.jTextFieldLogger.setEditable(false);
        }
        return this.jTextFieldLogger;
    }

    private JComboBox getJComboBoxLevel() {
        if (this.jComboBoxLevel == null) {
            this.jComboBoxLevel = new JComboBox();
            this.jComboBoxLevel.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (LoggingConfigPanel.this.refreshing) {
                        return;
                    }
                    if (LoggingConfigPanel.this.refreshingLevel) {
                        return;
                    }
                    LoggingConfigPanel.this.handleLevelSelected();
                }
            });
        }
        return this.jComboBoxLevel;
    }

    public String getRootLoggerTitle() {
        return this.rootLoggerTitle;
    }

    public void setRootLoggerTitle(String rootLoggerTitle) {
        this.rootLoggerTitle = rootLoggerTitle;
    }

    protected LogTreeNode getSelectedLogTreeNode() {
        Object obj;
        TreePath path = this.getJTree().getSelectionPath();
        LogTreeNode node = null;
        if (path != null && (obj = path.getLastPathComponent()) instanceof LogTreeNode) {
            node = (LogTreeNode)obj;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLoggerSelected() {
        try {
            this.refreshingLevel = true;
            LogTreeNode node = this.getSelectedLogTreeNode();
            if (node == null) {
                this.getJTextFieldLogger().setText("");
                this.getJComboBoxLevel().setEnabled(false);
            } else {
                Level level = this.getNodeLevel(node);
                String title = this.getNodeTitle(node, false);
                if (title == null) {
                    title = "";
                }
                this.getJTextFieldLogger().setText(title);
                this.getJComboBoxLevel().setEnabled(true);
                this.getJComboBoxLevel().setSelectedItem(level);
            }
        }
        finally {
            this.refreshingLevel = false;
        }
    }

    protected void handleLevelSelected() {
        String name;
        LoggingConfig config = this.loggingConfig;
        if (config == null) {
            return;
        }
        LogTreeNode node = this.getSelectedLogTreeNode();
        if (node == null) {
            return;
        }
        Object item = this.getJComboBoxLevel().getSelectedItem();
        if (item == null) {
            return;
        }
        Level level = null;
        if (item instanceof Level) {
            level = (Level)item;
        }
        if ("".equals(name = node.getName()) && level == null) {
            level = LoggingConfig.DEFAULT_LEVEL;
        }
        node.setLogLevel(level);
        if (node.isPackage()) {
            config.setPackageLevel(name, level);
        } else {
            config.setLoggerLevel(name, level);
        }
        this.fireStateChanged(new ChangeEvent(this));
        this.getJTree().repaint();
    }

    protected String getNodeTitle(LogTreeNode node, boolean shortClassName) {
        LogTreeNode parentNode;
        String parentName;
        TreeNode parent;
        if (node == null) {
            return null;
        }
        String logger = node.getName();
        if ("".equals(logger)) {
            logger = this.loggingConfig == null ? this.refreshingTitle : this.rootLoggerTitle;
        }
        if (node.isPackage()) {
            return logger + ".*";
        }
        if (shortClassName && (parent = node.getParent()) != null && parent instanceof LogTreeNode && (parentName = (parentNode = (LogTreeNode)parent).getName()) != null && parentName.length() > 0 && logger.startsWith(parentName + ".")) {
            return logger.substring(parentName.length() + 1);
        }
        return logger;
    }

    protected Level getNodeLevel(LogTreeNode node) {
        TreeNode parent;
        if (node == null) {
            return null;
        }
        Level level = null;
        LogTreeNode n = node;
        while (n != null && (level = n.logLevel) == null && (parent = n.getParent()) != null && parent instanceof LogTreeNode) {
            n = (LogTreeNode)parent;
        }
        if (level != null) {
            String name = node.name;
            if ("SystemOut".equals(name)) {
                boolean enabled = level.intValue() <= Level.INFO.intValue();
                return enabled ? Level.ALL : Level.OFF;
            }
            if ("SystemErr".equals(name)) {
                boolean enabled = level.intValue() <= Level.WARNING.intValue();
                return enabled ? Level.ALL : Level.OFF;
            }
        }
        return level;
    }

    protected void fireStateChanged(ChangeEvent e) {
        if (this.changeListeners == null) {
            return;
        }
        int currentSize = this.changeListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            ChangeListener ls = (ChangeListener)this.changeListeners.get(index);
            if (ls == null) continue;
            ls.stateChanged(e);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new LinkedList();
        }
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    public ChangeListener[] getChangeListeners() {
        if (this.changeListeners == null) {
            return new ChangeListener[0];
        }
        return this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
    }

    protected class LevelListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -9159579488942515242L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            Icon icon = null;
            if (value instanceof Level) {
                Level level = (Level)value;
                text = level.getLocalizedName();
                LoggingConfig config = LoggingConfigPanel.this.loggingConfig;
                if (config != null) {
                    icon = config.getLevelIcon(level);
                }
            }
            if (text == null) {
                text = String.valueOf(value);
            }
            this.setText(text);
            this.setIcon(icon);
            return comp;
        }
    }

    protected class LogTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -6381652182853978224L;

        public LogTreeCellRenderer() {
            this.setOpaque(false);
            this.setBackgroundNonSelectionColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            String text = null;
            Icon icon = null;
            if (value != null && value instanceof LogTreeNode) {
                LogTreeNode node = (LogTreeNode)value;
                text = LoggingConfigPanel.this.getNodeTitle(node, true);
                Level level = LoggingConfigPanel.this.getNodeLevel(node);
                LoggingConfig config = LoggingConfigPanel.this.loggingConfig;
                if (config != null) {
                    icon = config.getLevelIcon(level);
                }
            }
            if (text == null) {
                text = String.valueOf(value);
            }
            this.setText(text);
            this.setIcon(icon);
            return comp;
        }
    }

    protected static class LogTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -3077745318135193804L;
        private String name;
        private Level logLevel;
        private boolean isPackage;

        public LogTreeNode(String name, Level logLevel, boolean isPackage) {
            this.setName(name);
            this.setLogLevel(logLevel);
            this.setPackage(isPackage);
        }

        public boolean isPackage() {
            return this.isPackage;
        }

        public void setPackage(boolean pkg) {
            this.isPackage = pkg;
        }

        public Level getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(Level logLevel) {
            this.logLevel = logLevel;
        }

        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return "LogTreeNode[resource=" + this.name + ", level=" + this.logLevel + "]";
        }
    }
}

