/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.util;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.ArtifactDependency;
import com.spacekiller.infection.ArtifactLibPathEntry;
import com.spacekiller.infection.DistributionLicense;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.JavaVM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InfectionXmlUtil {
    private static final Logger logger = Logger.getLogger(InfectionXmlUtil.class.getName());
    public static final String NAMESPACE = "https://spacekiller.com/infection/index/";
    public static final String XSD_URLS = "https://spacekiller.com/schema/ infection_V1.xsd";
    public static final String ELEMENT_INFECTION = "infection";
    public static final String ELEMENT_SITE = "site";
    public static final String ELEMENT_INSTANCE = "instance";
    public static final String ELEMENT_JAVAVM = "jvm";
    public static final String ELEMENT_LICENSE = "license";
    public static final String ELEMENT_ARTIFACT = "artifact";
    public static final String ELEMENT_DEPENDENCY = "dependency";
    public static final String ELEMENT_CLASSPATH = "classpath";
    public static final String ELEMENT_LIBPATH = "libpath";
    private InfectionIndex index;
    private boolean namespaceAware = false;

    public InfectionXmlUtil(InfectionIndex index) {
        this.index = index;
    }

    public InfectionIndex getIndex() {
        return this.index;
    }

    public void setIndex(InfectionIndex index) {
        this.index = index;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndex(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.saveIndex(fos);
        }
        finally {
            fos.close();
        }
    }

    public void saveIndex(OutputStream out) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(this.namespaceAware);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element elStudio = this.createInfectionElement(doc);
            doc.appendChild(elStudio);
            DOMSource source = new DOMSource(doc);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer trans = transFactory.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(out);
            trans.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected Element createInfectionElement(Document doc) {
        Element elInfection;
        if (this.namespaceAware) {
            elInfection = doc.createElementNS(NAMESPACE, ELEMENT_INFECTION);
            elInfection.setPrefix("tns");
            Attr attr = doc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation");
            attr.setValue(XSD_URLS);
            elInfection.setAttributeNode(attr);
        } else {
            elInfection = doc.createElement(ELEMENT_INFECTION);
        }
        int numSites = this.index.getSiteCount();
        for (int c = 0; c < numSites; ++c) {
            Element el;
            InfectionSite site = this.index.getSiteAt(c);
            if (site == null || (el = this.createSiteElement(doc, site)) == null) continue;
            elInfection.appendChild(el);
        }
        int numInstances = this.index.getInstanceCount();
        for (int c = 0; c < numInstances; ++c) {
            Element el;
            String path = this.index.getInstancePathAt(c);
            if (path == null || (el = this.createInstanceElement(doc, path)) == null) continue;
            elInfection.appendChild(el);
        }
        int numJVM = this.index.getJavaVMCount();
        for (int i = 0; i < numJVM; ++i) {
            Element el;
            JavaVM jvm = this.index.getJavaVMAt(i);
            if (jvm == null || (el = this.createJavaVMElement(doc, jvm)) == null) continue;
            elInfection.appendChild(el);
        }
        int numLics = this.index.getLicenseCount();
        for (int i = 0; i < numLics; ++i) {
            Element el;
            DistributionLicense lic = this.index.getLicenseAt(i);
            if (lic == null || (el = this.createLicenseElement(doc, lic)) == null) continue;
            elInfection.appendChild(el);
        }
        int numArts = this.index.getArtifactCount();
        for (int c = 0; c < numArts; ++c) {
            Element el;
            Artifact art = this.index.getArtifactAt(c);
            if (art == null || (el = this.createArtifactElement(doc, art)) == null) continue;
            elInfection.appendChild(el);
        }
        return elInfection;
    }

    protected Element createSiteElement(Document doc, InfectionSite site) {
        String path;
        String name;
        Element el = doc.createElement(ELEMENT_SITE);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:site");
        }
        if ((name = site.getName()) != null) {
            el.setAttribute("name", name);
        }
        if ((path = site.getPath()) != null) {
            el.setAttribute("url", path);
        }
        el.setAttribute("recursive", Boolean.toString(site.isRecursive()));
        if (!site.isActive()) {
            el.setAttribute("active", Boolean.toString(site.isActive()));
        }
        return el;
    }

    protected Element createInstanceElement(Document doc, String path) {
        Element el = doc.createElement(ELEMENT_INSTANCE);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:instance");
        }
        if (path != null) {
            el.setAttribute("path", path);
        }
        return el;
    }

    protected Element createJavaVMElement(Document doc, JavaVM jvm) {
        String executable;
        String version;
        String title;
        Element el = doc.createElement(ELEMENT_JAVAVM);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:jvm");
        }
        if ((title = jvm.getTitle()) == null) {
            title = "";
        }
        if ((version = jvm.getVersion()) == null) {
            version = "";
        }
        if ((executable = jvm.getExecutable()) == null) {
            executable = "";
        }
        el.setAttribute("title", title);
        el.setAttribute("version", version);
        el.setAttribute("executable", executable);
        return el;
    }

    protected Element createLicenseElement(Document doc, DistributionLicense lic) {
        String licTime;
        String licHash;
        String licKey;
        Element el = doc.createElement(ELEMENT_LICENSE);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:license");
        }
        if ((licKey = lic.getLicenseKey()) != null) {
            el.setAttribute("key", licKey);
        }
        if ((licHash = lic.getLicenseHash()) != null) {
            el.setAttribute("hash", licHash);
        }
        if ((licTime = lic.getAcceptedTime()) != null) {
            el.setAttribute("time", licTime);
        }
        return el;
    }

    protected Element createArtifactElement(Document doc, Artifact art) {
        long installTime;
        String s;
        long time;
        int crc;
        int len;
        String path;
        String version;
        String title;
        String name;
        Element el = doc.createElement(ELEMENT_ARTIFACT);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:artifact");
        }
        if ((name = art.getName()) != null) {
            el.setAttribute("name", name);
        }
        if ((title = art.getTitle()) != null) {
            el.setAttribute("title", title);
        }
        if ((version = art.getVersion()) != null) {
            el.setAttribute("version", version);
        }
        if ((path = art.getPath()) != null) {
            path = Infection.getSlashPath(path);
            el.setAttribute("path", path);
        }
        if ((len = art.getLength()) != -1) {
            el.setAttribute("length", String.valueOf(len));
        }
        if ((crc = art.getChecksum()) != -1) {
            el.setAttribute("checksum", String.valueOf(crc));
        }
        if ((time = art.getTime()) != 0L) {
            el.setAttribute("time", String.valueOf(time));
        }
        if ((s = art.getVendor()) != null) {
            el.setAttribute("vendor", s);
        }
        if ((s = art.getDeploy()) != null) {
            el.setAttribute("deploy", s);
        }
        if ((s = art.getOsPrefix()) != null && s.length() > 0) {
            el.setAttribute("os", s);
        }
        if ((s = art.getOsArch()) != null && s.length() > 0) {
            el.setAttribute("arch", s);
        }
        if ((installTime = art.getInstallTime()) != 0L) {
            el.setAttribute("installTime", String.valueOf(installTime));
        }
        int numDep = art.getDependencyCount();
        for (int d = 0; d < numDep; ++d) {
            Element elDep;
            ArtifactDependency dep = art.getDependencyAt(d);
            if (dep == null || (elDep = this.createDependencyElement(doc, art, dep)) == null) continue;
            el.appendChild(elDep);
        }
        int numCP = art.getClassPathEntryCount();
        for (int d = 0; d < numCP; ++d) {
            Element elCP;
            String cp = art.getClassPathEntryAt(d);
            if (cp == null || (elCP = this.createClassPathElement(doc, art, cp = Infection.getSlashPath(cp))) == null) continue;
            el.appendChild(elCP);
        }
        int numLP = art.getLibPathEntryCount();
        for (int d = 0; d < numLP; ++d) {
            Element elLP;
            ArtifactLibPathEntry entry = art.getLibPathEntryAt(d);
            if (entry == null || (elLP = this.createLibPathElement(doc, art, entry)) == null) continue;
            el.appendChild(elLP);
        }
        return el;
    }

    protected Element createDependencyElement(Document doc, Artifact art, ArtifactDependency dep) {
        boolean depOptional;
        double weight;
        String maxVersion;
        String minVersion;
        String version;
        String artifact;
        Element el = doc.createElement(ELEMENT_DEPENDENCY);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:dependency");
        }
        if ((artifact = dep.getArtifact()) != null) {
            el.setAttribute(ELEMENT_ARTIFACT, dep.getArtifact());
        }
        if ((version = dep.getVersion()) != null) {
            el.setAttribute("version", version);
        }
        if ((minVersion = dep.getMinVersion()) != null) {
            el.setAttribute("minVersion", minVersion);
        }
        if ((maxVersion = dep.getMaxVersion()) != null) {
            el.setAttribute("maxVersion", maxVersion);
        }
        if ((weight = dep.getWeight()) != 0.0 && !Double.isNaN(weight)) {
            el.setAttribute("weight", String.valueOf(weight));
        }
        if (depOptional = dep.isOptional()) {
            el.setAttribute("optional", Boolean.toString(depOptional));
        }
        return el;
    }

    protected Element createClassPathElement(Document doc, Artifact art, String cp) {
        Element el = doc.createElement(ELEMENT_CLASSPATH);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:classpath");
        }
        el.setAttribute("file", cp);
        return el;
    }

    protected Element createLibPathElement(Document doc, Artifact art, ArtifactLibPathEntry entry) {
        String arch;
        String lp = entry.getDirectory();
        if (lp == null) {
            return null;
        }
        Element el = doc.createElement(ELEMENT_LIBPATH);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:libpath");
        }
        lp = Infection.getSlashPath(lp);
        el.setAttribute("directory", lp);
        String os = entry.getOs();
        if (os != null) {
            el.setAttribute("os", os);
        }
        if ((arch = entry.getArch()) != null) {
            el.setAttribute("arch", arch);
        }
        return el;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIndex(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            this.loadIndex(fis);
        }
        finally {
            fis.close();
        }
    }

    public void loadIndex(InputStream in) throws IOException {
        try {
            boolean namespaceAware = true;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(namespaceAware);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            NodeList list = doc.getChildNodes();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = list.item(i);
                String nodeName = node.getLocalName();
                if (!ELEMENT_INFECTION.equals(nodeName)) continue;
                this.readInfection(node);
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    protected void readInfection(Node infectionNode) {
        if (infectionNode != null && infectionNode instanceof Element) {
            Element elInfection = (Element)infectionNode;
            NodeList list = elInfection.getChildNodes();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = list.item(i);
                if (!(node instanceof Element)) continue;
                Element el = (Element)node;
                String name = el.getNodeName();
                if (ELEMENT_ARTIFACT.equals(name)) {
                    Artifact art = this.readArtifact((Element)node);
                    if (art == null) continue;
                    this.index.addArtifact(art);
                    continue;
                }
                if (ELEMENT_SITE.equals(name)) {
                    InfectionSite site = this.readSite((Element)node);
                    if (site == null) continue;
                    this.index.addSite(site);
                    continue;
                }
                if (ELEMENT_INSTANCE.equals(name)) {
                    String path = this.readInstance((Element)node);
                    if (path == null) continue;
                    this.index.addInstancePath(path);
                    continue;
                }
                if (ELEMENT_JAVAVM.equals(name)) {
                    JavaVM jvm = this.readJavaVM((Element)node);
                    if (jvm == null) continue;
                    this.index.addJavaVM(jvm);
                    continue;
                }
                if (ELEMENT_LICENSE.equals(name)) {
                    DistributionLicense lic = this.readLicense((Element)node);
                    if (lic == null) continue;
                    this.index.addLicense(lic);
                    continue;
                }
                logger.warning("Unexpected element name: " + name);
            }
        }
    }

    protected InfectionSite readSite(Element el) {
        String siteName = el.getAttribute("name");
        if (siteName.length() < 1) {
            return null;
        }
        String siteUrl = el.getAttribute("url");
        if (siteUrl.length() < 1) {
            return null;
        }
        boolean recursiveSubSites = false;
        String siteRecursive = el.getAttribute("recursive");
        if (siteRecursive.length() > 0) {
            recursiveSubSites = siteRecursive.equalsIgnoreCase("true");
        }
        boolean active = true;
        String siteActive = el.getAttribute("active");
        if (siteActive.length() > 0) {
            active = siteActive.equalsIgnoreCase("true");
        }
        String fullURL = siteUrl;
        if (siteUrl.indexOf(":") < 0) {
            String parentPath = this.index.getPath();
            int q = parentPath.lastIndexOf("/");
            if (q >= 0) {
                parentPath = parentPath.substring(0, q);
            }
            fullURL = parentPath + "/" + siteUrl;
        }
        InfectionSite subSite = new InfectionSite(fullURL);
        subSite.setName(siteName);
        subSite.setPath(siteUrl);
        subSite.setRecursive(recursiveSubSites);
        subSite.setActive(active);
        return subSite;
    }

    protected String readInstance(Element el) {
        String path = el.getAttribute("path");
        if (path.length() < 1) {
            return null;
        }
        return path;
    }

    protected Artifact readArtifact(Element el) {
        String artArch;
        String artOs;
        String artDeploy;
        String artVendor;
        String artName = el.getAttribute("name");
        if (artName.length() < 1) {
            return null;
        }
        String artVersion = el.getAttribute("version");
        if (artVersion.length() < 1) {
            return null;
        }
        String artPath = el.getAttribute("path");
        if (artPath.length() < 1) {
            return null;
        }
        String artTitle = el.getAttribute("title");
        String artLength = el.getAttribute("length");
        int artLen = -1;
        if (artLength.length() > 0) {
            try {
                artLen = Integer.parseInt(artLength.trim());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        String artChecksum = el.getAttribute("checksum");
        int artCrc = -1;
        if (artChecksum.length() > 0) {
            try {
                artCrc = Integer.parseInt(artChecksum.trim());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        String artTime = el.getAttribute("time");
        long artTimeMillis = 0L;
        if (artTime.length() > 0) {
            try {
                artTimeMillis = Long.parseLong(artTime.trim());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((artVendor = el.getAttribute("vendor")).length() < 1) {
            artVendor = null;
        }
        if ((artDeploy = el.getAttribute("deploy")).length() < 1) {
            artDeploy = null;
        }
        if ((artOs = el.getAttribute("os")).length() < 1) {
            artOs = null;
        }
        if ((artArch = el.getAttribute("arch")).length() < 1) {
            artArch = null;
        }
        String artInstallTime = el.getAttribute("installTime");
        long artInstallTimeMillis = 0L;
        if (artInstallTime.length() > 0) {
            try {
                artInstallTimeMillis = Long.parseLong(artInstallTime.trim());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        Artifact art = new Artifact();
        art.setSite(this.index.getSite());
        art.setName(artName);
        art.setTitle(artTitle);
        art.setVersion(artVersion);
        art.setPath(artPath);
        art.setTime(artTimeMillis);
        art.setLength(artLen);
        art.setChecksum(artCrc);
        art.setVendor(artVendor);
        art.setDeploy(artDeploy);
        art.setInstallTime(artInstallTimeMillis);
        art.setOsPrefix(artOs);
        art.setOsArch(artArch);
        NodeList list = el.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            Element sub = (Element)node;
            String name = sub.getNodeName();
            if (ELEMENT_DEPENDENCY.equals(name)) {
                ArtifactDependency dep = this.readDependency(sub);
                if (dep == null) continue;
                art.addDependency(dep);
                continue;
            }
            if (ELEMENT_CLASSPATH.equals(name)) {
                String cp = this.readClasspath(sub);
                if (cp == null) continue;
                art.addClassPathEntry(cp);
                continue;
            }
            if (ELEMENT_LIBPATH.equals(name)) {
                ArtifactLibPathEntry lp = this.readLibpath(sub);
                if (lp == null) continue;
                art.addLibPathEntry(lp);
                continue;
            }
            logger.warning("Unexpected element name: " + name);
        }
        return art;
    }

    protected ArtifactDependency readDependency(Element el) {
        String optionalString;
        String weightString;
        String maxVersion;
        String minVersion;
        String name = el.getAttribute(ELEMENT_ARTIFACT);
        if (name == null) {
            return null;
        }
        String version = el.getAttribute("version");
        if (version.length() < 1) {
            version = null;
        }
        if ((minVersion = el.getAttribute("minVersion")).length() < 1) {
            minVersion = null;
        }
        if ((maxVersion = el.getAttribute("maxVersion")).length() < 1) {
            maxVersion = null;
        }
        if ((weightString = el.getAttribute("weight")).length() < 1) {
            weightString = null;
        }
        if ((optionalString = el.getAttribute("optional")).length() < 1) {
            optionalString = null;
        }
        double weight = 0.0;
        if (weightString != null) {
            weightString = weightString.trim();
            try {
                weight = Double.parseDouble(weightString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        boolean optional = false;
        if (optionalString != null) {
            optionalString = optionalString.trim();
            optional = new Boolean(optionalString);
        }
        ArtifactDependency dep = new ArtifactDependency(name, version);
        dep.setMinVersion(minVersion);
        dep.setMaxVersion(maxVersion);
        dep.setWeight(weight);
        dep.setOptional(optional);
        return dep;
    }

    protected String readClasspath(Element el) {
        String filepath = el.getAttribute("file");
        if (filepath.length() < 1) {
            filepath = null;
        }
        return filepath;
    }

    protected ArtifactLibPathEntry readLibpath(Element el) {
        String arch;
        String libpath = el.getAttribute("directory");
        if (libpath.length() < 1) {
            return null;
        }
        String os = el.getAttribute("os");
        if (os.length() < 1) {
            os = null;
        }
        if ((arch = el.getAttribute("arch")).length() < 1) {
            arch = null;
        }
        ArtifactLibPathEntry entry = new ArtifactLibPathEntry(libpath);
        entry.setOs(os);
        entry.setArch(arch);
        return entry;
    }

    protected JavaVM readJavaVM(Element el) {
        String executable;
        String version;
        String title = el.getAttribute("title");
        if (title.length() < 1) {
            title = null;
        }
        if ((version = el.getAttribute("version")).length() < 1) {
            version = null;
        }
        if ((executable = el.getAttribute("executable")).length() < 1) {
            executable = null;
        }
        if (executable == null) {
            return null;
        }
        JavaVM jvm = new JavaVM();
        jvm.setExecutable(executable);
        jvm.setVersion(version);
        jvm.setTitle(title);
        return jvm;
    }

    protected DistributionLicense readLicense(Element el) {
        String licTime;
        String licKey = el.getAttribute("key");
        if (licKey.length() < 1) {
            return null;
        }
        String licHash = el.getAttribute("hash");
        if (licHash.length() < 1) {
            licHash = null;
        }
        if ((licTime = el.getAttribute("time")).length() < 1) {
            licTime = null;
        }
        DistributionLicense lic = new DistributionLicense();
        lic.setLicenseKey(licKey);
        lic.setLicenseHash(licHash);
        lic.setAcceptedTime(licTime);
        return lic;
    }
}

