/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.util;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionSystemProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InstanceXmlUtil {
    private static final Logger logger = Logger.getLogger(InstanceXmlUtil.class.getName());
    public static final String NAMESPACE = "https://spacekiller.com/infection/instance/";
    public static final String XSD_URLS = "https://spacekiller.com/schema/ instance_V1.xsd";
    public static final String ELEMENT_INSTANCE = "instance";
    public static final String ELEMENT_ARTIFACT = "artifact";
    public static final String ELEMENT_CLASSPATH = "classpath";
    public static final String ELEMENT_LIBPATH = "libpath";
    public static final String ELEMENT_PROPERTY = "property";
    public static final String ELEMENT_JVMARG = "jvmarg";
    private InfectionInstance instance;
    private boolean namespaceAware = false;

    public InstanceXmlUtil(InfectionInstance instance) {
        this.instance = instance;
    }

    public InfectionInstance getInstance() {
        return this.instance;
    }

    public void setInstance(InfectionInstance instance) {
        this.instance = instance;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInstance(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.saveInstance(fos);
        }
        finally {
            fos.close();
        }
    }

    public void saveInstance(OutputStream out) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(this.namespaceAware);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element elStudio = this.createInstanceElement(doc);
            doc.appendChild(elStudio);
            DOMSource source = new DOMSource(doc);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer trans = transFactory.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(out);
            trans.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected Element createInstanceElement(Document doc) {
        String value;
        String key;
        String indexPath;
        Element elInstance;
        if (this.namespaceAware) {
            elInstance = doc.createElementNS(NAMESPACE, ELEMENT_INSTANCE);
            elInstance.setPrefix("tns");
            Attr attr = doc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation");
            attr.setValue(XSD_URLS);
            elInstance.setAttributeNode(attr);
        } else {
            elInstance = doc.createElement(ELEMENT_INSTANCE);
        }
        String distributionName = this.instance.getDistributionName();
        if (distributionName != null) {
            elInstance.setAttribute("distribution", distributionName);
        }
        if ((indexPath = this.instance.getIndexPath()) != null) {
            indexPath = indexPath.replace('\\', '/');
            elInstance.setAttribute("index", indexPath);
        }
        int numArts = this.instance.getArtifactCount();
        for (int c = 0; c < numArts; ++c) {
            Element el;
            Artifact art = this.instance.getArtifactAt(c);
            if (art == null || (el = this.createArtifactElement(doc, art)) == null) continue;
            elInstance.appendChild(el);
        }
        int numCP = this.instance.getClassPathCount();
        for (int c = 0; c < numCP; ++c) {
            Element el;
            String cpEntry = this.instance.getClassPathAt(c);
            if (cpEntry == null || (el = this.createClassPathElement(doc, cpEntry)) == null) continue;
            elInstance.appendChild(el);
        }
        int numLP = this.instance.getLibraryPathCount();
        for (int c = 0; c < numLP; ++c) {
            Element el;
            String lpEntry = this.instance.getLibraryPathAt(c);
            if (lpEntry == null || (el = this.createLibPathElement(doc, lpEntry)) == null) continue;
            elInstance.appendChild(el);
        }
        TreeMap<String, String> sortedProps = new TreeMap<String, String>();
        int numProps = this.instance.getPropertyCount();
        for (int c = 0; c < numProps; ++c) {
            InfectionSystemProperty prop = this.instance.getPropertyAt(c);
            if (prop == null) continue;
            key = prop.getKey();
            value = prop.getValue();
            if (key == null) continue;
            sortedProps.put(key, value);
        }
        for (Map.Entry me : sortedProps.entrySet()) {
            key = (String)me.getKey();
            Element el = this.createPropertyElement(doc, key, value = (String)me.getValue());
            if (el == null) continue;
            elInstance.appendChild(el);
        }
        int numOpts = this.instance.getJavaOptionCount();
        for (int i = 0; i < numOpts; ++i) {
            Element el;
            String jvmOption = this.instance.getJavaOptionAt(i);
            if (jvmOption == null || (el = this.createJavaOptionElement(doc, jvmOption)) == null) continue;
            elInstance.appendChild(el);
        }
        return elInstance;
    }

    protected Element createArtifactElement(Document doc, Artifact art) {
        Element el = doc.createElement(ELEMENT_ARTIFACT);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:artifact");
        }
        el.setAttribute("name", art.getName());
        el.setAttribute("version", art.getVersion());
        if (art.getInstallMode() == 1) {
            el.setAttribute("manual", "true");
        }
        return el;
    }

    protected Element createClassPathElement(Document doc, String cpEntry) {
        Element el = doc.createElement(ELEMENT_CLASSPATH);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:classpath");
        }
        el.setAttribute("path", cpEntry);
        return el;
    }

    protected Element createLibPathElement(Document doc, String lpEntry) {
        Element el = doc.createElement(ELEMENT_LIBPATH);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:libpath");
        }
        el.setAttribute("path", lpEntry);
        return el;
    }

    protected Element createPropertyElement(Document doc, String key, String value) {
        Element el = doc.createElement(ELEMENT_PROPERTY);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:property");
        }
        el.setAttribute("key", key);
        el.setAttribute("value", value);
        return el;
    }

    protected Element createJavaOptionElement(Document doc, String jvmOption) {
        Element el = doc.createElement(ELEMENT_JVMARG);
        if (this.namespaceAware) {
            el.setAttribute("xsi:type", "tns:jvmarg");
        }
        el.setAttribute("option", jvmOption);
        return el;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInstance(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            this.loadInstance(fis);
        }
        finally {
            fis.close();
        }
    }

    public void loadInstance(InputStream in) throws IOException {
        try {
            boolean namespaceAware = true;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(namespaceAware);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            NodeList list = doc.getChildNodes();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = list.item(i);
                String nodeName = node.getLocalName();
                if (!ELEMENT_INSTANCE.equals(nodeName)) continue;
                this.readInstance(node);
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    protected void readInstance(Node instanceNode) {
        if (instanceNode != null && instanceNode instanceof Element) {
            String indexPath;
            Element elInstance = (Element)instanceNode;
            String distributionName = elInstance.getAttribute("distribution");
            if (distributionName != null) {
                this.instance.setDistributionName(distributionName);
            }
            if ((indexPath = elInstance.getAttribute("index")) != null) {
                this.instance.setIndexPath(indexPath);
            }
            NodeList list = elInstance.getChildNodes();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = list.item(i);
                if (!(node instanceof Element)) continue;
                Element el = (Element)node;
                String name = el.getNodeName();
                if (ELEMENT_ARTIFACT.equals(name)) {
                    Artifact art = this.readArtifact((Element)node);
                    if (art == null) continue;
                    this.instance.addArtifact(art);
                    continue;
                }
                if (ELEMENT_CLASSPATH.equals(name)) {
                    String cpEntry = this.readClassPath((Element)node);
                    if (cpEntry == null || (cpEntry = cpEntry.trim()).length() <= 0) continue;
                    this.instance.addClassPath(cpEntry);
                    continue;
                }
                if (ELEMENT_LIBPATH.equals(name)) {
                    String libPath = this.readLibPath((Element)node);
                    if (libPath == null || (libPath = libPath.trim()).length() <= 0) continue;
                    this.instance.addLibraryPath(libPath);
                    continue;
                }
                if (ELEMENT_PROPERTY.equals(name)) {
                    InfectionSystemProperty prop = this.readProperty((Element)node);
                    if (prop == null) continue;
                    this.instance.addProperty(prop);
                    continue;
                }
                if (ELEMENT_JVMARG.equals(name)) {
                    String javaOption = this.readJavaOption((Element)node);
                    if (javaOption == null || (javaOption = javaOption.trim()).length() <= 0) continue;
                    this.instance.addJavaOption(javaOption);
                    continue;
                }
                logger.warning("Unexpected element name: " + name);
            }
        }
    }

    protected Artifact readArtifact(Element el) {
        String artName = el.getAttribute("name");
        if (artName.length() < 1) {
            return null;
        }
        String artVersion = el.getAttribute("version");
        if (artVersion.length() < 1) {
            return null;
        }
        String artManual = el.getAttribute("manual");
        if (artManual.length() < 1) {
            artManual = null;
        }
        Artifact art = new Artifact();
        art.setName(artName);
        art.setVersion(artVersion);
        if (artManual != null && "true".equalsIgnoreCase(artManual)) {
            art.setInstallMode(1);
        } else {
            art.setInstallMode(0);
        }
        return art;
    }

    protected String readClassPath(Element el) {
        String filePath = el.getAttribute("path");
        if (filePath.length() < 1) {
            filePath = null;
        }
        return filePath;
    }

    protected String readLibPath(Element el) {
        String filePath = el.getAttribute("path");
        if (filePath.length() < 1) {
            filePath = null;
        }
        return filePath;
    }

    protected InfectionSystemProperty readProperty(Element el) {
        String key = el.getAttribute("key");
        if (key.length() < 1) {
            return null;
        }
        String value = el.getAttribute("value");
        if (value == null) {
            value = "";
        }
        key = key.trim();
        value = value.trim();
        if (key.length() < 1) {
            return null;
        }
        return new InfectionSystemProperty(key, value);
    }

    protected String readJavaOption(Element el) {
        String option = el.getAttribute("option");
        if (option.length() < 1) {
            option = null;
        }
        return option;
    }
}

