/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.project;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class ClassPath {
    public static final String NEW_LOADER = "name=";
    public static final String PARENT_LOADER = "parent=";
    public static final String CLASS_PATH = "cp=";
    public static final String LIB_PATH = "lib=";
    public static final String LF = "\n";
    private String name;
    private String parent;
    private List<String> classPath;
    private List<String> libPath;

    public ClassPath() {
        this(null);
    }

    public ClassPath(String name) {
        this.name = name;
        this.classPath = new LinkedList<String>();
        this.libPath = new LinkedList<String>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public List<String> getClassPath() {
        return this.classPath;
    }

    public void setClassPath(List<String> classPath) {
        this.classPath = classPath;
    }

    public void addClassPath(String path) {
        this.classPath.add(path);
    }

    public List<String> getLibPath() {
        return this.libPath;
    }

    public void setLibPath(List<String> libPath) {
        this.libPath = libPath;
    }

    public void addLibPath(String path) {
        this.libPath.add(path);
    }

    public static void read(BufferedReader reader, List<ClassPath> dst) throws IOException {
        String s;
        ClassPath cp = null;
        while ((s = reader.readLine()) != null) {
            if (s.length() < 1 || s.charAt(0) == '#') continue;
            if (s.startsWith(CLASS_PATH)) {
                if (cp == null) {
                    cp = new ClassPath();
                }
                cp.addClassPath(s.substring(CLASS_PATH.length()).trim());
                continue;
            }
            if (s.startsWith(LIB_PATH)) {
                if (cp == null) {
                    cp = new ClassPath();
                }
                cp.addLibPath(s.substring(LIB_PATH.length()).trim());
                continue;
            }
            if (s.startsWith(NEW_LOADER)) {
                if (cp != null) {
                    dst.add(cp);
                }
                cp = new ClassPath(s.substring(NEW_LOADER.length()).trim());
                continue;
            }
            if (!s.startsWith(PARENT_LOADER) || cp == null) continue;
            cp.setParent(s.substring(PARENT_LOADER.length()).trim());
        }
        if (cp != null) {
            dst.add(cp);
        }
    }

    public static void write(List<ClassPath> src, BufferedWriter writer) throws IOException {
        for (ClassPath cp : src) {
            String name = cp.getName();
            if (name == null) {
                name = "";
            }
            writer.write("# ");
            writer.write(name);
            writer.write(LF);
            writer.write(NEW_LOADER + name);
            writer.write(name);
            writer.write(LF);
            String parent = cp.getParent();
            if (parent != null) {
                writer.write(PARENT_LOADER);
                writer.write(parent);
                writer.write(LF);
            }
            List<String> classPath = cp.getClassPath();
            for (String path : classPath) {
                writer.write(CLASS_PATH);
                writer.write(path);
                writer.write(LF);
            }
            List<String> libPath = cp.getLibPath();
            for (String path : libPath) {
                writer.write(LIB_PATH);
                writer.write(path);
                writer.write(LF);
            }
        }
    }
}

