/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.project.common;

import com.spacekiller.project.Project;
import com.spacekiller.project.ProjectDependency;
import com.spacekiller.project.Repository;
import com.spacekiller.project.common.AbstractRepository;
import java.util.List;

public abstract class AbstractProject
implements Project {
    protected final AbstractRepository repository;
    protected final String groupId;
    protected final String projectId;
    protected final String version;
    protected String type;
    protected String title;
    protected String description;
    protected List<ProjectDependency> dependencyList;

    public AbstractProject(AbstractRepository repository, String groupId, String projectId, String version) {
        this.repository = repository;
        this.groupId = groupId;
        this.projectId = projectId;
        this.version = version;
    }

    public String toString() {
        return super.toString() + "[" + this.groupId + ":" + this.projectId + ":" + this.version + "]";
    }

    @Override
    public final Repository getRepository() {
        return this.repository;
    }

    @Override
    public final String getGroupId() {
        return this.groupId;
    }

    @Override
    public final String getProjectId() {
        return this.projectId;
    }

    @Override
    public final String getVersion() {
        return this.version;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDependencyCount() {
        List<ProjectDependency> list = this.dependencyList;
        synchronized (list) {
            return this.dependencyList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectDependency getDependencyAt(int index) {
        List<ProjectDependency> list = this.dependencyList;
        synchronized (list) {
            if (index < 0 || index >= this.dependencyList.size()) {
                return null;
            }
            return this.dependencyList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectDependency[] getDependencyArray() {
        List<ProjectDependency> list = this.dependencyList;
        synchronized (list) {
            return this.dependencyList.toArray(new ProjectDependency[this.dependencyList.size()]);
        }
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setType(String type) {
        this.type = type;
    }
}

