/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.project.common;

import com.spacekiller.project.ProjectContext;
import com.spacekiller.project.ProjectType;
import com.spacekiller.project.common.AbstractProjectType;
import com.spacekiller.project.common.VersionComparator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractProjectContext
implements ProjectContext {
    protected final VersionComparator versionComparator;
    protected Map<String, AbstractProjectType> projectTypes;

    public AbstractProjectContext(VersionComparator versionComparator) {
        this.versionComparator = versionComparator;
        this.projectTypes = new HashMap<String, AbstractProjectType>();
    }

    public final VersionComparator getVersionComparator() {
        return this.versionComparator;
    }

    @Override
    public ProjectType getProjectType(String type) {
        return this.projectTypes.get(type);
    }

    @Override
    public int getProjectTypeCount() {
        return this.projectTypes.size();
    }

    @Override
    public int getProjectTypes(Collection<ProjectType> dst) {
        int num = 0;
        for (AbstractProjectType type : this.projectTypes.values()) {
            dst.add(type);
            ++num;
        }
        return num;
    }

    protected AbstractProjectType addProjectType(AbstractProjectType type) {
        return this.projectTypes.put(type.getName(), type);
    }

    protected boolean removeProjectType(AbstractProjectType type) {
        String key = type.getName();
        AbstractProjectType old = this.projectTypes.get(key);
        if (old == type) {
            return this.projectTypes.remove(key) != null;
        }
        return false;
    }
}

