/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.project.common;

import com.spacekiller.project.Project;
import com.spacekiller.project.ProjectGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractProjectGroup
implements ProjectGroup {
    protected final String groupId;
    protected Map<String, Set<Project>> projectMap;
    protected int projectCount;

    public AbstractProjectGroup(String groupId) {
        this.groupId = groupId;
        this.projectMap = new HashMap<String, Set<Project>>();
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public int getProjectIdCount() {
        return this.projectMap.size();
    }

    @Override
    public int getProjectIds(Collection<String> dst) {
        int num = 0;
        for (String id : this.projectMap.keySet()) {
            dst.add(id);
            ++num;
        }
        return num;
    }

    @Override
    public boolean containsProjectId(String id) {
        return this.projectMap.containsKey(id);
    }

    @Override
    public int getProjectCount() {
        return this.projectCount;
    }

    @Override
    public boolean containsProject(Project p) {
        String pid = p.getProjectId();
        Set<Project> set = this.projectMap.get(pid);
        if (set == null) {
            return false;
        }
        return set.contains(p);
    }

    @Override
    public int getProjects(Collection<Project> dst) {
        int num = 0;
        for (Map.Entry<String, Set<Project>> me : this.projectMap.entrySet()) {
            Set<Project> set = me.getValue();
            for (Project p : set) {
                dst.add(p);
                ++num;
            }
        }
        return num;
    }

    @Override
    public int getProjects(Collection<Project> dst, String projectId) {
        int num = 0;
        Set<Project> set = this.projectMap.get(projectId);
        if (set != null) {
            for (Project p : set) {
                dst.add(p);
                ++num;
            }
        }
        return num;
    }

    @Override
    public int getProjects(Collection<Project> dst, String projectId, String version) {
        int num = 0;
        Set<Project> set = this.projectMap.get(projectId);
        if (set != null) {
            for (Project p : set) {
                if (version != null && !version.equals(p.getVersion())) continue;
                dst.add(p);
                ++num;
            }
        }
        return num;
    }

    protected boolean addProject(Project p) {
        String pid = p.getProjectId();
        Set<Project> set = this.projectMap.get(pid);
        if (set == null) {
            set = new HashSet<Project>();
            this.projectMap.put(pid, set);
        }
        if (set.add(p)) {
            ++this.projectCount;
            return true;
        }
        return false;
    }

    protected boolean removeProject(Project p) {
        String pid = p.getProjectId();
        Set<Project> set = this.projectMap.get(pid);
        if (set == null) {
            return false;
        }
        if (set.remove(p)) {
            --this.projectCount;
            if (set.isEmpty()) {
                this.projectMap.remove(pid);
            }
            return true;
        }
        return false;
    }
}

