/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.project.common;

import com.spacekiller.project.Project;
import com.spacekiller.project.ProjectGroup;
import com.spacekiller.project.ProjectModel;
import com.spacekiller.project.common.AbstractProjectGroup;
import com.spacekiller.project.common.DefaultProjectGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractProjectModel
implements ProjectModel {
    private Map<String, AbstractProjectGroup> groups = new HashMap<String, AbstractProjectGroup>();
    protected int projectCount;

    @Override
    public int getProjectCount() {
        return this.projectCount;
    }

    @Override
    public int getProjects(Collection<Project> dst) {
        int num = 0;
        for (AbstractProjectGroup group : this.groups.values()) {
            num += group.getProjects(dst);
        }
        return num;
    }

    @Override
    public int getProjects(Collection<Project> dst, String groupId) {
        int num = 0;
        ProjectGroup group = this.getGroup(groupId);
        if (group != null) {
            num = group.getProjects(dst);
        }
        return num;
    }

    @Override
    public int getProjects(Collection<Project> dst, String groupId, String projectId) {
        int num = 0;
        ProjectGroup group = this.getGroup(groupId);
        if (group != null) {
            num = group.getProjects(dst, projectId);
        }
        return num;
    }

    @Override
    public int getProjects(Collection<Project> dst, String groupId, String projectId, String version) {
        int num = 0;
        ProjectGroup group = this.getGroup(groupId);
        if (group != null) {
            num = group.getProjects(dst, projectId, version);
        }
        return num;
    }

    @Override
    public int getGroupCount() {
        return this.groups.size();
    }

    @Override
    public int getGroups(Collection<ProjectGroup> dst) {
        int num = 0;
        for (AbstractProjectGroup group : this.groups.values()) {
            dst.add(group);
            ++num;
        }
        return num;
    }

    @Override
    public ProjectGroup getGroup(String id) {
        return this.groups.get(id);
    }

    @Override
    public boolean containsGroup(String id) {
        return this.groups.containsKey(id);
    }

    protected boolean addProject(Project p) {
        String gid = p.getGroupId();
        AbstractProjectGroup group = this.groups.get(gid);
        if (group == null) {
            group = new DefaultProjectGroup(gid);
            this.groups.put(gid, group);
        }
        if (group.addProject(p)) {
            ++this.projectCount;
            return true;
        }
        return false;
    }

    protected boolean removeProject(Project p) {
        String gid = p.getGroupId();
        AbstractProjectGroup group = this.groups.get(gid);
        if (group == null) {
            return false;
        }
        if (group.removeProject(p)) {
            --this.projectCount;
            if (group.getProjectCount() < 1) {
                this.groups.remove(gid);
            }
            return true;
        }
        return false;
    }
}

