/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.project.common;

import com.spacekiller.project.ProjectScope;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractProjectScope
implements ProjectScope {
    protected final String name;
    protected Set<String> classifiers;
    protected Set<String> classifiersUnmodifiable;

    public AbstractProjectScope(String name) {
        this.name = name;
        this.classifiers = new HashSet<String>();
        this.classifiersUnmodifiable = Collections.unmodifiableSet(this.classifiers);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean containsClassifier(String classifier) {
        return this.classifiers.contains(classifier);
    }

    @Override
    public Set<String> getClassifiers() {
        return this.classifiersUnmodifiable;
    }

    protected boolean addClassifier(String classifier) {
        return this.classifiers.add(classifier);
    }

    protected boolean removeClassifier(String classifier) {
        return this.classifiers.remove(classifier);
    }
}

