/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.project.common;

import com.spacekiller.project.ProjectDependency;

public class DefaultProjectDependency
implements ProjectDependency {
    private final String groupId;
    private final String projectId;
    private final String version;
    private final String scope;

    public DefaultProjectDependency(String groupId, String projectId, String version, String scope) {
        this.groupId = groupId;
        this.projectId = projectId;
        this.version = version;
        this.scope = scope;
    }

    public DefaultProjectDependency(String groupId, String projectId, String version) {
        this(groupId, projectId, version, null);
    }

    public DefaultProjectDependency(String groupId, String projectId) {
        this(groupId, projectId, null, null);
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String formatString() {
        String str = this.scope == null ? (this.version == null ? "" : ":" + this.version) : (this.version == null ? "::" + this.scope : ":" + this.version + ":" + this.scope);
        return String.valueOf(this.groupId) + ":" + this.projectId + str;
    }

    public String toString() {
        return super.toString() + "[" + this.formatString() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.projectId == null ? 0 : this.projectId.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultProjectDependency other = (DefaultProjectDependency)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.projectId == null ? other.projectId != null : !this.projectId.equals(other.projectId)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

