/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.edit;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class AbstractLineEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 907672194798870000L;
    private static final Logger logger = Logger.getLogger(AbstractLineEdit.class.getName());
    private AbstractLineWrapper lineWrapper;

    public AbstractLineEdit(AbstractLineWrapper lineWrapper) {
        this.lineWrapper = lineWrapper;
    }

    protected AbstractLineWrapper getLineWrapper() {
        return this.lineWrapper;
    }

    protected void closeLineChunk(Line line, LineChunk chunk) throws IOException {
        MutableLineChunk mutableChunk = null;
        if (chunk != null && chunk instanceof MutableLineChunk) {
            mutableChunk = (MutableLineChunk)chunk;
        }
        if (mutableChunk == null) {
            return;
        }
        try {
            LineModel lineModel = mutableChunk.getLineModel();
            mutableChunk.close();
            if (lineModel != null && lineModel.getChunkCount() < 1) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Closing unused model: " + lineModel + ", line=" + line);
                }
                lineModel.close();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Closed unused model: " + lineModel + ", line=" + line);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void addLineChunk(Line line, LineChunk chunk) throws IOException {
        line.getMutableChunkModel().addChunk(chunk);
    }

    protected void removeLineChunk(Line line, LineChunk chunk) throws IOException {
        line.getMutableChunkModel().removeChunk(chunk);
    }

    protected boolean moveLineChunk(Line line, LineChunk chunk, long newChunkOfs, long newChunkEnd, int newIndex) throws IOException {
        if (line == null) {
            return false;
        }
        if (chunk == null) {
            return false;
        }
        return line.getMutableChunkModel().moveChunk(chunk, newChunkOfs, newChunkEnd, newIndex);
    }

    protected LineChunk[] splitLineChunk(Line line, LineChunk chunk, long splitOfs) throws IOException {
        if (splitOfs < 1L) {
            throw new IllegalArgumentException("Invalid split offset: " + splitOfs + " < 1");
        }
        LineModel model = chunk.getLineModel();
        long chunkOfs = chunk.getChunkOfs();
        long chunkEnd = chunk.getChunkEnd();
        long chunkLen = chunkEnd - chunkOfs;
        if (splitOfs >= chunkLen) {
            throw new IllegalArgumentException("Invalid split offset: " + splitOfs + " >= " + chunkLen);
        }
        long modelOfs = chunk.getModelOfs();
        long modelEnd = chunk.getModelEnd();
        MutableLineChunk part1 = model.createLineChunk(chunkOfs, chunkOfs + splitOfs, modelOfs, Math.min(modelOfs + splitOfs, modelEnd));
        if ((modelOfs += splitOfs) > modelEnd) {
            modelEnd = modelOfs;
        }
        MutableLineChunk part2 = model.createLineChunk(chunkOfs + splitOfs, chunkEnd, modelOfs, modelEnd);
        this.removeLineChunk(line, chunk);
        this.addLineChunk(line, (LineChunk)part1);
        this.addLineChunk(line, (LineChunk)part2);
        return new LineChunk[]{part1, part2};
    }

    private void reverseSampleBufferFrames(SampleBuffer sampleBuffer, int frameIndex, int frameCount) {
        int channels = sampleBuffer.getChannels();
        if (channels < 1) {
            return;
        }
        int halfCount = frameCount / 2;
        if (halfCount < 1) {
            return;
        }
        int x = frameIndex * channels;
        int z = (frameIndex + frameCount - 1) * channels;
        int r = channels * 2;
        for (int i = 0; i < halfCount; ++i) {
            for (int k = 0; k < channels; ++k) {
                double s = sampleBuffer.getDouble(x);
                sampleBuffer.set(x, sampleBuffer.getDouble(z));
                sampleBuffer.set(z, s);
                ++x;
                ++z;
            }
            z -= r;
        }
    }

    private void inverseSampleBufferFrames(SampleBuffer sampleBuffer, int frameIndex, int frameCount) {
        int i;
        int channels = sampleBuffer.getChannels();
        if (channels < 1) {
            return;
        }
        int z = i + frameCount * channels;
        for (i = frameIndex * channels; i < z; ++i) {
            sampleBuffer.set(i, -sampleBuffer.getDouble(i));
        }
    }
}

