/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.edit;

import com.waxmonster.model.LineChunk;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.edit.AbstractLineEdit;
import com.waxmonster.waxlab.edit.WaxLabCannotRedoException;
import com.waxmonster.waxlab.edit.WaxLabCannotUndoException;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import java.io.IOException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class LineChunkMoveEdit
extends AbstractLineEdit {
    private static final long serialVersionUID = -47869837305279038L;
    private Line line;
    private LineChunk chunk;
    private long oldChunkOfs;
    private long oldChunkEnd;
    private int oldIndex;
    private long newChunkOfs;
    private long newChunkEnd;
    private int newIndex;

    public LineChunkMoveEdit(AbstractLineWrapper lineWrapper, Line line, LineChunk chunk, long newChunkOfs, long newChunkEnd, int newIndex) throws IOException {
        super(lineWrapper);
        this.line = line;
        this.chunk = chunk;
        this.oldChunkOfs = chunk.getChunkOfs();
        this.oldChunkEnd = chunk.getChunkEnd();
        this.oldIndex = chunk.getZOrder();
        this.newChunkOfs = newChunkOfs;
        this.newChunkEnd = newChunkEnd;
        this.newIndex = newIndex;
        this.perform();
    }

    protected void perform() throws IOException {
        Line line = this.line;
        if (line == null) {
            return;
        }
        LineChunk chunk = this.chunk;
        if (chunk == null) {
            return;
        }
        this.moveLineChunk(line, chunk, this.newChunkOfs, this.newChunkEnd, this.newIndex);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        Line line = this.line;
        if (line == null) {
            return;
        }
        LineChunk chunk = this.chunk;
        if (chunk == null) {
            return;
        }
        try {
            this.moveLineChunk(line, chunk, this.oldChunkOfs, this.oldChunkEnd, this.oldIndex);
        }
        catch (Exception e) {
            throw new WaxLabCannotUndoException(e);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.perform();
        }
        catch (Exception e) {
            throw new WaxLabCannotRedoException(e);
        }
    }

    @Override
    public void die() {
        super.die();
        this.line = null;
        this.chunk = null;
    }

    public Line getLine() {
        return this.line;
    }

    protected void setLine(Line line) {
        this.line = line;
    }

    public LineChunk getChunk() {
        return this.chunk;
    }

    protected void setChunk(LineChunk chunk) {
        this.chunk = chunk;
    }

    public long getOldChunkOfs() {
        return this.oldChunkOfs;
    }

    protected void setOldChunkOfs(long oldChunkOfs) {
        this.oldChunkOfs = oldChunkOfs;
    }

    public long getOldChunkEnd() {
        return this.oldChunkEnd;
    }

    protected void setOldChunkEnd(long oldChunkEnd) {
        this.oldChunkEnd = oldChunkEnd;
    }

    public long getNewChunkOfs() {
        return this.newChunkOfs;
    }

    protected void setNewChunkOfs(long newChunkOfs) {
        this.newChunkOfs = newChunkOfs;
    }

    public long getNewChunkEnd() {
        return this.newChunkEnd;
    }

    protected void setNewChunkEnd(long newChunkEnd) {
        this.newChunkEnd = newChunkEnd;
    }
}

