/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.edit;

import com.waxmonster.model.LineChunk;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.edit.AbstractLineEdit;
import com.waxmonster.waxlab.edit.WaxLabCannotRedoException;
import com.waxmonster.waxlab.edit.WaxLabCannotUndoException;
import com.waxmonster.waxlab.view.AbstractLineWrapper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class LineChunkRemoveEdit
extends AbstractLineEdit {
    private static final long serialVersionUID = 2445552340627790670L;
    private static final Logger logger = Logger.getLogger(LineChunkRemoveEdit.class.getName());
    private Line line;
    private LineChunk chunk;
    private boolean undone;

    public LineChunkRemoveEdit(AbstractLineWrapper lineWrapper, Line line, LineChunk chunk) throws IOException {
        super(lineWrapper);
        this.line = line;
        this.chunk = chunk;
        this.perform();
    }

    protected void perform() throws IOException {
        Line line = this.line;
        if (line == null) {
            return;
        }
        LineChunk chunk = this.chunk;
        if (chunk == null) {
            return;
        }
        this.removeLineChunk(line, chunk);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        Line line = this.line;
        if (line == null) {
            return;
        }
        LineChunk chunk = this.chunk;
        if (chunk == null) {
            return;
        }
        try {
            this.addLineChunk(line, chunk);
        }
        catch (Exception e) {
            throw new WaxLabCannotUndoException(e);
        }
        finally {
            this.undone = true;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.perform();
        }
        catch (Exception e) {
            throw new WaxLabCannotRedoException(e);
        }
        finally {
            this.undone = false;
        }
    }

    @Override
    public void die() {
        super.die();
        Line line = this.line;
        LineChunk chunk = this.chunk;
        this.line = null;
        this.chunk = null;
        if (!this.undone) {
            try {
                this.closeLineChunk(line, chunk);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public Line getLine() {
        return this.line;
    }

    protected void setLine(Line line) {
        this.line = line;
    }

    public LineChunk getChunk() {
        return this.chunk;
    }

    protected void setChunk(LineChunk chunk) {
        this.chunk = chunk;
    }
}

